/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.QognifyMetadataManagerRepository;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.metadata.MetadataReader;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.SamsungAudioOutServer;
import de.seetec.v5.re.cm.device.video.samsung.SamsungCameraControl;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.device.video.samsung.SamsungMetadataReader;
import de.seetec.v5.re.cm.device.video.samsung.SamsungTriggerHandler;
import de.seetec.v5.re.cm.device.video.samsung.SamsungVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.jpeg.SamsungJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.samsung.mpeg.SamsungH264VideoSourceClient;
import de.seetec.v5.re.shared.CameraOrientation;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.concurrent.locks.ReentrantLock;

public class SamsungCameraSrv
extends LiveCameraSrv {
    private SamsungDevice samsungDevice;
    private final boolean[] profiles = new boolean[10];
    private final Object synObj = new Object();
    private boolean channelParametersHandled = false;
    private final ReentrantLock reentrantLock = new ReentrantLock(false);
    private final ReentrantLock reentrantLockProfiles = new ReentrantLock(false);
    private final ReentrantLock reentrantLockStreams = new ReentrantLock(false);
    private boolean profilesSet = false;

    @Override
    public int initLive() throws UnknownHostException, ConfigurationException {
        int errorCode = super.initLive();
        EdgeStorageParameter edgeStorageParameter = this.getVideoSourceCnf().getEdgeStorageParameter();
        if (edgeStorageParameter != null && edgeStorageParameter.isEnabled()) {
            this.logger.info(this.getSamsungDevice().checkEdgeStorageReady(this.getVideoSourceCnf().getServerEntryNo()));
        }
        return errorCode;
    }

    @Override
    protected MetadataReader createMetadataReader(QognifyMetadataManagerRepository qognifyMetadataManagerRepository) {
        SamsungMetadataReader samsungMetadataReader = null;
        try {
            samsungMetadataReader = new SamsungMetadataReader(this, qognifyMetadataManagerRepository);
            samsungMetadataReader.init(this.device);
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Exception while initializing Metadata Reader for " + this);
        }
        return samsungMetadataReader;
    }

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new SamsungCameraControl();
    }

    @Override
    public final VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        this.reentrantLockStreams.lock();
        VideoSourceClient videoSourceClient = null;
        try {
            this.samsungDevice = (SamsungDevice)this.getDevice();
            this.samsungDevice.setModelInformation();
            String urlPartMultiChannel = "";
            if (this.samsungDevice.getNumberOfVideoSourcesFromDevice() > 1) {
                urlPartMultiChannel = "&Channel=" + (this.getVideoSourceCnf().getServerEntryNo() - 1);
            }
            this.setProfile(urlPartMultiChannel);
            if (this.samsungDevice.isFisheyeCamera()) {
                CameraOrientation orientation = listener.getVideoSourceParameter().getDewarpingOrientation();
                int cameraOrientation = 1;
                switch (orientation) {
                    case CEILING: {
                        cameraOrientation = 1;
                        break;
                    }
                    case TABLE: {
                        cameraOrientation = 2;
                        break;
                    }
                    case WALL: {
                        cameraOrientation = 0;
                        break;
                    }
                    default: {
                        this.logger.error("Orientation " + orientation + " not known for " + this);
                    }
                }
                String cameraOrientationCommand = "<SetFisheyeLens><CamPosition>" + cameraOrientation + "</CamPosition></SetFisheyeLens>";
                String url = "/cgi-bin/stw.cgi";
                NetworkHelper.readPostRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)url, (String)cameraOrientationCommand);
            }
            Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
            this.logger.info("StreamingMode for " + this + " is [" + streamingMode.toString() + "]");
            videoSourceClient = this.samsungDevice.isSunApi_2() ? new SamsungVideoSourceClient() : (streamingMode == Codec.H264 ? new SamsungH264VideoSourceClient() : new SamsungJPEGVideoSourceClient());
            int errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
            this.samsungDevice = (SamsungDevice)this.getDevice();
            this.samsungDevice.setModelInformation();
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        finally {
            this.reentrantLockStreams.unlock();
        }
        return videoSourceClient;
    }

    @Override
    public final ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        return null;
    }

    @Override
    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        SamsungTriggerHandler samsungTriggerHandler = new SamsungTriggerHandler(this);
        try {
            samsungTriggerHandler.setVideoSourceNumber(this.getVideoSourceCnf().getServerEntryNo());
        }
        catch (ConfigurationException | SeeTecException ex) {
            this.logger.error("Exception while creating Samsung Trigger Handler for " + this + ": " + ex.getMessage());
        }
        return samsungTriggerHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getProfileNumber(String codec) {
        Object object = this.synObj;
        synchronized (object) {
            this.profiles[0] = true;
            int i = 2;
            if (codec.equals("H264")) {
                i = 1;
            } else if (codec.equals("H265")) {
                i = 3;
            }
            while (i < this.profiles.length) {
                if (!this.profiles[i]) {
                    this.profiles[i] = true;
                    return i + 1;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isProfileUsed(int profileNumber) {
        boolean result = false;
        Object object = this.synObj;
        synchronized (object) {
            if (profileNumber == 1) {
                result = true;
            } else if (this.profiles.length < profileNumber) {
                result = this.profiles[profileNumber - 1];
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void blockProfile(int profileNumber) {
        Object object = this.synObj;
        synchronized (object) {
            if (profileNumber - 1 < this.profiles.length) {
                this.profiles[profileNumber - 1] = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeProfileNumber(int number) {
        if (number > 0 && number <= this.profiles.length) {
            Object object = this.synObj;
            synchronized (object) {
                this.logger.info(String.format("Release profile number '%s'.", number));
                this.profiles[number - 1] = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setProfile(String urlPartMultichannel) {
        try {
            this.reentrantLockProfiles.lock();
            if (!this.profilesSet) {
                if (this.samsungDevice.isSunApi_2() && (this.samsungDevice.getDeviceEntity().getEntityType() == 201854L || this.samsungDevice.getDeviceEntity().getEntityType() == 206400L || this.samsungDevice.getDeviceEntity().getEntityType() == 206800L)) {
                    String profilesView = this.getSamsungDevice().getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=videoprofile&action=view" + urlPartMultichannel);
                    this.blockProfile(1);
                    for (int i = 3; i <= 10; ++i) {
                        boolean isUse = this.isProfileUsed(i);
                        if (profilesView == null || !profilesView.contains("Profile." + i + ".") || profilesView.contains("Profile." + i + ".Name=VMS") || isUse) continue;
                        String checkCodec = profilesView.contains("Profile." + i + ".EncodingType=MJPEG") ? "H264" : "MJPEG";
                        String url = "/stw-cgi/media.cgi?msubmenu=videoprofile&action=update&Profile=" + i + "&EncodingType=" + checkCodec + urlPartMultichannel;
                        String data = this.getSamsungDevice().getHttpHandler().readGetRequest(url);
                        if (data == null || !data.toLowerCase().startsWith("ng")) continue;
                        this.blockProfile(i);
                    }
                }
                this.profilesSet = true;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while retrieving Stream information for " + this + ": " + ex.getMessage());
        }
        finally {
            this.reentrantLockProfiles.unlock();
        }
        return 0;
    }

    private SamsungDevice getSamsungDevice() {
        if (this.samsungDevice == null && this.device instanceof SamsungDevice) {
            this.samsungDevice = (SamsungDevice)this.device;
        }
        return this.samsungDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int handleChannelParameters(NetworkParameter networkParameter, int rotationAngle, boolean useDateTime, boolean useTitle, String title, String urlPartMultiChannel) {
        int error;
        block57: {
            error = 0;
            try {
                block58: {
                    this.reentrantLock.lock();
                    if (this.channelParametersHandled) break block57;
                    try {
                        if (!this.getSamsungDevice().isSunApi_2() || this.getSamsungDevice().getDeviceType() == 201854L || this.getSamsungDevice().getDeviceType() == 206400L || this.getSamsungDevice().getDeviceType() == 206800L) break block58;
                        String readCaptureMode = "/stw-cgi/media.cgi?msubmenu=videosource&action=view" + urlPartMultiChannel;
                        String setCaptureMode = "/stw-cgi/media.cgi?msubmenu=videosource&action=set" + urlPartMultiChannel;
                        String sensorCaptureSize = "";
                        String sensorCaptureFrameRate = "";
                        String captureModeSeeTec = "";
                        String captureModeOnCamera = this.getSamsungDevice().getHttpHandler().readGetRequest(readCaptureMode);
                        if (captureModeOnCamera != null) {
                            String[] resultLines;
                            for (String resultLine : resultLines = captureModeOnCamera.split("\r\n")) {
                                String[] captureModeInfo;
                                if (resultLine.indexOf("SensorCaptureSize") != -1) {
                                    captureModeInfo = resultLine.split("=");
                                    sensorCaptureSize = captureModeInfo[1];
                                }
                                if (resultLine.indexOf("SensorCaptureFrameRate") == -1) continue;
                                captureModeInfo = resultLine.split("=");
                                sensorCaptureFrameRate = captureModeInfo[1];
                            }
                            String cameraCaptureMode = sensorCaptureSize + "@" + sensorCaptureFrameRate;
                            try {
                                captureModeSeeTec = this.getDevice().getDeviceCnf().getCaptureMode().getResolution();
                                if (captureModeSeeTec == null || captureModeSeeTec.isEmpty()) {
                                    int fps = this.getDevice().getDeviceCnf().getCaptureMode().getMaxFramerate() / 1000;
                                    captureModeSeeTec = "@" + fps;
                                }
                            }
                            catch (ConfigurationException ex) {
                                this.logger.error("Error while getting capture mode for " + this + ": " + ex.getMessage());
                            }
                            if (!cameraCaptureMode.equals(captureModeSeeTec)) {
                                String[] params = captureModeSeeTec.split("@");
                                if (params.length == 2) {
                                    if (!params[0].isEmpty()) {
                                        setCaptureMode = setCaptureMode + "&SensorCaptureSize=" + params[0];
                                    }
                                    setCaptureMode = setCaptureMode + "&SensorCaptureFrameRate=" + params[1];
                                } else {
                                    setCaptureMode = setCaptureMode + "&SensorCaptureFrameRate=" + params[0];
                                }
                                this.getSamsungDevice().getHttpHandler().readGetRequest(setCaptureMode + urlPartMultiChannel);
                            }
                        }
                        Object object = this.synObj;
                        synchronized (object) {
                            String samsungProfiles = this.getSamsungDevice().getHttpHandler().readGetRequest("/stw-cgi/media.cgi?msubmenu=videoprofile&action=view" + urlPartMultiChannel);
                            for (int i = 1; i < 11; ++i) {
                                if (samsungProfiles == null || samsungProfiles.contains("Profile." + i + ".")) continue;
                                String url = "/stw-cgi/media.cgi?msubmenu=videoprofile&action=add&EncodingType=" + ((i & 1) == 1 ? "MJPEG" : "H264") + "&Name=VMS" + i + urlPartMultiChannel;
                                this.getSamsungDevice().getHttpHandler().readGetRequest(url);
                            }
                        }
                    }
                    catch (SeeTecException ex) {
                        this.logger.error((Object)ex, (Throwable)ex);
                        int setCaptureMode = ex.getErrorCode();
                        this.reentrantLock.unlock();
                        return setCaptureMode;
                    }
                }
                StringBuilder imageFlippingContent = new StringBuilder();
                switch (this.getSamsungDevice().getImageFlipType()) {
                    case 1: {
                        if (rotationAngle == 180) {
                            imageFlippingContent.append("/cgi-bin/system.cgi?msubmenu=camera&action=apply&vflip=1&hflip=1");
                            break;
                        }
                        imageFlippingContent.append("/cgi-bin/system.cgi?msubmenu=camera&action=apply&vflip=0&hflip=0");
                        break;
                    }
                    case 2: {
                        if (rotationAngle == 180) {
                            imageFlippingContent.append("/cgi-bin/basic.cgi?submenu=video&action=apply&vflip=1&hflip=1");
                            break;
                        }
                        imageFlippingContent.append("/cgi-bin/basic.cgi?submenu=video&action=apply&vflip=0&hflip=0");
                        break;
                    }
                    case 3: {
                        if (rotationAngle == 180) {
                            imageFlippingContent.append("/cgi-bin/system.cgi?msubmenu=camera&action=apply&flipmode=1");
                            break;
                        }
                        imageFlippingContent.append("/cgi-bin/system.cgi?msubmenu=camera&action=apply&flipmode=0");
                        break;
                    }
                    case 4: {
                        if (rotationAngle == 180) {
                            imageFlippingContent.append("/cgi-bin/system.cgi?msubmenu=camera&action=apply&hflip=1");
                            break;
                        }
                        imageFlippingContent.append("/cgi-bin/system.cgi?msubmenu=camera&action=apply&hflip=0");
                        break;
                    }
                    case 5: {
                        String[] names = new String[]{"HorizontalFlipEnable", "VerticalFlipEnable"};
                        String[] namesRotate = new String[]{"Rotate"};
                        String[] values = new String[]{"True", "True"};
                        String[] valuesRotate = new String[]{"0"};
                        if (rotationAngle == 0) {
                            values[1] = "False";
                            values[0] = "False";
                        } else if (rotationAngle == 90 || rotationAngle == 270) {
                            values[1] = "False";
                            values[0] = "False";
                            valuesRotate[0] = Integer.toString(rotationAngle);
                        }
                        this.getSamsungDevice().checkAndSetParameters("image", "flip", names, values, urlPartMultiChannel);
                        this.getSamsungDevice().checkAndSetParameters("image", "flip", namesRotate, valuesRotate, urlPartMultiChannel);
                        this.getSamsungDevice().setImageFlipType(-1);
                        break;
                    }
                }
                if (this.getSamsungDevice().getImageFlipType() > 0) {
                    try {
                        this.getSamsungDevice().getHttpHandler().readGetRequest(imageFlippingContent.toString() + urlPartMultiChannel);
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception occured while setting image flipping on camera: " + (Object)((Object)ex));
                        error = ex.getErrorCode();
                    }
                }
                try {
                    String setOverlay;
                    String tmpTitle = title;
                    try {
                        tmpTitle = URLDecoder.decode(tmpTitle, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.logger.warn("Exception while setting channel title for " + this + " : " + ex.getMessage());
                    }
                    for (int i = 0; i < tmpTitle.length(); ++i) {
                        char ch = tmpTitle.charAt(i);
                        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '.') continue;
                        tmpTitle = tmpTitle.replace(ch, '.');
                    }
                    if (this.getSamsungDevice().isSunApi_2()) {
                        if (this.getSamsungDevice().readDeviceInfo().get("DeviceType").equals("NWC")) {
                            setOverlay = "/stw-cgi/image.cgi?msubmenu=overlay&action=set" + urlPartMultiChannel;
                            setOverlay = setOverlay + "&TimeEnable=" + (useDateTime ? "True" : "False");
                            setOverlay = setOverlay + "&TitleEnable=" + (useTitle ? "True" : "False");
                            if (useTitle) {
                                setOverlay = setOverlay + "&Title=" + tmpTitle;
                            }
                        } else {
                            setOverlay = "/stw-cgi/image.cgi?msubmenu=multilineosd&action=update&Index=1" + urlPartMultiChannel;
                            setOverlay = setOverlay + "&OSDType=Title&Enable=" + (useTitle ? "True" : "False");
                            if (useTitle) {
                                setOverlay = setOverlay + "&OSD=" + tmpTitle;
                            }
                            this.getSamsungDevice().getHttpHandler().readGetRequest(setOverlay);
                            setOverlay = "/stw-cgi/image.cgi?msubmenu=multilineosd&action=update&Index=2" + urlPartMultiChannel;
                            setOverlay = setOverlay + "&OSDType=Date&Enable=" + (useDateTime ? "True" : "False");
                        }
                        this.getSamsungDevice().getHttpHandler().readGetRequest(setOverlay);
                    } else {
                        setOverlay = "/cgi-bin/system.cgi?msubmenu=camera&action=apply";
                        setOverlay = setOverlay + "&time_display=" + (useDateTime ? "1" : "0");
                        setOverlay = setOverlay + "&camera_title_mode=" + (useTitle ? "1" : "0");
                        if (useTitle) {
                            setOverlay = setOverlay + "&camera_title=" + tmpTitle;
                        }
                        this.getSamsungDevice().getHttpHandler().readGetRequest(setOverlay);
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while setting overlay for " + this + ", " + ex.getMessage());
                }
                if (this.getSamsungDevice().isMultiMode()) {
                    String readCaptureMode = "/cgi-bin/basic.cgi?msubmenu=video&action=view2";
                    String setCaptureMode = "/cgi-bin/basic.cgi?msubmenu=video&action=change&video_select=";
                    try {
                        String deviceCaptureMode = this.getSamsungDevice().getHttpHandler().readGetRequest(readCaptureMode);
                        if (deviceCaptureMode != null) {
                            String[] resultLines;
                            for (String resultLine : resultLines = deviceCaptureMode.split("\r\n")) {
                                String[] captureModes;
                                if (resultLine.indexOf("video_select") == -1 || (captureModes = resultLine.split(":")).length != 2) continue;
                                this.getSamsungDevice().setCaptureMode(Integer.parseInt(captureModes[1]));
                            }
                        }
                        try {
                            this.getSamsungDevice().setCaptureModeInSeetec(Integer.parseInt(this.device.getDeviceCnf().getCaptureMode().getDisplayResolution().split("MP")[0]));
                        }
                        catch (ConfigurationException ex) {
                            this.logger.error("Error while getting capture mode for " + this + ": " + ex.getMessage());
                        }
                        if (this.getSamsungDevice().getCaptureMode() != this.getSamsungDevice().getCaptureModeInSeetec()) {
                            this.getSamsungDevice().getHttpHandler().readGetRequest(setCaptureMode + this.getSamsungDevice().getCaptureModeInSeetec());
                        }
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception while reading capture mode on camera for " + this + ": " + ex.getMessage());
                    }
                }
                this.channelParametersHandled = true;
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
        return error;
    }

    @Override
    protected SamsungAudioOutServer createAudioOutServer() {
        NetworkParameter networkParameter = null;
        int channelNumber = 1;
        int numberOfVideoSources = 1;
        try {
            networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
            channelNumber = this.getVideoSourceCnf().getServerEntryNo() - 1;
            numberOfVideoSources = this.getSamsungDevice().getNumberOfVideoSourcesFromDevice();
        }
        catch (Exception ex) {
            this.logger.error("Could not read Network parameter [" + ex.getMessage() + "] for " + this);
        }
        TransmissionType transmissionID = TransmissionType.RTP_OVER_RTSP_OVER_TCP;
        int rtspPort = 554;
        SamsungAudioOutServer samsungAudioOutServer = new SamsungAudioOutServer(networkParameter, rtspPort, transmissionID, channelNumber, numberOfVideoSources);
        samsungAudioOutServer.init();
        return samsungAudioOutServer;
    }
}

