/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.CameraPreset;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.samsung.SamsungCameraSrv;
import de.seetec.v5.re.cm.device.video.samsung.SamsungDevice;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HttpHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SamsungCameraControl
extends CameraControl {
    private int tiltTolerance = 5000;
    private int panTolerance = 5000;
    private int minInterval = 300;
    private SamsungDevice samsungDevice = null;
    private int oldZoom;
    private long time = System.currentTimeMillis();
    private String previousCommand = "";
    private int zoomDirection = 2;
    private int oldZoomDirection;
    private int ptzMode;
    private int previousZoomDirection = 2;
    private boolean zoomStopped = true;
    private int errorCode;
    private boolean ptStopped;
    private String previousDirection = "";
    private List<String> supportedIrisValues = null;
    private boolean isManualIrisSet = false;
    private boolean isManualFocusSet = false;
    private int videoSourceNumber;

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        if (this.samsungDevice == null && videoSrv instanceof SamsungCameraSrv && videoSrv.getDevice() instanceof SamsungDevice) {
            this.samsungDevice = (SamsungDevice)videoSrv.getDevice();
        }
        try {
            this.videoSourceNumber = videoSrv.getVideoSourceCnf().getServerEntryNo();
            if (this.samsungDevice != null) {
                FeaturesType features = this.samsungDevice.getVideoCameraDefinitionFromDevice().getFeatures();
                this.ptzInfo = new PtzInfo();
                this.ptzInfo.setMinZoom(features.getMinAbsoluteZoom());
                this.ptzInfo.setMaxZoom(features.getMaxAbsoluteZoom());
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while getting video source number from configuration for " + this + " : " + ex.getMessage());
        }
        this.errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        this.getAbsolutePosition(true);
        return this.errorCode;
    }

    protected HttpHandler getHttpHandler() {
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
        }
        return this.samsungDevice.getHttpHandler();
    }

    private void getAbsolutePosition(boolean sendStatus) {
        VideoCameraDefinition config = this.videoSrv.getDevice().getVideoCameraDefinitionFromConfiguration();
        if (config == null || !config.getFeatures().isCanAbsoluteZoom()) {
            return;
        }
        try {
            String[] results;
            String url = "/stw-cgi/ptzcontrol.cgi?msubmenu=query&action=view&Channel=" + (this.videoSourceNumber - 1) + "&Query=Pan,Tilt,Zoom";
            String result = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE));
            block12: for (String element : results = result.split("\r\n")) {
                String[] keyValue = element.split("=");
                if (keyValue.length != 2) continue;
                switch (keyValue[0].toLowerCase()) {
                    case "pan": {
                        float pan = Float.parseFloat(keyValue[1]);
                        this.ptzInfo.setPan((int)pan);
                        continue block12;
                    }
                    case "tilt": {
                        float tilt = Float.parseFloat(keyValue[1]);
                        this.ptzInfo.setTilt((int)tilt);
                        continue block12;
                    }
                    case "zoom": {
                        float zoom = Float.parseFloat(keyValue[1]);
                        this.ptzInfo.setZoom((int)zoom);
                        continue block12;
                    }
                }
            }
            this.logger.info("Absolute position: [" + Basic.longToFormattedString((long)this.ptzInfo.getPan()) + "]/[" + Basic.longToFormattedString((long)this.ptzInfo.getTilt()) + "]/[" + Basic.longToFormattedString((long)this.ptzInfo.getZoom()) + "] for " + this);
            if (sendStatus) {
                this.videoSrv.sendStatusAbsolutePTZ(null, this.ptzInfo.getPan(), this.ptzInfo.getTilt(), this.ptzInfo.getZoom());
            }
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        try {
            StringBuilder url = new StringBuilder("/stw-cgi/ptzcontrol.cgi?msubmenu=absolute&action=control&Channel=");
            url.append(this.videoSourceNumber - 1);
            url.append("&Pan=").append(pan);
            url.append("&Tilt=").append(tilt);
            url.append("&Zoom=").append(zoom);
            this.errorCode = this.sendCameraCommand(url.toString());
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            this.ptzInfo.setPan(pan);
            this.ptzInfo.setTilt(tilt);
            this.ptzInfo.setZoom(zoom);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
            return -21600;
        }
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        try {
            StringBuilder url = new StringBuilder("/stw-cgi/ptzcontrol.cgi?msubmenu=absolute&action=control&Channel=");
            url.append(this.videoSourceNumber - 1);
            url.append("&Zoom=").append(zoom);
            this.errorCode = this.sendCameraCommand(url.toString());
            if (this.errorCode != 0) {
                return this.errorCode;
            }
            this.ptzInfo.setZoom(zoom);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
            return -21600;
        }
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
        }
        this.ptzMode = this.samsungDevice.getPtzMode();
        if (this.ptzMode == 1) {
            int tilt;
            int pan;
            this.panTolerance = 20000;
            this.tiltTolerance = 20000;
            this.minInterval = 600;
            if (panSpeed != null) {
                this.previousPanSpeed = pan = panSpeed.intValue();
            } else {
                pan = this.previousPanSpeed;
            }
            if (tiltSpeed != null) {
                this.previousTiltSpeed = tilt = tiltSpeed.intValue();
            } else {
                tilt = this.previousTiltSpeed;
            }
            if (zoomSpeed != null) {
                this.zoomDirection = zoomSpeed < 0 ? 1 : (zoomSpeed > 0 ? 3 : 2);
                this.previousZoomDirection = this.zoomDirection;
            } else {
                this.zoomDirection = this.previousZoomDirection;
            }
            String url = "/cgi-bin/ptz.cgi?";
            StringBuilder ptCommand = new StringBuilder(256);
            ptCommand.append("mode=ptz&move=");
            if (tilt == 0 && pan == 0) {
                ptCommand.append("stop");
                if (!this.ptStopped && (this.errorCode = this.sendCameraCommand(url + ptCommand.toString())) != 0) {
                    this.logger.error("Error while sending Pan-Tilt Command for " + this + ". Errorcode: " + this.errorCode);
                }
                this.ptStopped = true;
            } else {
                this.ptStopped = false;
                int speed = 0;
                if (Math.abs(tilt) <= this.tiltTolerance && Math.abs(pan) <= this.panTolerance) {
                    if (tilt > 0 && pan > 0) {
                        ptCommand.append("rightup");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    } else if (tilt == 0 && pan > 0) {
                        ptCommand.append("right");
                        speed = Math.abs(pan);
                    } else if (tilt < 0 && pan > 0) {
                        ptCommand.append("rightdown");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    } else if (tilt < 0 && pan == 0) {
                        ptCommand.append("down");
                        speed = Math.abs(tilt);
                    } else if (tilt < 0 && pan < 0) {
                        ptCommand.append("leftdown");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    } else if (tilt == 0 && pan < 0) {
                        ptCommand.append("left");
                        speed = Math.abs(pan);
                    } else if (tilt > 0 && pan < 0) {
                        ptCommand.append("leftup");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    } else if (tilt > 0 && pan == 0) {
                        ptCommand.append("up");
                        speed = Math.abs(tilt);
                    }
                } else if (tilt > this.tiltTolerance && pan > this.panTolerance) {
                    ptCommand.append("rightup");
                    speed = Math.max(Math.abs(pan), Math.abs(tilt));
                } else if (Math.abs(tilt) <= this.tiltTolerance && pan > this.panTolerance) {
                    ptCommand.append("right");
                    speed = Math.abs(pan);
                } else if (tilt <= -1 * this.tiltTolerance && pan > this.panTolerance) {
                    ptCommand.append("rightdown");
                    speed = Math.max(Math.abs(pan), Math.abs(tilt));
                } else if (tilt <= -1 * this.tiltTolerance && Math.abs(pan) <= this.panTolerance) {
                    ptCommand.append("down");
                    speed = Math.abs(tilt);
                } else if (tilt <= -1 * this.tiltTolerance && pan <= -1 * this.panTolerance) {
                    ptCommand.append("leftdown");
                    speed = Math.max(Math.abs(pan), Math.abs(tilt));
                } else if (Math.abs(tilt) <= this.tiltTolerance && pan <= -1 * this.panTolerance) {
                    ptCommand.append("left");
                    speed = Math.abs(pan);
                } else if (tilt > this.tiltTolerance && pan <= -1 * this.panTolerance) {
                    ptCommand.append("leftup");
                    speed = Math.max(Math.abs(pan), Math.abs(tilt));
                } else if (tilt > this.tiltTolerance && Math.abs(pan) <= this.panTolerance) {
                    ptCommand.append("up");
                    speed = Math.abs(tilt);
                }
                speed = speed / 16666 + 1;
                speed = speed < 1 ? 1 : speed;
                speed = speed > 6 ? 6 : speed;
                ptCommand.append("&speed=").append(speed);
                this.errorCode = this.sendCameraCommand(url + ptCommand.toString());
                if (this.errorCode != 0) {
                    this.logger.error("Error while sending Pan-Tilt Command for " + this + ". Errorcode: " + this.errorCode);
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("zoom=");
            if (this.zoomDirection == 1) {
                sb.append("out");
            } else if (this.zoomDirection == 3) {
                sb.append("in");
            } else if (this.zoomDirection == 2) {
                sb.append("stop");
            }
            if (this.zoomStopped && this.zoomDirection == 2) {
                return 0;
            }
            this.zoomStopped = this.zoomDirection == 2;
            this.sendCameraCommand(url + sb.toString());
            this.oldZoomDirection = this.zoomDirection;
        } else if (this.ptzMode == 2) {
            int zoom;
            int tilt;
            int pan;
            this.panTolerance = 10000;
            this.tiltTolerance = 10000;
            this.minInterval = 200;
            if (panSpeed != null) {
                this.previousPanSpeed = pan = panSpeed.intValue();
            } else {
                pan = this.previousPanSpeed;
            }
            if (tiltSpeed != null) {
                this.previousTiltSpeed = tilt = tiltSpeed.intValue();
            } else {
                tilt = this.previousTiltSpeed;
            }
            if (zoomSpeed != null) {
                this.zoomDirection = zoomSpeed < 0 ? 1 : (zoomSpeed > 0 ? 3 : 2);
                zoom = Math.abs(zoomSpeed / 25000);
                zoom = zoom < 1 ? 1 : zoom;
                int n = zoom = zoom > 4 ? 4 : zoom;
                if (zoomSpeed == 0) {
                    zoom = 0;
                }
                this.previousZoomSpeed = zoom;
            } else {
                zoom = this.previousZoomSpeed;
            }
            String url = "/cgi-bin/ptz.cgi?";
            this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
            if (panSpeed != null || tiltSpeed != null) {
                StringBuilder ptCommand = new StringBuilder(256);
                ptCommand.append("mode=ptz&move=");
                if (tilt == 0 && pan == 0) {
                    ptCommand.append("stop");
                    this.errorCode = this.sendCameraCommand(url + ptCommand.toString());
                    if (this.errorCode != 0) {
                        this.logger.error("Error while sending Pan-Tilt Command for " + this + " Errorcode: " + this.errorCode);
                    }
                    if ((this.errorCode = this.sendCameraCommand(url + ptCommand.toString())) != 0) {
                        this.logger.error("Error while sending Pan-Tilt Command for " + this + " Errorcode: " + this.errorCode);
                    }
                } else {
                    int speed = 0;
                    if (Math.abs(tilt) < this.tiltTolerance && Math.abs(pan) < this.panTolerance) {
                        if (tilt > 0 && pan > 0) {
                            ptCommand.append("rightup");
                            speed = Math.max(Math.abs(pan), Math.abs(tilt));
                        } else if (tilt == 0 && pan > 0) {
                            ptCommand.append("right");
                            speed = Math.abs(pan);
                        } else if (tilt < 0 && pan > 0) {
                            ptCommand.append("rightdown");
                            speed = Math.max(Math.abs(pan), Math.abs(tilt));
                        } else if (tilt < 0 && pan == 0) {
                            ptCommand.append("down");
                            speed = Math.abs(tilt);
                        } else if (tilt < 0 && pan < 0) {
                            ptCommand.append("leftdown");
                            speed = Math.max(Math.abs(pan), Math.abs(tilt));
                        } else if (tilt == 0 && pan < 0) {
                            ptCommand.append("left");
                            speed = Math.abs(pan);
                        } else if (tilt > 0 && pan < 0) {
                            ptCommand.append("leftup");
                            speed = Math.max(Math.abs(pan), Math.abs(tilt));
                        } else if (tilt > 0 && pan == 0) {
                            ptCommand.append("up");
                            speed = Math.abs(tilt);
                        }
                    } else if (tilt > this.tiltTolerance && pan > this.panTolerance) {
                        ptCommand.append("rightup");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    } else if (Math.abs(tilt) < this.tiltTolerance && pan > this.panTolerance) {
                        ptCommand.append("right");
                        speed = Math.abs(pan);
                    } else if (tilt < -1 * this.tiltTolerance && pan > this.panTolerance) {
                        ptCommand.append("rightdown");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    } else if (tilt < -1 * this.tiltTolerance && Math.abs(pan) < this.panTolerance) {
                        ptCommand.append("down");
                        speed = Math.abs(tilt);
                    } else if (tilt < -1 * this.tiltTolerance && pan < -1 * this.panTolerance) {
                        ptCommand.append("leftdown");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    } else if (Math.abs(tilt) < this.tiltTolerance && pan < -1 * this.panTolerance) {
                        ptCommand.append("left");
                        speed = Math.abs(pan);
                    } else if (tilt > this.tiltTolerance && pan < -1 * this.panTolerance) {
                        ptCommand.append("leftup");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    } else if (tilt > this.tiltTolerance && Math.abs(pan) < this.panTolerance) {
                        ptCommand.append("up");
                        speed = Math.abs(tilt);
                    }
                    speed = speed < 5000 ? 2 : (speed < 25000 ? 3 : (speed < 50000 ? 4 : (speed < 85000 ? 5 : 6)));
                    ptCommand.append("&speed=").append(speed);
                    this.errorCode = this.sendCameraCommand(url + ptCommand.toString());
                    if (this.errorCode != 0) {
                        this.logger.error("Error while sending Pan-Tilt Command for " + this + " Errorcode: " + this.errorCode);
                    }
                }
            }
            if (zoomSpeed != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("zoom=");
                if (this.oldZoom != zoom || this.oldZoomDirection != this.zoomDirection) {
                    switch (this.zoomDirection) {
                        case 1: {
                            sb.append("out&speed=").append(zoom);
                            break;
                        }
                        case 3: {
                            sb.append("in&speed=").append(zoom);
                            break;
                        }
                        default: {
                            sb.append("stop");
                        }
                    }
                    this.sendCameraCommand(url + sb.toString());
                    this.oldZoom = zoom;
                    this.oldZoomDirection = this.zoomDirection;
                }
            }
        } else if (this.ptzMode == 3) {
            int tilt;
            int pan;
            this.panTolerance = 10000;
            this.tiltTolerance = 10000;
            this.minInterval = 150;
            int zoom = 0;
            if (panSpeed != null) {
                this.previousPanSpeed = pan = panSpeed.intValue();
            } else {
                pan = this.previousPanSpeed;
            }
            if (tiltSpeed != null) {
                this.previousTiltSpeed = tilt = tiltSpeed.intValue();
            } else {
                tilt = this.previousTiltSpeed;
            }
            if (zoomSpeed != null) {
                this.zoomDirection = zoomSpeed < 0 ? 1 : (zoomSpeed > 0 ? 3 : 2);
                zoom = Math.abs(zoomSpeed) < 25000 ? 1 : (Math.abs(zoomSpeed) < 50000 ? 2 : (Math.abs(zoomSpeed) < 75000 ? 3 : 4));
                this.previousZoomDirection = this.zoomDirection;
            } else {
                this.zoomDirection = this.previousZoomDirection;
            }
            String url = "/cgi-bin/ptzmove.cgi?";
            StringBuilder ptCommand = new StringBuilder(256);
            ptCommand.append("move=");
            if (tilt == 0 && pan == 0) {
                ptCommand.append("stop");
                if (!this.ptStopped && (this.errorCode = this.sendCameraCommand(url + ptCommand.toString())) != 0) {
                    this.logger.error("Error while sending Pan-Tilt Command for " + this + ". Errorcode: " + this.errorCode);
                }
                this.previousDirection = "stop";
                this.ptStopped = true;
            } else {
                this.ptStopped = false;
                int speed = 0;
                if (Math.abs(tilt) <= this.tiltTolerance && Math.abs(pan) <= this.panTolerance) {
                    if (tilt > 0 && pan > 0) {
                        ptCommand.append("rightup");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                        this.previousDirection = "rightup";
                    } else if (tilt == 0 && pan > 0) {
                        ptCommand.append("right");
                        speed = Math.abs(pan);
                        this.previousDirection = "right";
                    } else if (tilt < 0 && pan > 0) {
                        ptCommand.append("rightdown");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                        this.previousDirection = "rightdown";
                    } else if (tilt < 0 && pan == 0) {
                        if (this.previousDirection.equals("rightdown") || this.previousDirection.equals("leftdown")) {
                            return 0;
                        }
                        ptCommand.append("down");
                        speed = Math.abs(tilt);
                        this.previousDirection = "down";
                    } else if (tilt < 0 && pan < 0) {
                        ptCommand.append("leftdown");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                        this.previousDirection = "leftdown";
                    } else if (tilt == 0 && pan < 0) {
                        ptCommand.append("left");
                        speed = Math.abs(pan);
                        this.previousDirection = "left";
                    } else if (tilt > 0 && pan < 0) {
                        ptCommand.append("leftup");
                        speed = Math.max(Math.abs(pan), Math.abs(tilt));
                        this.previousDirection = "leftup";
                    } else if (tilt > 0 && pan == 0) {
                        if (this.previousDirection.equals("rightup") || this.previousDirection.equals("leftup")) {
                            return 0;
                        }
                        ptCommand.append("up");
                        speed = Math.abs(tilt);
                        this.previousDirection = "up";
                    }
                } else if (tilt > this.tiltTolerance && pan > this.panTolerance) {
                    ptCommand.append("rightup");
                    speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    this.previousDirection = "rightup";
                } else if (Math.abs(tilt) <= this.tiltTolerance && pan > this.panTolerance) {
                    ptCommand.append("right");
                    speed = Math.abs(pan);
                    this.previousDirection = "right";
                } else if (tilt <= -1 * this.tiltTolerance && pan > this.panTolerance) {
                    ptCommand.append("rightdown");
                    speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    this.previousDirection = "rightdown";
                } else if (tilt <= -1 * this.tiltTolerance && Math.abs(pan) <= this.panTolerance) {
                    if (this.previousDirection.equals("rightdown") || this.previousDirection.equals("leftdown")) {
                        return 0;
                    }
                    ptCommand.append("down");
                    speed = Math.abs(tilt);
                    this.previousDirection = "down";
                } else if (tilt <= -1 * this.tiltTolerance && pan <= -1 * this.panTolerance) {
                    ptCommand.append("leftdown");
                    speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    this.previousDirection = "leftdown";
                } else if (Math.abs(tilt) <= this.tiltTolerance && pan <= -1 * this.panTolerance) {
                    ptCommand.append("left");
                    speed = Math.abs(pan);
                    this.previousDirection = "left";
                } else if (tilt > this.tiltTolerance && pan <= -1 * this.panTolerance) {
                    ptCommand.append("leftup");
                    speed = Math.max(Math.abs(pan), Math.abs(tilt));
                    this.previousDirection = "leftup";
                } else if (tilt > this.tiltTolerance && Math.abs(pan) <= this.panTolerance) {
                    if (this.previousDirection.equals("rightup") || this.previousDirection.equals("leftup")) {
                        return 0;
                    }
                    ptCommand.append("up");
                    speed = Math.abs(tilt);
                    this.previousDirection = "up";
                }
                if (speed > 1) {
                    speed = speed < 10000 ? 2 : (speed < 35000 ? 3 : (speed < 65000 ? 4 : 5));
                }
                ptCommand.append("&speed=").append(speed);
                this.errorCode = this.sendCameraCommand(url + ptCommand.toString());
                if (this.errorCode != 0) {
                    this.logger.error("Error while sending Pan-Tilt Command for " + this + ". Errorcode: " + this.errorCode);
                }
            }
            if (zoomSpeed != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("zoom=");
                switch (this.zoomDirection) {
                    case 1: {
                        sb.append("out&speed=").append(zoom);
                        break;
                    }
                    case 3: {
                        sb.append("in&speed=").append(zoom);
                        break;
                    }
                    case 2: {
                        sb.append("stop");
                        break;
                    }
                }
                if (this.zoomStopped && this.zoomDirection == 2) {
                    return 0;
                }
                this.zoomStopped = this.zoomDirection == 2;
                this.sendCameraCommand(url + sb.toString());
                this.oldZoomDirection = this.zoomDirection;
            }
        } else if (this.ptzMode == 4) {
            String url;
            this.minInterval = 0;
            if (zoomSpeed != null) {
                int zoom = zoomSpeed > 75000 ? 4 : (zoomSpeed > 50000 ? 3 : (zoomSpeed > 25000 ? 2 : (zoomSpeed > 0 ? 1 : (zoomSpeed == 0 ? 0 : (zoomSpeed > -25000 ? -1 : (zoomSpeed > -50000 ? -2 : (zoomSpeed > -75000 ? -3 : -4)))))));
                this.previousZoomSpeed = zoom;
            }
            if (tiltSpeed != null) {
                int tilt = tiltSpeed > 90000 ? 6 : (tiltSpeed > 65000 ? 5 : (tiltSpeed > 45000 ? 4 : (tiltSpeed > 30000 ? 3 : (tiltSpeed > 15000 ? 2 : (tiltSpeed > 0 ? 1 : (tiltSpeed == 0 ? 0 : (tiltSpeed > -15000 ? -1 : (tiltSpeed > -30000 ? -2 : (tiltSpeed > -45000 ? -3 : (tiltSpeed > -65000 ? -4 : (tiltSpeed > -90000 ? -5 : -6)))))))))));
                this.previousTiltSpeed = tilt;
            }
            if (panSpeed != null) {
                int pan = panSpeed > 80000 ? 6 : (panSpeed > 60000 ? 5 : (panSpeed > 40000 ? 4 : (panSpeed > 20000 ? 3 : (panSpeed > 10000 ? 2 : (panSpeed > 0 ? 1 : (panSpeed == 0 ? 0 : (panSpeed > -10000 ? -1 : (panSpeed > -20000 ? -2 : (panSpeed > -40000 ? -3 : (panSpeed > -60000 ? -4 : (panSpeed > -80000 ? -5 : -6)))))))))));
                this.previousPanSpeed = pan;
            }
            if ((this.errorCode = this.sendCameraCommand(url = "/cgi-bin/ptzmove.cgi?pan=" + this.previousPanSpeed + "&tilt=" + this.previousTiltSpeed + "&z=" + this.previousZoomSpeed)) != 0) {
                this.logger.error("Error while sending Pan-Tilt Command for " + this + ". Errorcode: " + this.errorCode);
            }
        } else if (this.ptzMode == 5) {
            String url;
            this.minInterval = 0;
            int videoSource = 0;
            try {
                videoSource = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while reading Video Source Number for " + this + ". Using video source 0");
            }
            if (zoomSpeed != null) {
                int zoom;
                this.previousZoomSpeed = zoom = zoomSpeed / 1000;
            }
            if (tiltSpeed != null) {
                int tilt;
                this.previousTiltSpeed = tilt = (int)this.adaptPanTiltValues(tiltSpeed);
            }
            if (panSpeed != null) {
                int pan;
                this.previousPanSpeed = pan = (int)this.adaptPanTiltValues(panSpeed);
            }
            if ((this.errorCode = this.sendCameraCommand(url = "/stw-cgi/ptzcontrol.cgi?msubmenu=continuous&action=control&NormalizedSpeed=True&Channel=" + videoSource + "&Pan=" + this.previousPanSpeed + "&Tilt=" + this.previousTiltSpeed + "&Zoom=" + this.previousZoomSpeed)) != 0) {
                this.logger.error("Error while sending Pan-Tilt Command for " + this + ". Errorcode: " + this.errorCode);
            }
        }
        this.getAbsolutePosition(false);
        return 0;
    }

    protected double adaptPanTiltValues(int pt) {
        int panTilt = pt;
        int sign = 0;
        int multiplier = 1;
        if (panTilt < 0) {
            sign = -1;
        } else if (panTilt > 0) {
            sign = 1;
        }
        panTilt /= 1000;
        panTilt = Math.abs(panTilt);
        multiplier = panTilt < 15 ? sign * 1 : (panTilt < 25 ? sign * 40 : (panTilt < 30 ? sign * 60 : (panTilt < 40 ? sign * 70 : (panTilt < 50 ? sign * 75 : (panTilt < 60 ? sign * 80 : (panTilt < 70 ? sign * 85 : (panTilt < 80 ? sign * 90 : sign * 100)))))));
        return multiplier;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        int videoSource = 0;
        try {
            videoSource = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while reading Video Source Number for " + this + ". Using video source 0");
        }
        try {
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
            }
            if (this.samsungDevice.isSunApi_2()) {
                String channel = videoSource > 0 ? "&Channel=" + videoSource : "";
                int x = xPosition * 100;
                int y = yPosition * 100;
                String url = String.format("stw-cgi/ptzcontrol.cgi?msubmenu=areazoom&Type=ZoomIn" + channel + "&action=control&X1=%d&X2=%d&Y1=%d&Y2=%d&TileWidth=10000&TileHeight=10000", x, x, y, y);
                return this.sendCameraCommand(url, false);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
        }
        return 0;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        int videoSource = 0;
        try {
            videoSource = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while reading Video Source Number for " + this + ". Using video source 0");
        }
        int x1 = xPosition * 100;
        int x2 = (xPosition + width) * 100;
        int y1 = yPosition * 100;
        int y2 = (yPosition + height) * 100;
        String url = "/stw-cgi/ptzcontrol.cgi?msubmenu=areazoom&action=control&Channel=" + videoSource + "&X1=" + x1 + "&X2=" + x2 + "&Y1=" + y1 + "&Y2=" + y2;
        return this.sendCameraCommand(url, false);
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
        }
        if (value != null && value != 0) {
            if (!this.isManualIrisSet) {
                this.setAutoIris(false);
                this.isManualIrisSet = true;
            }
            try {
                if (this.samsungDevice.isSunApi_2()) {
                    try {
                        String newIrisValue;
                        int idx;
                        String cameraParameters = this.getHttpHandler().readGetRequest("/stw-cgi/image.cgi?msubmenu=camera&action=view");
                        int videoSourceNr = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                        String irisFNo = this.samsungDevice.readCameraParameters(null, "Channel\\." + (videoSourceNr - 1) + "\\.IrisFno", cameraParameters);
                        String irisMode = this.samsungDevice.readCameraParameters(null, "Channel\\." + (videoSourceNr - 1) + "\\.IrisMode", cameraParameters);
                        if (this.supportedIrisValues == null) {
                            this.supportedIrisValues = this.samsungDevice.getAttributesFromEnum("image/camera/set/IrisFno", this.samsungDevice.getAttributesDoc());
                        }
                        if ((idx = this.supportedIrisValues.indexOf(irisFNo)) == -1) {
                            this.logger.error(String.format("Iris %s not found in list of supported iris values %s: Firmware problem.", irisFNo, this.supportedIrisValues));
                        } else {
                            if (value > 0 && idx > 0) {
                                --idx;
                            }
                            if (value < 0 && idx < this.supportedIrisValues.size() - 1) {
                                ++idx;
                            }
                        }
                        String string = newIrisValue = idx < 0 ? irisFNo : this.supportedIrisValues.get(idx);
                        if (!irisMode.equalsIgnoreCase("manual")) {
                            this.getHttpHandler().readGetRequest("/stw-cgi/image.cgi?msubmenu=camera&action=set&IrisMode=Manual");
                        }
                        this.logger.info(String.format("Set Iris for %s to %s", this, newIrisValue));
                        this.getHttpHandler().readGetRequest("/stw-cgi/image.cgi?msubmenu=camera&action=set&IrisFno=" + newIrisValue);
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception while setting iris for " + this);
                        this.logger.error((Object)ex, (Throwable)ex);
                    }
                    catch (ConfigurationException ex) {
                        this.logger.error("Exception while reading configurastion for " + this);
                        this.logger.error((Object)ex, (Throwable)ex);
                    }
                } else {
                    try {
                        this.getHttpHandler().readGetRequest("/cgi-bin/system.cgi?msubmenu=camera&action=apply&iris=1");
                        String cameraParameters = this.getHttpHandler().readGetRequest("/cgi-bin/system.cgi?msubmenu=camera&action=view");
                        String irisFNo = this.samsungDevice.readCameraParameters(null, "iris_manual", cameraParameters);
                        int index = Integer.parseInt(irisFNo);
                        index = value < 0 ? --index : ++index;
                        if (index < 0) {
                            index = 0;
                        }
                        if (index > 17) {
                            index = 17;
                        }
                        this.getHttpHandler().readGetRequest("cgi-bin/system.cgi?msubmenu=camera&action=apply&iris=1&iris_manual=" + index);
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception while setting iris for " + this);
                        this.logger.error((Object)ex, (Throwable)ex);
                    }
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while requesting API version for " + this);
                this.logger.error((Object)ex, (Throwable)ex);
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        block11: {
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
            }
            try {
                if (this.samsungDevice.isSunApi_2()) {
                    try {
                        this.getHttpHandler().readGetRequest("/stw-cgi/image.cgi?msubmenu=camera&action=set&IrisMode=" + (active != false ? "Auto" : "Manual"));
                    }
                    catch (SeeTecException ex) {
                        this.logger.error("Exception while setting AUTO-Iris for " + this);
                        this.logger.error((Object)ex, (Throwable)ex);
                    }
                    break block11;
                }
                try {
                    int videoSourceNr = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                    if (videoSourceNr == 1) {
                        this.getHttpHandler().readGetRequest("/cgi-bin/system.cgi?msubmenu=camera&action=apply&iris=0");
                        break block11;
                    }
                    this.getHttpHandler().readGetRequest("/cgi-bin/system.cgi?msubmenu=camera&action=apply&video." + (videoSourceNr - 1) + ".iris=0");
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while setting AUTO-Iris for " + this);
                    this.logger.error((Object)ex, (Throwable)ex);
                }
                catch (ConfigurationException ex) {
                    this.logger.error("Exception while setting DayNight for " + this);
                    this.logger.error((Object)ex, (Throwable)ex);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while requesting API version for " + this);
                this.logger.error((Object)ex, (Throwable)ex);
            }
        }
        if (!active.booleanValue()) {
            this.isManualIrisSet = false;
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return 0;
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (value != null) {
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)this.videoSrv.getDevice();
            }
            if (!this.isManualFocusSet) {
                if (value == 0) {
                    return 0;
                }
                this.setAutoFocus(false);
                this.isManualFocusSet = true;
            }
            try {
                if (this.samsungDevice.isSunApi_2()) {
                    String focusRequest = this.createSunApi2FocusRequest(value);
                    this.sendCameraCommand(focusRequest, false);
                } else {
                    this.setAutoFocus(false);
                    String focusRequest = this.createDefaultFocusRequest(value);
                    this.sendCameraCommand(focusRequest);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while requesting API version for " + this);
            }
        }
        return 0;
    }

    private String createDefaultFocusRequest(Integer value) {
        String focusRequest = value != 0 ? (value > 0 ? "/cgi-bin/ptz.cgi?focus=near" : "/cgi-bin/ptz.cgi?focus=far") : "/cgi-bin/ptz.cgi?focus=stop";
        return focusRequest;
    }

    protected String createSunApi2FocusRequest(Integer value) {
        String focusRequest = value != null && value != 0 ? (value > 0 ? "/stw-cgi/ptzcontrol.cgi?msubmenu=continuous&action=control&Focus=Near" : "/stw-cgi/ptzcontrol.cgi?msubmenu=continuous&action=control&Focus=Far") : "/stw-cgi/ptzcontrol.cgi?msubmenu=continuous&action=control&Focus=Stop";
        return focusRequest;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        try {
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)this.videoSrv.getDevice();
            }
            StringBuilder sb = new StringBuilder();
            if (this.samsungDevice.isSunApi_2()) {
                sb.append("/stw-cgi/image.cgi?msubmenu=focus&action=set&Mode=");
                if (active.booleanValue()) {
                    sb.append("Auto");
                } else {
                    sb.append("Manual");
                }
            } else if (this.samsungDevice.isAutoFocus()) {
                sb.append("/cgi-bin/control.cgi?msubmenu=autofocus&action=");
                if (active.booleanValue()) {
                    sb.append("on");
                } else {
                    sb.append("off");
                }
            } else {
                return 0;
            }
            this.sendCameraCommand(sb.toString(), false);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting Autofocus for " + this + ": " + ex.getMessage(), (Throwable)ex);
        }
        if (active.booleanValue()) {
            this.isManualFocusSet = false;
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (this.samsungDevice == null) {
            this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
        }
        try {
            if (this.samsungDevice.isSunApi_2()) {
                int videoSourceNr = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                String url = "/stw-cgi/image.cgi?msubmenu=camera&action=set&Channel=" + (videoSourceNr - 1) + "&DayNightMode=" + (active != false ? "BW" : "Color");
                this.getHttpHandler().readGetRequest(url);
            } else {
                int videoSourceNr = this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                String url = videoSourceNr == 1 ? "/cgi-bin/system.cgi?msubmenu=camera&action=apply&daynight=" + (active != false ? 1 : 0) : "/cgi-bin/system.cgi?msubmenu=camera&action=apply&video." + (videoSourceNr - 1) + ".daynight=" + (active != false ? 1 : 0);
                this.getHttpHandler().readGetRequest(url);
            }
        }
        catch (ConfigurationException | SeeTecException ex) {
            this.logger.error("Exception while setting DayNight for " + this);
            this.logger.error((Object)ex, ex);
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        if (active.booleanValue()) {
            try {
                String url;
                if (this.samsungDevice.isSunApi_2()) {
                    int channel = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                    url = "/stw-cgi/image.cgi?msubmenu=camera&action=set&Channel=" + channel + "&DayNightMode=Auto";
                } else {
                    int channel = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                    url = channel == 0 ? "/cgi-bin/system.cgi?msubmenu=camera&action=apply&daynight=2" : "/cgi-bin/system.cgi?msubmenu=camera&action=apply&video." + channel + ".daynight=2";
                }
                this.getHttpHandler().readGetRequest(url);
            }
            catch (ConfigurationException | SeeTecException ex) {
                this.logger.error("Exception while setting Auto-DayNight for " + this);
                this.logger.error((Object)ex, ex);
            }
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        try {
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
            }
            if (this.samsungDevice.isSunApi_2()) {
                int channel = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                String url = "/stw-cgi/ptzcontrol.cgi?msubmenu=home&action=control&Channel=" + channel;
                this.errorCode = this.sendCameraCommand(url);
            }
        }
        catch (ConfigurationException | SeeTecException ex) {
            this.logger.error("Exception while setting Home position for " + this);
            this.logger.error((Object)ex, ex);
        }
        this.getAbsolutePosition(false);
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String preset) {
        int numberOfPresets = 8;
        String presetName = preset;
        try {
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
            }
            if (this.samsungDevice.isSunApi_2()) {
                numberOfPresets = this.samsungDevice.getNumberOfPresets();
            } else {
                String parameterString = this.getHttpHandler().readGetRequest("/cgi-bin/about.cgi?msubmenu=capability&action=view&use=1");
                if (parameterString != null) {
                    numberOfPresets = Integer.parseInt(this.samsungDevice.parseCameraData(parameterString, "Video.1.MaxPreset", ":", "\r\n"));
                }
            }
        }
        catch (Exception parameterString) {
            // empty catch block
        }
        try {
            this.logger.info("There are " + numberOfPresets + " presets available on " + this);
            byte[] vector = new byte[numberOfPresets + 1];
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                vector[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            int presetPosition = -1;
            for (int i = 1; i < vector.length; ++i) {
                if (vector[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this);
                return -21600;
            }
            if (this.samsungDevice.isSunApi_2()) {
                if ((presetName = presetName.replaceAll("[^A-Za-z0-9]", "")).length() > 12) {
                    presetName = presetName.substring(0, 12);
                }
                PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
                this.presetList.addElement(presetCnf);
                result.addElement(presetCnf.getPresetCnf());
                this.logger.info("Preset: " + presetName + " has position: " + presetPosition);
                this.sendCameraCommand("/stw-cgi/ptzconfig.cgi?msubmenu=preset&action=add&Preset=" + presetPosition + "&Name=" + presetName + "&Channel=" + (this.videoSourceNumber - 1));
            } else {
                presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
                PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
                this.presetList.addElement(presetCnf);
                result.addElement(presetCnf.getPresetCnf());
                this.logger.info("Preset: " + presetName + " has position: " + presetPosition);
                this.sendCameraCommand("/cgi-bin/ptz.cgi?savepresetno=" + presetPosition);
            }
            this.errorCode = 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed");
            this.errorCode = -21600;
        }
        return this.errorCode;
    }

    @Override
    public int setPresetPosition(String preset) {
        String presetName = preset;
        try {
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
            }
            if (this.samsungDevice.isSunApi_2()) {
                if ((presetName = presetName.replaceAll("[^A-Za-z0-9]", "")).length() > 12) {
                    presetName = presetName.substring(0, 12);
                }
            } else {
                presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            }
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                try {
                    if (this.samsungDevice.isSunApi_2()) {
                        this.sendCameraCommand("/stw-cgi/ptzcontrol.cgi?msubmenu=preset&action=control&Preset=" + presetCnf.getPresetPosition() + "&Channel=" + (this.videoSourceNumber - 1), false);
                    } else {
                        this.sendCameraCommand("/cgi-bin/ptz.cgi?movepresetno=" + presetCnf.getPresetPosition(), false);
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while requesting API version for " + this);
                    this.logger.error((Object)ex, (Throwable)ex);
                }
                this.getAbsolutePosition(false);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName;
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
            }
            if (this.samsungDevice.isSunApi_2()) {
                encodedPresetName = presetName.replaceAll("[^A-Za-z0-9]", "");
                if (encodedPresetName.length() > 12) {
                    encodedPresetName = encodedPresetName.substring(0, 12);
                }
            } else {
                encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            }
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                String presetNumber = presetCnf.getPresetPosition();
                this.presetList.removeElementAt(i);
                try {
                    if (this.samsungDevice.isSunApi_2()) {
                        int channel = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                        this.sendCameraCommand("/stw-cgi/ptzconfig.cgi?msubmenu=preset&action=remove&Channel=" + channel + "&Preset=" + presetCnf.getPresetPosition());
                    } else {
                        this.sendCameraCommand("/cgi-bin/ptz.cgi?deletepresetno=" + presetNumber);
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Exception while requesting API version for " + this);
                    this.logger.error((Object)ex, (Throwable)ex);
                }
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    private int sendCameraCommand(String url) {
        return this.sendCameraCommand(url, true);
    }

    private int sendCameraCommand(String url, boolean removeUnnecessaryCommands) {
        try {
            if (removeUnnecessaryCommands && url.equals(this.previousCommand)) {
                return 0;
            }
            if (removeUnnecessaryCommands && System.currentTimeMillis() - this.time < (long)this.minInterval && !url.toLowerCase().contains("stop")) {
                return 0;
            }
            this.time = System.currentTimeMillis();
            this.previousCommand = url;
            if (this.samsungDevice == null) {
                this.samsungDevice = (SamsungDevice)((SamsungCameraSrv)this.videoSrv).getDevice();
            }
            this.videoSrv.notifyForCameraControl();
            this.getHttpHandler().readGetRequest(url);
            return 0;
        }
        catch (SeeTecException ex) {
            if (ex.getErrorCode() == -20001) {
                return 0;
            }
            this.logger.error((Object)ex, (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        if (presets == null) {
            this.logger.warn("Received null camera presets object in addCameraPresets!");
            return -20002;
        }
        List<CameraPreset> cameraPresets = presets.getCameraPreset();
        for (CameraPreset cameraPreset : cameraPresets) {
            try {
                Element ptzPosition;
                byte[] cameraPresetPtzData = cameraPreset.getPtzData().getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(cameraPresetPtzData);
                Document ptzDocument = new SAXBuilder().build((InputStream)bais);
                String presetPosition = "1";
                Element root = ptzDocument.getRootElement();
                if (root != null && (ptzPosition = root.getChild("PresetPosition")) != null) {
                    presetPosition = ptzPosition.getText().trim();
                }
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, this.getEncodedPresetName(cameraPreset.getName()));
                this.presetList.addElement(presetCnf);
                this.logger.info("Adding preset configuration: " + presetCnf);
            }
            catch (UnsupportedEncodingException ex) {
                this.logger.error("Unsupported encoding used in the SamsungCameraControl.addCameraPresets()!", (Throwable)ex);
                return -20001;
            }
            catch (JDOMException ex) {
                this.logger.error("Exception while parsing XML data for " + this + " : " + ex.getMessage());
                return -20001;
            }
        }
        return 0;
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        try {
            String url = "/stw-cgi/ptzconfig.cgi?msubmenu=preset&action=view&Channel=" + (this.videoSourceNumber - 1);
            String result = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE), StandardCharsets.UTF_8);
            String[] results = result.split("[\\r\\n]+");
            ArrayOfCameraPreset cameraPresets = new ArrayOfCameraPreset();
            String presetPosition = "1";
            for (String row : results) {
                if (!row.contains("=") || !row.toLowerCase().contains("preset")) continue;
                String[] cameraPresetDef = row.split("=");
                String[] presetIDLine = cameraPresetDef[0].split("\\.");
                if (presetIDLine.length == 5) {
                    presetPosition = presetIDLine[3];
                }
                CameraPreset cameraPreset = new CameraPreset();
                cameraPreset.setName(cameraPresetDef[1]);
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, this.getEncodedPresetName(cameraPreset.getName()));
                try {
                    cameraPreset.setPtzData(new String(presetCnf.getPresetCnf(), "UTF-8"));
                    cameraPreset.setName(presetCnf.getPresetName());
                }
                catch (ConfigurationException ex) {
                    this.logger.error("Exception while adding preset position for " + this + " : " + ex.getMessage());
                }
                cameraPresets.getCameraPreset().add(cameraPreset);
            }
            return cameraPresets;
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)((Object)ex) + " for " + this, (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        return new ArrayOfCameraPreset();
    }
}

