/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.samsung;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SamsungAlarmServerPushHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.samsung.SamsungAlarmServerPushHandler";
    private static final byte[] BOUNDARY = "--SamsungTechwin".getBytes();
    private static final String CONTENT_TYPE = "Content-Type: text/plain";
    private static final String CONTENT_TYPE_MINOR = "Content-type: text/plain";
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Thread thread = null;
    private HttpServerPushListenerIntf listener = null;
    private NetworkParameter networkParameter = null;
    private Socket socket = null;
    private String url = null;
    private int startPos;
    private int endPos;
    private byte[] alarmDataHeader = null;
    private String contentHeader = null;
    private byte[] alarmDataBody = null;

    public int init(HttpServerPushListenerIntf listener, NetworkParameter networkParameter, String url) {
        this.listener = listener;
        if (this.listener == null) {
            return -20002;
        }
        this.networkParameter = networkParameter;
        if (this.networkParameter == null) {
            return -20002;
        }
        this.url = url;
        if (this.url == null) {
            return -20002;
        }
        return 0;
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.socket = null;
        }
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int startServerPush(boolean asynchronous) {
        if (this.listener == null) {
            return -20002;
        }
        if (this.networkParameter == null) {
            return -20002;
        }
        if (this.url == null) {
            return -20002;
        }
        this.logger.info("Starting HttpServerPush with following Parameter:");
        this.logger.info("   Listener        : " + this.listener);
        this.logger.info("   NetworkParameter: " + this.networkParameter);
        this.logger.info("   URL             : [" + this.url + "]");
        try {
            this.socket = NetworkHelper.establishServerPushStream((NetworkParameter)this.networkParameter, null, (String)this.url);
            this.socket.setSoTimeout(5000);
            this.logger.info("   Socket          : [" + this.socket + "]");
            this.logger.info("   SoTimeout       : [" + this.socket.getSoTimeout() + "]");
            this.listener.sendStatusService(0);
        }
        catch (Throwable ex) {
            int errorCode = -20100;
            this.logger.error((Object)ex, ex);
            this.listener.sendStatusService(errorCode);
            return errorCode;
        }
        if (asynchronous) {
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
            return 0;
        }
        return this.readHttpServerPush();
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            int errorCode = this.readHttpServerPush();
            if (errorCode != 0) {
                this.listener.sendStatusService(errorCode);
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Listener=" + this.listener + ", " + this.networkParameter + ", " + this.socket + ", URL=[" + this.url + "]]";
    }

    protected int readHttpServerPush() {
        int errorCode = 0;
        int len = -1;
        byte[] inBuffer = new byte[512];
        byte[] array = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32768);
        try {
            InputStream is = this.socket.getInputStream();
            this.logger.info(this + " uses [" + this.url + "] to " + this.socket);
            baos.reset();
            while (!this.isShutdown()) {
                block11: {
                    try {
                        len = is.read(inBuffer);
                        if (len >= 0) break block11;
                        if (array == null) {
                            errorCode = -20102;
                        } else {
                            String msg = new String(array);
                            this.logger.error("Invalid server push for " + this + ":\n\r" + msg);
                            errorCode = !msg.toLowerCase().contains("unauthorized") ? -20102 : -21657;
                        }
                        break;
                    }
                    catch (InterruptedIOException soTimeoutException) {
                        if (this.networkParameter.getIgnoreSoTimeout()) continue;
                        this.logger.error("Timeout reading Alarm data. This can be caused by some Antivirus programms.");
                        this.listener.notifyForNetworkProblems();
                        this.shutdown();
                    }
                    catch (NullPointerException npe) {
                        break;
                    }
                }
                baos.write(inBuffer, 0, len);
                array = baos.toByteArray();
                this.startPos = 0;
                this.endPos = 0;
                while (this.startPos < array.length && this.endPos < array.length && this.startPos != -1 && this.endPos != -1) {
                    this.startPos = SamsungAlarmServerPushHandler.indexOfByteArray((byte[])array, (byte[])BOUNDARY, (int)this.endPos);
                    if (this.startPos == -1) continue;
                    this.endPos = SamsungAlarmServerPushHandler.indexOfByteArray((byte[])array, (byte[])CONTENT_TYPE.getBytes(), (int)this.startPos);
                    if (this.endPos == -1) {
                        this.endPos = SamsungAlarmServerPushHandler.indexOfByteArray((byte[])array, (byte[])CONTENT_TYPE_MINOR.getBytes(), (int)this.startPos);
                    }
                    if (this.endPos == -1) continue;
                    this.alarmDataHeader = new byte[this.endPos - this.startPos];
                    System.arraycopy(array, this.startPos, this.alarmDataHeader, 0, this.endPos - this.startPos);
                    this.contentHeader = new String(this.alarmDataHeader);
                    this.startPos = this.endPos;
                    this.endPos = SamsungAlarmServerPushHandler.indexOfByteArray((byte[])array, (byte[])this.networkParameter.getHttpDoubleLineDelimitter(), (int)(this.startPos + 4));
                    if (this.endPos == -1) continue;
                    this.alarmDataBody = new byte[this.endPos - this.startPos];
                    System.arraycopy(array, this.startPos, this.alarmDataBody, 0, this.endPos - this.startPos);
                    this.listener.deliverContent(new HttpServerPushContent(this.contentHeader, this.alarmDataBody));
                    baos.reset();
                }
            }
        }
        catch (IOException ex) {
            this.logger.warn("IOException occured for " + this + ex.getMessage());
            this.listener.notifyForNetworkProblems();
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            this.logger.warn("Unexpected exception occured for " + this);
            this.listener.notifyForNetworkProblems();
        }
        return errorCode;
    }
}

