/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.qognify;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.shared.util.SeeTecException;

public final class QognifyVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.qognify.QognifyVideoSourceClient";
    private int rtspPort = Integer.MIN_VALUE;

    @Override
    public int init() {
        this.sendStatusService(-21600);
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
        } else {
            this.rtspUrl = "rtsp://" + this.networkParameter.getHost() + "/video" + this.videoSourceNr;
            this.rtspUrl = this.rtspUrl + "0" + (this.listener.getVideoProfileHandler().getDynamicVideoProfileID() + 1);
            this.logger.info(this.rtspUrl);
            try {
                this.networkParameter.setSoTimeout(5000);
                this.rtspSettings = new RTSPStreamSettings();
                this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 3, this.rtspUrl);
                if (this.errorCode != 0) {
                    this.logger.error("Error while setting RTSP parameters for " + this.getVideoSrv());
                }
                if (this.rtspPort != Integer.MIN_VALUE) {
                    this.rtspSettings.setRTSPPort(this.rtspPort);
                }
                this.rtspSettings.setUdpBuffer(65535);
                this.rtspSettings.setUserAgent("Java / Qognify");
                this.rtspHandler = this.rtspSettings.getRTSPHandler();
                this.errorCode = this.rtspHandler.start();
                if (this.errorCode != 0) {
                    this.logger.error("Error while starting RTSP stream for " + this.getVideoSrv());
                }
            }
            catch (SeeTecException ex) {
                this.logger.info((Object)ex);
                this.logger.error("Error while first RTSP request. errorCode: " + ex.getErrorCode() + " for " + this.getVideoSrv());
                this.errorCode = ex.getErrorCode();
            }
            catch (Exception ex) {
                this.logger.info((Object)ex);
                this.logger.error("Error while first RTSP request. errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            }
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return this.errorCode;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

