/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco.webservice;

import com.pelco.schemas.service.streamdiscovery._1.ConnectionList;
import com.pelco.schemas.service.streamdiscovery._1.ConnectionURL;
import com.pelco.schemas.service.streamdiscovery._1.StreamDiscoveryPortType;
import com.pelco.schemas.service.streamdiscovery._1.StreamID;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceDevice;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PelcoWebServiceStreamDiscovery {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final StreamDiscoveryPortType streamDiscoveryPortType;

    public PelcoWebServiceStreamDiscovery(PelcoWebServiceDevice pelcoDevice) {
        this.streamDiscoveryPortType = pelcoDevice.getStreamDiscoveryService();
    }

    public final ConnectionList streamQuery() {
        this.logger.info("Discover streams");
        ConnectionList connectionList = this.streamDiscoveryPortType.streamQuery();
        return connectionList;
    }

    public final boolean isStreamAvailable(int streamId) {
        ConnectionList connectionList = this.streamQuery();
        for (ConnectionURL connectionURL : connectionList.getConnectionURL()) {
            for (StreamID streamID : connectionURL.getStream()) {
                if (!connectionURL.getMimeType().equals("image/jpeg") && !connectionURL.getTransmission().equals("unicast") || !streamID.getType().equals("video") || streamID.getId() != streamId) continue;
                this.logger.info("Stream " + (streamId + 1) + " available: " + connectionURL.getAddress());
                return true;
            }
        }
        this.logger.info("Stream " + (streamId + 1) + " not available");
        return false;
    }

    public final boolean isStreamJPEG(int streamId) {
        ConnectionList connectionList = this.streamDiscoveryPortType.streamQuery();
        for (ConnectionURL connectionURL : connectionList.getConnectionURL()) {
            for (StreamID streamID : connectionURL.getStream()) {
                if (connectionURL.getMimeType() == null || !connectionURL.getMimeType().equals("image/jpeg") || !streamID.getType().equals("video") || streamID.getId() != streamId) continue;
                this.logger.info("Stream " + (streamId + 1) + " is JPEG");
                return true;
            }
        }
        this.logger.info("Stream " + (streamId + 1) + " is not JPEG");
        return false;
    }

    public final boolean isStreamH264(int streamId) {
        ConnectionList connectionList = this.streamDiscoveryPortType.streamQuery();
        for (ConnectionURL connectionURL : connectionList.getConnectionURL()) {
            for (StreamID streamID : connectionURL.getStream()) {
                if (connectionURL.getTransmission() == null || !connectionURL.getTransmission().equals("unicast") || !streamID.getType().equals("video") || streamID.getId() != streamId) continue;
                this.logger.info("Stream " + (streamId + 1) + " is H264");
                return true;
            }
        }
        this.logger.info("Stream " + (streamId + 1) + " is not H264");
        return false;
    }
}

