/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco.webservice;

import com.pelco.schemas.service.streamconfiguration._1.ConfigurationInfo;
import com.pelco.schemas.service.streamconfiguration._1.IntRange;
import com.pelco.schemas.service.streamconfiguration._1.QueryResult;
import com.pelco.schemas.service.streamconfiguration._1.Setting;
import com.pelco.schemas.service.streamconfiguration._1.SettingOptions;
import com.pelco.schemas.service.streamconfiguration._1.StreamConfigurationInfo;
import com.pelco.schemas.service.streamconfiguration._1.StreamConfigurationPortType;
import com.pelco.schemas.service.streamconfiguration._1.StreamID;
import com.pelco.schemas.service.streamconfiguration._1.StreamIDSettings;
import com.pelco.schemas.service.streamconfiguration._1.StreamIDSettingsList;
import com.pelco.schemas.service.streamconfiguration._1.StreamSettings;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceDevice;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PelcoWebServiceStreamConfiguration {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final StreamConfigurationPortType streamConfigurationService;

    public PelcoWebServiceStreamConfiguration(PelcoWebServiceDevice pelcoDevice) {
        this.streamConfigurationService = pelcoDevice.getStreamConfigurationService();
    }

    public final List<SettingOptions> queryAllOptions(int streamId, String streamType, List<Setting> settings) {
        StreamID streamInformation = new StreamID();
        streamInformation.setId(streamId);
        streamInformation.setType(streamType);
        StreamSettings streamSettings = new StreamSettings();
        for (Setting setting : settings) {
            streamSettings.getSetting().add(setting);
        }
        StreamIDSettings streamIDSettings = new StreamIDSettings();
        streamIDSettings.setStream(streamInformation);
        streamIDSettings.setSettings(streamSettings);
        StreamIDSettingsList streamSettingsList = new StreamIDSettingsList();
        streamSettingsList.getStreamIDSettings().add(streamIDSettings);
        ConfigurationInfo configurationInfo = this.streamConfigurationService.queryAllOptions(streamType, streamSettingsList);
        List streamConfigurationInfoList = configurationInfo.getStreamInfo();
        for (StreamConfigurationInfo streamConfigurationInfo : streamConfigurationInfoList) {
            StreamID requestedStreamInformation = streamConfigurationInfo.getStream();
            if (requestedStreamInformation.getId() != streamId) continue;
            QueryResult queryResult = streamConfigurationInfo.getResult();
            List settingOptionsList = queryResult.getSettingOptions();
            return settingOptionsList;
        }
        return null;
    }

    public final float[] getPossibleDecimalValues(String valueName, List<SettingOptions> settingOptionsList) {
        ArrayList<Float> list = new ArrayList<Float>();
        for (SettingOptions settingOptions : settingOptionsList) {
            if (!settingOptions.getName().equals(valueName)) continue;
            for (BigDecimal value : settingOptions.getDecimalEnumeration().getValue()) {
                list.add(Float.valueOf(value.floatValue()));
            }
        }
        float[] floatArray = new float[list.size()];
        for (int i = 0; i < floatArray.length; ++i) {
            floatArray[i] = ((Float)list.get(list.size() - 1 - i)).floatValue();
        }
        return floatArray;
    }

    public final IntRange getPossibleIntRangeValues(String valueName, List<SettingOptions> settingOptionsList) {
        IntRange intRange = new IntRange();
        for (SettingOptions settingOptions : settingOptionsList) {
            if (!settingOptions.getName().equals(valueName)) continue;
            intRange.setMinValue(settingOptions.getIntRange().getMinValue());
            intRange.setDefault(settingOptions.getIntRange().getDefault());
            intRange.setMaxValue(settingOptions.getIntRange().getMaxValue());
        }
        return intRange;
    }

    public final void changeSettings(int streamId, String streamType, List<Setting> changedSettings, boolean multistreamingActivated) {
        StreamID streamInformation = new StreamID();
        streamInformation.setId(streamId);
        streamInformation.setType(streamType);
        ConfigurationInfo configurationInfo = this.streamConfigurationService.getAllCurrentConfiguration(streamType);
        List streamConfigurationInfoList = configurationInfo.getStreamInfo();
        List settings = null;
        for (Object streamConfigurationInfo : streamConfigurationInfoList) {
            if (streamConfigurationInfo.getStream().getId() != 0 || !streamConfigurationInfo.getStream().getType().equals(streamType)) continue;
            QueryResult queryResult = streamConfigurationInfo.getResult();
            settings = queryResult.getSetting();
        }
        if (settings != null) {
            ArrayList<Setting> newSettings = new ArrayList<Setting>();
            for (Setting setting : settings) {
                boolean changed = false;
                for (Setting setting2 : changedSettings) {
                    if (!setting.getName().equals(setting2.getName())) continue;
                    newSettings.add(setting2);
                    changed = true;
                }
                if (changed) continue;
                newSettings.add(setting);
            }
            StreamIDSettings streamIdSettings = new StreamIDSettings();
            StreamSettings streamSettings = new StreamSettings();
            streamSettings.getSetting().addAll(newSettings);
            streamIdSettings.setSettings(streamSettings);
            streamIdSettings.setStream(streamInformation);
            StreamIDSettingsList streamIdSettingsList = new StreamIDSettingsList();
            streamIdSettingsList.getStreamIDSettings().add(streamIdSettings);
            List settings2 = null;
            for (StreamConfigurationInfo streamConfigurationInfo : streamConfigurationInfoList) {
                if (streamConfigurationInfo.getStream().getId() != 1 || !streamConfigurationInfo.getStream().getType().equals(streamType)) continue;
                QueryResult queryResult = streamConfigurationInfo.getResult();
                settings2 = queryResult.getSetting();
            }
            if (multistreamingActivated && settings2 != null) {
                StreamID streamID = new StreamID();
                streamID.setId(1);
                streamID.setType("video");
                StreamSettings streamSettings2 = new StreamSettings();
                StreamIDSettings streamIdSettings2 = new StreamIDSettings();
                streamSettings2.getSetting().addAll(settings2);
                streamIdSettings2.setSettings(streamSettings2);
                streamIdSettings2.setStream(streamID);
                streamIdSettingsList.getStreamIDSettings().add(streamIdSettings2);
            }
            this.streamConfigurationService.saveAllSettings(streamType, streamIdSettingsList);
            this.logger.info("StreamSettings changed!");
        }
    }
}

