/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco.webservice;

import com.pelco.schemas.service.cameraconfiguration._1.CameraConfig;
import com.pelco.schemas.service.cameraconfiguration._1.CameraConfigurationPortType;
import com.pelco.schemas.service.cameraconfiguration._1.ConfigurableInt;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceDevice;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class PelcoWebServiceCameraConfiguration {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final CameraConfigurationPortType cameraConfigurationService;

    public PelcoWebServiceCameraConfiguration(PelcoWebServiceDevice pelcoDevice) {
        this.cameraConfigurationService = pelcoDevice.getCameraConfigurationService();
    }

    public final boolean isAudioEnabled() {
        CameraConfig cameraConfig = this.cameraConfigurationService.getConfiguration();
        if (cameraConfig.getAudioEnable() == 0) {
            return false;
        }
        return cameraConfig.getAudioEnable() == 1;
    }

    public final void setAudioEnabled(boolean state) {
        CameraConfig cameraConfig = this.cameraConfigurationService.getConfiguration();
        if (state && cameraConfig.getAudioEnable() == 0) {
            cameraConfig.setAudioEnable(1);
            this.cameraConfigurationService.setConfiguration(cameraConfig);
            this.logger.info("Audio enabled");
        } else if (!state && cameraConfig.getAudioEnable() == 1) {
            cameraConfig.setAudioEnable(0);
            this.cameraConfigurationService.setConfiguration(cameraConfig);
            this.logger.info("Audio disabled");
        }
    }

    public final int getControlMode() {
        CameraConfig cameraConfig = this.cameraConfigurationService.getConfiguration();
        ConfigurableInt controlMode = cameraConfig.getControlMode();
        return controlMode.getValue();
    }

    public final void setControlMode(int controlModeValue) {
        CameraConfig cameraConfig = this.cameraConfigurationService.getConfiguration();
        ConfigurableInt controlMode = cameraConfig.getControlMode();
        controlMode.setValue(controlModeValue);
        cameraConfig.setControlMode(controlMode);
        this.cameraConfigurationService.setConfiguration(cameraConfig);
    }

    public final int getCameraType() {
        CameraConfig cameraConfig = this.cameraConfigurationService.getConfiguration();
        ConfigurableInt cameraType = cameraConfig.getCameraType();
        return cameraType.getValue();
    }

    public final void setCameraType(int cameraTypeValue) {
        CameraConfig cameraConfig = this.cameraConfigurationService.getConfiguration();
        ConfigurableInt cameraType = cameraConfig.getCameraType();
        cameraType.setValue(cameraTypeValue);
        cameraConfig.setCameraType(cameraType);
        this.cameraConfigurationService.setConfiguration(cameraConfig);
    }
}

