/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.pelco;

import com.pelco.schemas.service.positioningcontrol._1.VelocityLimits;
import com.pelco.schemas.service.positioningcontrol._1.Xyzlimits;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceDevice;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceLensControl;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServicePositioningControl;
import de.seetec.v5.re.cm.device.video.pelco.webservice.PelcoWebServiceScriptControl;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URLEncoder;
import java.util.Vector;

public class PelcoCameraControl
extends CameraControl {
    private PelcoWebServiceDevice pelcoWebServiceDevice = null;
    private PelcoWebServiceLensControl pelcoWebServiceLensControl = null;
    private PelcoWebServicePositioningControl pelcoWebServicePositioningControl = null;
    private PelcoWebServiceScriptControl pelcoWebServiceScriptControl = null;
    private VelocityLimits velocityLimits = null;
    private boolean panTiltCommandSend = false;
    private boolean zoomCommandSend = false;

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public final int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        this.initPelcoWebServices();
        try {
            double panValue = panSpeed != null ? this.useLogarithmFunction(panSpeed, ((Xyzlimits)this.velocityLimits.getRotation().getValue()).getXMax().intValue()) : (double)this.previousPanSpeed;
            double tiltValue = tiltSpeed != null ? this.useLogarithmFunction(tiltSpeed, ((Xyzlimits)this.velocityLimits.getRotation().getValue()).getYMax().intValue()) : (double)this.previousTiltSpeed;
            int pelcoZoomValue = zoomSpeed != null ? (zoomSpeed > 0 ? 2 : (zoomSpeed < 0 ? 1 : 0)) : this.previousZoomSpeed;
            if (panValue > 0.0 && panValue > (double)((Xyzlimits)this.velocityLimits.getRotation().getValue()).getXMax().intValue()) {
                panValue = ((Xyzlimits)this.velocityLimits.getRotation().getValue()).getXMax().intValue();
            } else if (panValue < 0.0 && panValue < (double)(-((Xyzlimits)this.velocityLimits.getRotation().getValue()).getXMax().intValue())) {
                panValue = -((Xyzlimits)this.velocityLimits.getRotation().getValue()).getXMax().intValue();
            }
            if (tiltValue > 0.0 && tiltValue > (double)((Xyzlimits)this.velocityLimits.getRotation().getValue()).getYMax().intValue()) {
                tiltValue = ((Xyzlimits)this.velocityLimits.getRotation().getValue()).getYMax().intValue();
            } else if (tiltValue < 0.0 && tiltValue < (double)(-((Xyzlimits)this.velocityLimits.getRotation().getValue()).getYMax().intValue())) {
                tiltValue = -((Xyzlimits)this.velocityLimits.getRotation().getValue()).getYMax().intValue();
            }
            if (this.isInverted((int)panValue, this.previousPanSpeed) || this.isInverted((int)tiltValue, this.previousTiltSpeed) || this.isInverted(pelcoZoomValue, this.previousZoomSpeed)) {
                this.panTiltCommandSend = false;
            }
            if (panSpeed != null) {
                this.previousPanSpeed = (int)panValue;
            }
            if (tiltSpeed != null) {
                this.previousTiltSpeed = (int)tiltValue;
            }
            boolean ptStopCommand = false;
            if (panValue == 0.0 || tiltValue == 0.0) {
                ptStopCommand = true;
            }
            if (!this.panTiltCommandSend || ptStopCommand) {
                this.pelcoWebServicePositioningControl.move((int)panValue, (int)tiltValue);
                this.panTiltCommandSend = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                            PelcoCameraControl.this.panTiltCommandSend = false;
                        }
                        catch (Exception exception) {
                            PelcoCameraControl.this.logger.debug("Error while sleeping.");
                        }
                    }
                }, "Pelco PT Waiting thread for " + this.videoSrv).start();
            }
            boolean zStopCommand = false;
            if (pelcoZoomValue == 0) {
                zStopCommand = true;
            }
            if ((!this.zoomCommandSend || zStopCommand) && pelcoZoomValue != this.previousZoomSpeed) {
                this.pelcoWebServiceLensControl.zoom(pelcoZoomValue);
                this.zoomCommandSend = true;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                            PelcoCameraControl.this.zoomCommandSend = false;
                        }
                        catch (Exception exception) {
                            PelcoCameraControl.this.logger.debug("Error while sleeping.");
                        }
                    }
                }, "Pelco Zoom Waiting thread for " + this.videoSrv).start();
            }
            if (zoomSpeed != null) {
                this.previousZoomSpeed = pelcoZoomValue;
            }
            this.videoSrv.notifyForCameraControl();
            return 0;
        }
        catch (Throwable throwable) {
            this.videoSrv.sendStatusService(-21656);
            this.logger.error((Object)throwable, throwable);
            return -21600;
        }
    }

    private boolean isInverted(float x, float y) {
        return x * y < 0.0f;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            this.initPelcoWebServices();
            int[] pos = this.calcCenterPT(xPosition, yPosition);
            this.pelcoWebServicePositioningControl.setViewObject(pos[0], pos[1]);
            this.videoSrv.notifyForCameraControl();
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
        }
        return 0;
    }

    protected final int[] calcCenterPT(Integer x, Integer y) throws SeeTecException {
        if (x == null || x < 0 || x > 100 || y == null || y < 0 || y > 100) {
            throw new SeeTecException(-21653, "Invalid CenterPT parameters for " + this.videoSrv + ": x=" + x + ",y=" + y);
        }
        return new int[]{(x - 50) * 2, (y - 50) * 2 * -1};
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setContinuousIris(Integer value) {
        this.initPelcoWebServices();
        int irisValue = value > 0 ? 2 : (value < 0 ? 1 : 0);
        this.pelcoWebServiceLensControl.iris(irisValue);
        this.videoSrv.notifyForCameraControl();
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        this.initPelcoWebServices();
        this.pelcoWebServiceLensControl.autoIris(active);
        this.videoSrv.notifyForCameraControl();
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-( ");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        this.initPelcoWebServices();
        int focusValue = value > 0 ? 2 : (value < 0 ? 1 : 0);
        this.pelcoWebServiceLensControl.focus(focusValue);
        this.videoSrv.notifyForCameraControl();
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        this.initPelcoWebServices();
        this.pelcoWebServiceLensControl.autoFocus(active);
        this.videoSrv.notifyForCameraControl();
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        try {
            this.initPelcoWebServices();
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 1; i <= 256; ++i) {
                String devicePresetName = "PRESET" + i;
                if (this.pelcoWebServiceScriptControl.queryScripts().contains(devicePresetName)) continue;
                this.pelcoWebServiceScriptControl.definePreset(i);
                PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, devicePresetName, encodedPresetName);
                this.presetList.addElement(presetCnf);
                vResult.addElement(presetCnf.getPresetCnf());
                break;
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetName + "] failed :-(", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetPositionName) {
        try {
            this.initPelcoWebServices();
            String encodedPresetName = URLEncoder.encode(presetPositionName.trim(), "UTF-8");
            for (Object object : this.presetList) {
                PresetCnf presetCnf = (PresetCnf)object;
                if (!presetCnf.getPresetName().equals(encodedPresetName)) continue;
                String presetName = presetCnf.getPresetPosition();
                if (!this.pelcoWebServiceScriptControl.queryScripts().contains(presetName)) continue;
                this.pelcoWebServiceScriptControl.selectPreset(presetName);
                return 0;
            }
            this.videoSrv.notifyForCameraControl();
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetPositionName + "] failed :-(", (Throwable)exception);
            return -21600;
        }
        return 0;
    }

    @Override
    public int removePresetPosition(String presetPositionName) {
        try {
            this.initPelcoWebServices();
            String encodedPresetName = URLEncoder.encode(presetPositionName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetCnf.getPresetName().equals(encodedPresetName)) continue;
                String presetName = presetCnf.getPresetPosition();
                if (!this.pelcoWebServiceScriptControl.queryScripts().contains(presetName)) continue;
                this.pelcoWebServiceScriptControl.deletePreset(presetName);
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetPositionName + "] failed :-(");
            return -21600;
        }
        return 0;
    }

    private void initPelcoWebServices() {
        if (this.pelcoWebServiceDevice == null) {
            this.pelcoWebServiceDevice = new PelcoWebServiceDevice();
            this.pelcoWebServiceDevice.init(this.networkParameter.getHost(), this.networkParameter.getHTTPport(), "1", false);
        }
        if (this.pelcoWebServiceLensControl == null) {
            this.pelcoWebServiceLensControl = new PelcoWebServiceLensControl(this.pelcoWebServiceDevice);
        }
        if (this.pelcoWebServicePositioningControl == null) {
            this.pelcoWebServicePositioningControl = new PelcoWebServicePositioningControl(this.pelcoWebServiceDevice);
        }
        if (this.pelcoWebServiceScriptControl == null) {
            this.pelcoWebServiceScriptControl = new PelcoWebServiceScriptControl(this.pelcoWebServiceDevice);
        }
        if (this.velocityLimits == null) {
            this.velocityLimits = this.pelcoWebServicePositioningControl.getLimits();
        }
    }

    private double useLogarithmFunction(int givepanTiltValue, double maxValue) {
        if (givepanTiltValue != 0) {
            double newPanTiltValue = 0.0;
            newPanTiltValue = (double)givepanTiltValue / 20000.0;
            boolean isNegative = false;
            if (newPanTiltValue < 0.0) {
                isNegative = true;
                newPanTiltValue *= -1.0;
            }
            newPanTiltValue = Math.log(newPanTiltValue + 1.0) + 2.0;
            if (isNegative) {
                newPanTiltValue *= -1.0;
            }
            newPanTiltValue = newPanTiltValue * maxValue / (Math.log(6.0) + 2.0);
            return newPanTiltValue;
        }
        return 0.0;
    }
}

