/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.HttpHandlerIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import org.apache.logging.log4j.LogManager;

public class Panasonic2MotionDetectionHandler
extends MotionDetectionHandler
implements HttpHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2MotionDetectionHandler";
    private HttpHandlerImpl httpHandler = null;
    private NetworkParameter networkParameter = null;

    public Panasonic2MotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode = 0;
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        String url = "/cgi-bin/get_io?mode=monitor";
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.networkParameter.setSoTimeout(20000);
            this.httpHandler = new HttpHandlerImpl(this.networkParameter);
            this.httpHandler.readServerPushRequest(url, (HttpHandlerIntf)this);
        }
        catch (Exception e) {
            this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed", (Throwable)e);
            errorCode = -21601;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
            this.httpHandler = null;
        }
        super.shutdown();
        return 0;
    }

    public void sendStatusService(int statusCode) {
        if (!this.isShutdown(CLASS_NAME) && statusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    public void deliverContent(byte[] content) {
        if (content != null) {
            String[] windows;
            for (String window : windows = new String(content).split("\r\n")) {
                if (!window.toLowerCase().contains("motiondetect true") || this.listener == null) continue;
                this.listener.evaluateWindow(0);
            }
        }
    }
}

