/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2;

import java.util.ArrayList;
import java.util.List;

public class Panasonic2Helper {
    public static String getFirstValueAsString(String file, String key) {
        String[] result = Panasonic2Helper.getValuesAsString(file, key);
        if (result.length == 0) {
            return "";
        }
        return result[0];
    }

    public static int getFirstValueAsInt(String file, String key) throws Exception {
        return Integer.parseInt(Panasonic2Helper.getFirstValueAsString(file, key));
    }

    public static double getFirstValueAsDouble(String file, String key) throws Exception {
        return Double.parseDouble(Panasonic2Helper.getFirstValueAsString(file, key));
    }

    public static int[] getValuesAsInt(String file, String key) throws Exception {
        String[] linesFromDevice = Panasonic2Helper.getValuesAsString(file, key);
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (String lineFromDevice : linesFromDevice) {
            try {
                resultList.add(Integer.parseInt(lineFromDevice));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int[] result = new int[resultList.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Integer)resultList.get(i);
        }
        return result;
    }

    public static double[] getValuesAsDouble(String file, String key) throws Exception {
        String[] linesFromDevice = Panasonic2Helper.getValuesAsString(file, key);
        double[] result = new double[linesFromDevice.length];
        for (int i = 0; i < linesFromDevice.length; ++i) {
            result[i] = Double.parseDouble(linesFromDevice[i]);
        }
        return result;
    }

    public static String[] getValuesAsString(String file, String key) {
        if (file != null && !file.isEmpty() && key != null && !key.isEmpty()) {
            String[] linesFromDevice;
            for (String line : linesFromDevice = file.split("\r\n")) {
                String[] lineParts = line.split("=");
                if (lineParts.length != 2 || !lineParts[0].equalsIgnoreCase(key)) continue;
                String[] values = lineParts[1].split(",");
                for (int j = 0; j < values.length; ++j) {
                    values[j] = values[j].replace("\r", "").replace("\n", "").trim();
                }
                return values;
            }
        }
        return new String[0];
    }

    protected static String readConfiguredValue(String setup, String parameter) {
        if (setup != null && !setup.isEmpty() && parameter != null && !parameter.isEmpty()) {
            String[] setupLines;
            for (String setupLine : setupLines = setup.split("\r\n")) {
                String[] setupLineParts = (setupLine = setupLine.replace("\"", "")).split(",");
                if (setupLineParts.length != 2 || !setupLineParts[0].equalsIgnoreCase(parameter)) continue;
                return setupLineParts[1].trim();
            }
        }
        return "";
    }

    public static Integer getNearestValue(List<Integer> bitrateValues, int bandwidth) {
        Integer result = 0;
        int difference = Integer.MAX_VALUE;
        for (int i = 0; i < bitrateValues.size(); ++i) {
            int bitrate = bitrateValues.get(i);
            if (Math.abs(bitrate - bandwidth) >= difference) continue;
            result = bitrate;
            difference = Math.abs(bitrate - bandwidth);
        }
        return result;
    }

    public static int getNumberOfVideoSourcesFromDevice(String capabilities) {
        if (capabilities == null || capabilities.isEmpty() || !capabilities.toLowerCase().contains("video_server.image.sensor.number")) {
            return 1;
        }
        try {
            return Panasonic2Helper.getFirstValueAsInt(capabilities, "video_server.image.sensor.number");
        }
        catch (Exception ex) {
            return 1;
        }
    }

    protected static boolean isAiVmdSupported(String deviceInfo) {
        if (deviceInfo != null && !deviceInfo.isEmpty()) {
            int i;
            for (i = 1; i <= 3; ++i) {
                if (!Panasonic2Helper.getFirstValueAsString(deviceInfo, "EXTAPP" + i).equalsIgnoreCase("ai-vmd")) continue;
                return true;
            }
            for (i = 1; i <= 4; ++i) {
                if (!Panasonic2Helper.getFirstValueAsString(deviceInfo, "MSC_EXTAPP" + i).toLowerCase().startsWith("ai-vmd")) continue;
                return true;
            }
        }
        return false;
    }
}

