/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedBitratesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.panasonic2.AnalyticsMode;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2ControlQuery;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Helper;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2IOHandler;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Query;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2TriggerReader;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class Panasonic2Device
extends VideoServer {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Device";
    private static final int STREAM_NOT_SET = 0;
    private static final int STREAM_1_2_SET = 3;
    private int streamSet = 0;
    private final Map<Integer, Integer> h264Streams = new HashMap<Integer, Integer>();
    private HttpHandlerImpl httpHandler;
    private final Object SEMAPHORE = new Object();
    private NetworkParameter networkParameter;
    private String currentName;
    private boolean genericEventsSupported;

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public int initializeDevice(long srvType) {
        int errorCode = super.initializeDevice(srvType);
        try {
            if (this.getLogger().isDebugEnabled()) {
                SupportedGenericEventsType genericEvents = this.getDeviceDefinitionFromConfiguration().getSupportedGenericEvents();
                List<GenericEventDefinitionType> eventList = genericEvents.getGenericEventDefinition();
                this.getLogger().debug("Generic Events available for " + this + ":");
                for (GenericEventDefinitionType g : eventList) {
                    this.getLogger().debug("Type: " + g.getEventType() + " Source: " + g.getSourceNumber());
                }
            }
            this.networkParameter = this.getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.getLogger().error("Exception reading network parameters for " + this + ": " + ex.getMessage());
        }
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpHandlerImpl getHttpHandler() {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            if (this.httpHandler == null) {
                try {
                    this.networkParameter = this.getDeviceCnf().getNetworkParameter();
                    this.httpHandler = new HttpHandlerImpl(this.networkParameter);
                }
                catch (ConfigurationException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                    return null;
                }
            }
            return this.httpHandler;
        }
    }

    public static String getCurrentCaptureMode(String capabilities, String currentCaptureModeResolution, String currentCaptureModeAspectRatio, String currentCaptureModeMaxFPS) {
        if (capabilities == null || capabilities.isEmpty() || currentCaptureModeResolution == null || currentCaptureModeAspectRatio == null || currentCaptureModeMaxFPS == null) {
            return "";
        }
        String[] availableCaptureModes = Panasonic2Helper.getValuesAsString(capabilities, "video_server.image.mode");
        String currentCaptureModeResolutionWithoutFramerate = currentCaptureModeResolution = currentCaptureModeResolution.replace(".", "_");
        if (currentCaptureModeResolutionWithoutFramerate.contains("m_")) {
            currentCaptureModeResolutionWithoutFramerate = currentCaptureModeResolution.substring(0, currentCaptureModeResolution.indexOf("m_") + 1);
        }
        ArrayList<String> searchPatterns = new ArrayList<String>();
        searchPatterns.add(currentCaptureModeResolution + "_r" + currentCaptureModeAspectRatio + "_" + currentCaptureModeMaxFPS + "fps");
        searchPatterns.add(currentCaptureModeResolution + "_r" + currentCaptureModeAspectRatio);
        searchPatterns.add(currentCaptureModeResolutionWithoutFramerate + "_r" + currentCaptureModeAspectRatio + "_" + currentCaptureModeMaxFPS + "fps");
        searchPatterns.add(currentCaptureModeResolutionWithoutFramerate + "_r" + currentCaptureModeAspectRatio + "_" + currentCaptureModeMaxFPS + "fps");
        searchPatterns.add(currentCaptureModeResolutionWithoutFramerate + "_r" + currentCaptureModeAspectRatio + "_" + currentCaptureModeMaxFPS + "_5fps");
        searchPatterns.add(currentCaptureModeResolution + "_" + currentCaptureModeMaxFPS + "_5fps");
        searchPatterns.add(currentCaptureModeResolution + "_" + currentCaptureModeMaxFPS + "fps");
        searchPatterns.add(currentCaptureModeResolution);
        for (String searchPattern : searchPatterns) {
            for (String availableCaptureMode : availableCaptureModes) {
                if (!availableCaptureMode.equals(searchPattern)) continue;
                return availableCaptureMode;
            }
        }
        return "";
    }

    public static int getSupportedBitrates(String capabilities, String parameter) throws Exception {
        int[] bitrates;
        SupportedBitratesType supportedBitratesType = new SupportedBitratesType();
        for (int bitrate : bitrates = Panasonic2Helper.getValuesAsInt(capabilities, parameter)) {
            supportedBitratesType.getInt().add(bitrate * 1024);
        }
        return supportedBitratesType.getInt().get(supportedBitratesType.getInt().size() - 1);
    }

    public static int getMaxMilliFps(String capabilities, String parameter, String parameterMaxFps) throws Exception {
        try {
            return Panasonic2Helper.getFirstValueAsInt(capabilities, parameterMaxFps) * 1000;
        }
        catch (NumberFormatException ex) {
            return 25000;
        }
    }

    public static int getNumberOfH26xStreams(String capabilities, String codec) {
        if (codec != null && !codec.isEmpty() && capabilities != null && capabilities.contains("video_server.image." + codec)) {
            for (int i = 2; i < 10; ++i) {
                if (capabilities.contains("video_server.image." + codec + "-" + i)) continue;
                return i - 1;
            }
        }
        return 0;
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public int getH264Status() {
        return this.streamSet;
    }

    public void setH264Stream(int streamNumber) {
        this.streamSet += streamNumber;
        this.streamSet = this.streamSet > 3 ? 3 : this.streamSet;
    }

    public void unsetH264Stream(int streamNumber) {
        this.streamSet -= streamNumber;
        this.streamSet = this.streamSet < 0 ? 0 : this.streamSet;
    }

    public int createUID() {
        try {
            String url = "/cgi-bin/getuid?FILE=2&vcodec=jpeg&page=" + System.currentTimeMillis();
            String result = this.getHttpHandler().readGetRequest(url);
            return Integer.parseInt(Panasonic2Helper.getFirstValueAsString(result, "UID"));
        }
        catch (SeeTecException | NumberFormatException ex) {
            this.getLogger().warn((Object)ex, ex);
            return Integer.MIN_VALUE;
        }
    }

    public int getStreamNumber(long fps, int dynamicVideoProfileID) {
        if (fps == 60L) {
            this.h264Streams.put(dynamicVideoProfileID, 1);
            return 1;
        }
        Integer streamNumber = this.h264Streams.get(dynamicVideoProfileID);
        if (streamNumber != null) {
            return streamNumber;
        }
        for (int i = 2; i < 5; ++i) {
            if (this.h264Streams.containsValue(i)) continue;
            this.h264Streams.put(dynamicVideoProfileID, i);
            return i;
        }
        this.getLogger().error("Could not find free stream on camera for " + this);
        return -1;
    }

    public static final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String[] stringArray;
        if (useAuthorization) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            stringArray = stringArray2;
            stringArray2[1] = pass;
        } else {
            stringArray = null;
        }
        NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)host, (int)port, (boolean)false, (int)-1, (int)timeout, stringArray);
        try {
            String url = "/cgi-bin/setdata";
            String response = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/setdata", (int)Integer.MAX_VALUE, (boolean)true));
            if (!response.toLowerCase().contains("camtitle")) {
                return -21697;
            }
        }
        catch (SeeTecException e) {
            switch (e.getNetworkStatus()) {
                case HTTP_UNAUTHORIZED: {
                    return -21701;
                }
            }
            return -21697;
        }
        return 0;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        try {
            try {
                String deviceInfo = this.getHttpHandler().readGetRequest("/cgi-bin/getinfo?FILE=1");
                String capabilities = this.getHttpHandler().readGetRequest("/cgi-bin/get_capability?");
                String currentSignature = Panasonic2Helper.getFirstValueAsString(deviceInfo, "VERSION");
                String currentManufacturer = "i-PRO/Panasonic Smart Driver (H.264/H.265 Generation)";
                this.currentName = Panasonic2Helper.getFirstValueAsString(deviceInfo, "NAME");
                String currentComments = "RE_APP_VERSION::7.4.1_11";
                String currentCaptureModeResolution = Panasonic2Helper.getFirstValueAsString(deviceInfo, "ImageCaptureMode");
                String currentCaptureModeFisheye = Panasonic2Helper.getFirstValueAsString(deviceInfo, "Fisheye_ImageMode");
                String currentCaptureModeAspectRatio = Panasonic2Helper.getFirstValueAsString(deviceInfo, "ratio");
                String currentCaptureModeMaxFPS = Panasonic2Helper.getFirstValueAsString(deviceInfo, "Maxfps");
                String currentCaptureMode = Panasonic2Device.getCurrentCaptureMode(capabilities, currentCaptureModeResolution, currentCaptureModeAspectRatio, currentCaptureModeMaxFPS);
                boolean analyticsModeChanged = false;
                String setup = this.getHttpHandler().readGetRequest("/cgi-bin/setdata");
                AnalyticsMode analyticsMode = AnalyticsMode.VMD;
                String setValue = Panasonic2Helper.readConfiguredValue(setup, "AVMDFUNCTYPE");
                if (setValue.equals("1")) {
                    analyticsMode = AnalyticsMode.IVMD;
                }
                if (this.getDeviceDefinitionFromConfiguration() != null) {
                    boolean supportsIVMD = this.getIVMDSupport();
                    if (!setValue.isEmpty() && (supportsIVMD && analyticsMode == AnalyticsMode.VMD || !supportsIVMD && analyticsMode == AnalyticsMode.IVMD)) {
                        this.logger.info("Panasonic Device Analytics Configuration is not the same as configured events in Cayuga. Re-Reading available events for " + this);
                        analyticsModeChanged = true;
                    }
                }
                if (!(signature != null && signature.equals(currentSignature) && manufacturer != null && manufacturer.equals(currentManufacturer) && name != null && name.equals(this.currentName) && comments != null && comments.equals(currentComments) && this.getCurrentCaptureModeFromDefinition().equals(currentCaptureMode) && !analyticsModeChanged)) {
                    String[] ptzCommands;
                    DeviceDefinition deviceDefinition = new DeviceDefinition();
                    deviceDefinition.setCountFirstChannelOnly(true);
                    deviceDefinition.setSignature(currentSignature);
                    deviceDefinition.setManufacturer(currentManufacturer);
                    CommentsType commentsType = new CommentsType();
                    commentsType.getString().add(currentComments);
                    deviceDefinition.setComments(commentsType);
                    deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SOURCE_PTZ.getType());
                    String apiVersion = "External Interface Specifications Network Camera VER. 1.50";
                    SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                    supportedApiVersionsType.getString().add("External Interface Specifications Network Camera VER. 1.50");
                    deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                    deviceDefinition.setDefaultApiVersion("External Interface Specifications Network Camera VER. 1.50");
                    deviceDefinition.setNoOfCams(Panasonic2Helper.getNumberOfVideoSourcesFromDevice(capabilities));
                    deviceDefinition.setVirtualCameraDefinition(null);
                    DeviceNetworkDefinitionType deviceNetworkDefinitionType = this.getDeviceNetworkDefinitionType(capabilities);
                    deviceDefinition.setDeviceNetworkDefinition(deviceNetworkDefinitionType);
                    int maxNumberOfH264Streams = Panasonic2Device.getNumberOfH26xStreams(capabilities, "h264");
                    int maxNumberOfH265Streams = Panasonic2Device.getNumberOfH26xStreams(capabilities, "h265");
                    MultiStreamingDefinitionsType multiStreamingDefinitionsType = this.getMultiStreamingDefinitionsType(capabilities, maxNumberOfH264Streams, maxNumberOfH265Streams, currentCaptureMode, currentCaptureModeFisheye);
                    int maxNumberOfStreams = this.getMaximalNumberOfStreams(multiStreamingDefinitionsType);
                    if (maxNumberOfStreams < 0) {
                        this.logger.warn("Camera does not support H.264 or H.265. Cannot be used in the smart driver");
                        return null;
                    }
                    SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
                    CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
                    CameraResolutionType captureModeCameraResolutionType = this.getCaptureModeCameraResolutionType();
                    captureModeDefinitionType.setRebootRequired(false);
                    captureModeDefinitionType.setModeSuffix(currentCaptureMode);
                    captureModeDefinitionType.setMaxTotalNumberOfStreams(maxNumberOfStreams);
                    captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
                    captureModeDefinitionType.setResolution(captureModeCameraResolutionType);
                    captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
                    supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
                    deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                    deviceDefinition.setDefaultCaptureModeIndex(0);
                    ImageRotationCapabilitiesType imageRotationCapabilitiesType = this.getImageRotationCapabilitiesType(capabilities);
                    deviceDefinition.setImageRotationCapabilities(imageRotationCapabilitiesType);
                    AudioCapabilitiesType audioCapabilitiesType = Panasonic2Device.getAudioCapabilitiesType(capabilities);
                    deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                    AvailableIOsType availableIOsType = Panasonic2Device.getAvailableIOsType(capabilities, setup);
                    deviceDefinition.setAvailableIOs(availableIOsType);
                    MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = this.getMiscVideoServerCapabilitiesType();
                    SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                    supportedVideoSourceEntityTypesType.getLong().add(210653L);
                    deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                    deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                    deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                    DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
                    deviceGroupMembershipsType.getDeviceGroups().add("ShowChannelSelector");
                    deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
                    deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
                    deviceGroupMembershipsType.getDeviceGroups().add("PresetsImportable");
                    for (String ptzCommand : ptzCommands = Panasonic2Helper.getValuesAsString(capabilities, "video_server.cam_ctrl.ptz.command")) {
                        if (!ptzCommand.equalsIgnoreCase("drag_zoom")) continue;
                        deviceGroupMembershipsType.getDeviceGroups().add("OpticalZoomAreaSupported");
                    }
                    deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                    deviceDefinition.setEntityType(200555L);
                    deviceDefinition.setName(this.currentName);
                    return deviceDefinition;
                }
            }
            catch (Throwable exception) {
                this.getLogger().warn("Error while reading information from " + this + ": " + exception.getMessage(), exception);
                if (exception instanceof SeeTecException) {
                    throw new SeeTecException(((SeeTecException)exception).getErrorCode(), exception.getMessage());
                }
                throw new SeeTecException(-21600, exception.getMessage());
            }
        }
        catch (SeeTecException ex) {
            this.getLogger().error("Problems while getting definition from device for " + this, (Throwable)ex);
            throw ex;
        }
        return null;
    }

    @Override
    protected IOHandler createIOHandler() {
        if (this.isShutdown(CLASS_NAME)) {
            this.getLogger().error(this + " is already shutting down");
            return null;
        }
        Panasonic2IOHandler panasonic2IOHandler = new Panasonic2IOHandler();
        panasonic2IOHandler.setDevice(this);
        return panasonic2IOHandler;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        try {
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            boolean ptzAvailable = true;
            videoCameraDefinition.setManufacturer("Panasonic Smart Driver");
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(ptzAvailable ? MediaID.VIDEO_SOURCE_PTZ.getType() : MediaID.VIDEO_SOURCE_DIGITAL.getType());
            videoCameraDefinition.setName(this.currentName);
            videoCameraDefinition.setEntityType(210653L);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = new FeaturesType();
            if (ptzAvailable) {
                String capabilities = this.getHttpHandler().readGetRequest(Panasonic2Query.getControlPtz().getCapabilities());
                featuresType = this.getPTZfeaturesType(capabilities);
            }
            videoCameraDefinition.setFeatures(featuresType);
            if (this.getLogger().isDebugEnabled()) {
                try {
                    String videoSourceDefinitionXml = Basic.marshalXML((Object)videoCameraDefinition);
                    this.getLogger().info(videoSourceDefinitionXml);
                }
                catch (JAXBException | SAXException ex) {
                    this.getLogger().debug("Error while displaying definitions: " + ex.getMessage());
                }
            }
            return videoCameraDefinition;
        }
        catch (Exception e) {
            this.getLogger().warn("Error while reading information from " + this, (Throwable)e);
            throw new SeeTecException(-21600, e.getMessage());
        }
    }

    public FeaturesType getPTZfeaturesType(String capabilities) throws Exception {
        FeaturesType featuresType = new FeaturesType();
        try {
            String[] ptzCommands;
            String ptzSupported = Panasonic2Helper.getFirstValueAsString(capabilities, "video_server.cam_ctrl.ptz.supported");
            if ("yes".equalsIgnoreCase(ptzSupported)) {
                int maxZoom;
                String cameraSettings = this.getHttpHandler().readGetRequest(Panasonic2Query.getControlPtz().getData());
                String zoomSetting = Panasonic2Helper.readConfiguredValue(cameraSettings, "ZOOM");
                featuresType.setCanAbsolutePan(false);
                featuresType.setCanAbsoluteTilt(false);
                featuresType.setCanAbsoluteZoom(true);
                featuresType.setMinAbsoluteZoom(10);
                int maxOpticalZoom = Panasonic2Helper.getFirstValueAsInt(capabilities, "video_server.cam_ctrl.ptz.zoom");
                if (Panasonic2ControlQuery.ZOOM_FUNCTIONALITY.DIGITAL_ENABLED.getValue().equals(zoomSetting)) {
                    int maxDigitalZoom = Panasonic2Helper.getFirstValueAsInt(capabilities, "video_server.cam_ctrl.ptz.el_zoom");
                    maxZoom = maxOpticalZoom * maxDigitalZoom;
                } else {
                    maxZoom = maxOpticalZoom;
                }
                if (maxZoom > 999) {
                    maxZoom = 999;
                }
                featuresType.setMaxAbsoluteZoom(maxZoom * 10);
            }
            featuresType.setMinPan(-180000);
            featuresType.setMaxPan(180000);
            featuresType.setCanRelativePan(false);
            featuresType.setCanContinuousPan(true);
            featuresType.setMinTilt(0);
            featuresType.setMaxTilt(90000);
            featuresType.setCanRelativeTilt(false);
            featuresType.setCanContinuousTilt(true);
            String presetsSupported = Panasonic2Helper.getFirstValueAsString(capabilities, "video_server.cam_ctrl.preset.supported");
            if (presetsSupported.equalsIgnoreCase("yes")) {
                featuresType.setCanPreset(true);
            }
            featuresType.setCanContinuousZoom(true);
            featuresType.setCanRelativeZoom(false);
            featuresType.setMinZoom(0);
            featuresType.setMaxZoom(100000);
            for (String ptzCommand : ptzCommands = Panasonic2Helper.getValuesAsString(capabilities, "video_server.cam_ctrl.ptz.command")) {
                if (!ptzCommand.equals("click_centering")) continue;
                featuresType.setCanCenterPT(true);
            }
            String focusSupported = Panasonic2Helper.getFirstValueAsString(capabilities, "video_server.cam_ctrl.focus.supported");
            featuresType.setCanFocus(focusSupported.equalsIgnoreCase("yes"));
            String autoFocusSupported = Panasonic2Helper.getFirstValueAsString(capabilities, "video_server.cam_ctrl.auto_focus.supported");
            featuresType.setCanAutoFocus(autoFocusSupported.equalsIgnoreCase("yes"));
            String irisSupported = Panasonic2Helper.getFirstValueAsString(capabilities, "video_server.cam_ctrl.ptz.brightness.supported");
            featuresType.setCanIris(irisSupported.equalsIgnoreCase("yes"));
            featuresType.setCanAutoIris(true);
            String nullLuxSupported = Panasonic2Helper.getFirstValueAsString(capabilities, "video_server.cam_ctrl.bw.supported");
            featuresType.setCanNullLux(nullLuxSupported.equalsIgnoreCase("yes"));
            featuresType.setCanAutoNullLux(true);
            featuresType.setMinSpeed(0);
            featuresType.setMaxSpeed(100000);
            featuresType.setPTZMinContinuousLevel(10000);
            featuresType.setPTZMaxContinuousLevel(100000);
            featuresType.setPTZContinuousSpeedFactor(1000);
        }
        catch (Exception ex) {
            this.getLogger().error("Problems while geting PTZ definitions from device for " + this, (Throwable)ex);
            throw ex;
        }
        return featuresType;
    }

    protected VirtualCameraDefinitionType getVirtualCameraDefinitionType() {
        return null;
    }

    protected DeviceNetworkDefinitionType getDeviceNetworkDefinitionType(String capabilities) {
        DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
        deviceNetworkDefinitionType.setCanChangeHttpPort(true);
        String httpsCapability = Panasonic2Helper.getFirstValueAsString(capabilities, "video_server.network.https.supported");
        deviceNetworkDefinitionType.setCanHttps(httpsCapability.toLowerCase().equals("yes"));
        deviceNetworkDefinitionType.setCanChangeHttpsPort(httpsCapability.toLowerCase().equals("yes"));
        deviceNetworkDefinitionType.setDefaultHttpPort(80);
        deviceNetworkDefinitionType.setDefaultHttpsPort(443);
        deviceNetworkDefinitionType.setDefaultUserName("admin");
        deviceNetworkDefinitionType.setDefaultVideoStreamNetworkTimeout(5000L);
        deviceNetworkDefinitionType.setMaxVideoStreamNetworkTimeout(5000L);
        deviceNetworkDefinitionType.setMinVideoStreamNetworkTimeout(5000L);
        deviceNetworkDefinitionType.setUseAuthentication(true);
        return deviceNetworkDefinitionType;
    }

    protected MultiStreamingDefinitionsType getMultiStreamingDefinitionsType(String capabilities, int maxNumberOfH264Streams, int maxNumberOfH265Streams, String currentCaptureMode, String currentCaptureModeFisheye) throws Exception {
        int i;
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        StreamDefinitionType mjpegStreamDefinitionType = this.getMJPEGStreamDefinitionType(capabilities, currentCaptureMode);
        multiStreamingDefinitionsType.getStreamDefinition().add(mjpegStreamDefinitionType);
        for (i = 1; i <= maxNumberOfH264Streams; ++i) {
            StreamDefinitionType h264StreamDefinitionType = this.getH26xStreamDefinitionType(capabilities, currentCaptureMode, currentCaptureModeFisheye, Codec.H264, i);
            if (h264StreamDefinitionType.getSupportedCameraResolutions().getCameraResolution().size() <= 0) continue;
            multiStreamingDefinitionsType.getStreamDefinition().add(h264StreamDefinitionType);
        }
        for (i = 1; i <= maxNumberOfH265Streams; ++i) {
            StreamDefinitionType h265StreamDefinitionType = this.getH26xStreamDefinitionType(capabilities, currentCaptureMode, currentCaptureModeFisheye, Codec.H265, i);
            if (h265StreamDefinitionType.getSupportedCameraResolutions().getCameraResolution().size() <= 0) continue;
            multiStreamingDefinitionsType.getStreamDefinition().add(h265StreamDefinitionType);
        }
        return multiStreamingDefinitionsType;
    }

    protected CameraResolutionType getCaptureModeCameraResolutionType() {
        CameraResolutionType captureModeCameraResolutionType = new CameraResolutionType();
        int fps = 30;
        int biggestWidth = 1000;
        int biggestHeight = 500;
        captureModeCameraResolutionType.setDisplayResolution("DefaultCaptureMode");
        captureModeCameraResolutionType.setWidth(biggestWidth);
        captureModeCameraResolutionType.setHeight(biggestHeight);
        captureModeCameraResolutionType.setMaxMilliFPS(fps * 10);
        captureModeCameraResolutionType.setMinMilliFPS(1);
        captureModeCameraResolutionType.setResolution(biggestWidth + "x" + biggestHeight);
        captureModeCameraResolutionType.setSupportedFrameRates(null);
        return captureModeCameraResolutionType;
    }

    public ImageRotationCapabilitiesType getImageRotationCapabilitiesType(String capabilities) throws Exception {
        ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
        String canImageRotation = Panasonic2Helper.getFirstValueAsString(capabilities, "video_server.image.rotation.supported");
        SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
        imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        boolean canRotateImageOnCamera = false;
        if (canImageRotation.trim().toLowerCase().equals("yes")) {
            int[] imageRotation;
            canRotateImageOnCamera = true;
            imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
            for (int rotation : imageRotation = Panasonic2Helper.getValuesAsInt(capabilities, "video_server.image.rotation.parameter")) {
                imageRotationCapabilitiesType.getSupportedRotationAngles().getInt().add(rotation * 1000);
            }
        } else if (canImageRotation.isEmpty() || canImageRotation.toLowerCase().equals("no")) {
            String url = "/cgi-bin/set_basic?upsidedown=1";
            this.getHttpHandler().readGetRequest(url);
            url = "/cgi-bin/setdata";
            String configuration = this.getHttpHandler().readGetRequest(url);
            if (Panasonic2Helper.readConfiguredValue(configuration, "UPSIDEDOWN").equals("1")) {
                canRotateImageOnCamera = true;
                imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
                imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
                imageRotationCapabilitiesType.getSupportedRotationAngles().getInt().add(0);
                imageRotationCapabilitiesType.getSupportedRotationAngles().getInt().add(180000);
            }
        }
        if (!canRotateImageOnCamera) {
            imageRotationCapabilitiesType.setCanRotateJPEGImage(false);
            imageRotationCapabilitiesType.setCanRotateMPEGImage(false);
            imageRotationCapabilitiesType.getSupportedRotationAngles().getInt().add(0);
            imageRotationCapabilitiesType.getSupportedRotationAngles().getInt().add(180000);
        }
        return imageRotationCapabilitiesType;
    }

    public static AudioCapabilitiesType getAudioCapabilitiesType(String capabilities) throws Exception {
        AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
        int numberOfAudioInputs = Panasonic2Helper.getFirstValueAsInt(capabilities, "video_server.audio.audio_input.number");
        if (numberOfAudioInputs > 0) {
            audioCapabilitiesType.setCanAudio(true);
            AudioCodecsType audioCodecsType = new AudioCodecsType();
            AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
            CodecType codecType = new CodecType();
            codecType.setValue(Codec.G711U.getType());
            audioCodecDefinitionType.setAudioCodec(codecType);
            audioCodecDefinitionType.setBitrate(64000);
            audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
            audioCapabilitiesType.setAudioCodecs(audioCodecsType);
        }
        return audioCapabilitiesType;
    }

    public static AvailableIOsType getAvailableIOsType(String capabilities, String setup) throws Exception {
        AvailableIOsType availableIOsType = new AvailableIOsType();
        int ports = Panasonic2Helper.getFirstValueAsInt(capabilities, "video_server.peripheral.io.number");
        if (ports > 0) {
            for (int i = 0; i < ports; ++i) {
                String parameter = "atrmin" + (i > 0 ? Integer.valueOf(i + 1) : "");
                String setValue = Panasonic2Helper.readConfiguredValue(setup, parameter);
                if (setValue.equals("1")) {
                    availableIOsType.getInputOutputCapabilities().add(0);
                    continue;
                }
                if (!setValue.equals("3")) continue;
                availableIOsType.getInputOutputCapabilities().add(1);
            }
        }
        return availableIOsType;
    }

    protected MiscVideoServerCapabilitiesType getMiscVideoServerCapabilitiesType() {
        MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
        miscVideoServerCapabilitiesType.setCanTimeDate(true);
        miscVideoServerCapabilitiesType.setCanTitle(true);
        miscVideoServerCapabilitiesType.setCanDetectTampering(false);
        miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
        miscVideoServerCapabilitiesType.setCanTimeshift(false);
        miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
        miscVideoServerCapabilitiesType.setCanPTZ(true);
        return miscVideoServerCapabilitiesType;
    }

    protected StreamDefinitionType getMJPEGStreamDefinitionType(String capabilities, String currentCaptureMode) throws Exception {
        StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
        streamDefinitionType.setDefaultCameraResolutionIndex(0);
        streamDefinitionType.setDefaultMilliFPS(8000);
        streamDefinitionType.setDefaultTransmissionTypeIndex(0);
        streamDefinitionType.setHideBandwithField(true);
        streamDefinitionType.setHideFPSField(false);
        streamDefinitionType.setHideIFrameField(true);
        streamDefinitionType.setHideKompressionField(false);
        streamDefinitionType.setMaxNumberOfStreams(1);
        streamDefinitionType.setName("MJPEG");
        CodecType codecType = new CodecType();
        codecType.setValue(Codec.MJPEG.getType());
        streamDefinitionType.setStreamingMode(codecType);
        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.HTTP_SERVERPUSH.getType());
        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
        int maxMilliFps = Panasonic2Device.getMaxMilliFps(capabilities, "video_server.image.mjpeg.framerate", "video_server.image.mjpeg.max_framerate." + currentCaptureMode);
        SupportedCameraResolutionsType supportedCameraResolutionsType = this.getMJPEGCameraResolutions(capabilities, "video_server.image.mjpeg.resolution_each_mode_all." + currentCaptureMode, maxMilliFps);
        streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
        return streamDefinitionType;
    }

    public SupportedCameraResolutionsType getH26xCameraResolutions(String capabilities, String parameterName, String currentCaptureMode, String currentCaptureModeFisheye, int maxMilliFps) {
        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
        String[] resolutions = Panasonic2Helper.getValuesAsString(capabilities, parameterName + currentCaptureMode);
        if (resolutions.length == 0) {
            resolutions = Panasonic2Helper.getValuesAsString(capabilities, parameterName + currentCaptureModeFisheye);
        }
        for (String resolutionFromCamera : resolutions) {
            String[] resolutionParts = resolutionFromCamera.split("x");
            if (resolutionParts.length == 2) {
                CameraResolutionType cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setDisplayResolution(resolutionFromCamera);
                cameraResolutionType.setWidth(Integer.parseInt(resolutionParts[0]));
                cameraResolutionType.setHeight(Integer.parseInt(resolutionParts[1]));
                cameraResolutionType.setMinMilliFPS(1000);
                cameraResolutionType.setMaxMilliFPS(maxMilliFps);
                supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
                continue;
            }
            this.getLogger().warn("Could not parse resolution for " + this + " Resolution given by camera: " + resolutionFromCamera);
        }
        return supportedCameraResolutionsType;
    }

    protected StreamDefinitionType getH26xStreamDefinitionType(String capabilities, String currentCaptureMode, String currentCaptureModeFisheye, Codec codec, int streamNumber) throws Exception {
        String prefix = "video_server.image." + (codec == Codec.H264 ? "h264" : "h265") + (streamNumber > 1 ? "-" + streamNumber : "");
        StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
        streamDefinitionType.setDefaultCameraResolutionIndex(0);
        streamDefinitionType.setDefaultMilliFPS(8000);
        streamDefinitionType.setHideBandwithField(false);
        int maxBandwidth = Panasonic2Device.getSupportedBitrates(capabilities, prefix + ".bandwidth");
        BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
        bitrateSettingsType.setCanCBR(true);
        bitrateSettingsType.setMinBandwidth(1024);
        bitrateSettingsType.setCanVBR(true);
        bitrateSettingsType.setCanVBRQuality(true);
        bitrateSettingsType.setCanVBRBandwidth(true);
        bitrateSettingsType.setMaxBandwidth(maxBandwidth);
        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
        streamDefinitionType.setHideKompressionField(false);
        String parameter = "video_server.image." + (codec == Codec.H264 ? "h264" : "h265") + (streamNumber > 1 ? "-" + streamNumber : "") + ".i_interval";
        List<Integer> iFrameDistances = Panasonic2Device.getIFrameDistances(capabilities, parameter);
        streamDefinitionType.setMinIFrameDistance(iFrameDistances.get(0));
        streamDefinitionType.setMaxIFrameDistance(iFrameDistances.get(iFrameDistances.size() - 1));
        streamDefinitionType.setHideFPSField(false);
        streamDefinitionType.setHideIFrameField(false);
        streamDefinitionType.setMaxNumberOfStreams(1);
        streamDefinitionType.setName(codec == Codec.H264 ? "H.264 " + streamNumber + "" : "H.265 " + streamNumber);
        CodecType codecType = new CodecType();
        codecType.setValue(codec.getType());
        streamDefinitionType.setStreamingMode(codecType);
        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
        streamDefinitionType.setDefaultTransmissionTypeIndex(0);
        int maxMilliFps = Panasonic2Device.getMaxMilliFps(capabilities, prefix + ".framerate", prefix + ".max_framerate." + currentCaptureMode);
        SupportedCameraResolutionsType supportedCameraResolutionsType = this.getH26xCameraResolutions(capabilities, prefix + ".resolution_each_mode.", currentCaptureMode, currentCaptureModeFisheye, maxMilliFps);
        streamDefinitionType.setSupportedCameraResolutions(supportedCameraResolutionsType);
        if (codec == Codec.H264) {
            SupportedMPEGProfileIDs supportedMPEGProfileIDs = this.getSupportedMPEGProfileIds();
            streamDefinitionType.setSupportedMPEGProfileIDs(supportedMPEGProfileIDs);
            streamDefinitionType.setDefaultTransmissionTypeIndex(0);
        }
        return streamDefinitionType;
    }

    public static List<Integer> getIFrameDistances(String capabilities, String parameter) throws Exception {
        double[] iframeDistances;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (double distance : iframeDistances = Panasonic2Helper.getValuesAsDouble(capabilities, parameter)) {
            Integer iFrameDistance = (int)Math.round(distance * 1000.0);
            ret.add(iFrameDistance);
        }
        Collections.sort(ret);
        return ret;
    }

    protected int getMaximalNumberOfStreams(MultiStreamingDefinitionsType multiStreamingDefinitionsType) {
        List<StreamDefinitionType> streams = multiStreamingDefinitionsType.getStreamDefinition();
        int numberOfJpegStreams = 0;
        int numberOfH264Streams = 0;
        int numberOfH265Streams = 0;
        for (int i = 0; i < streams.size(); ++i) {
            if (streams.get(i).getStreamingMode().getValue() == Codec.MJPEG.getType()) {
                ++numberOfJpegStreams;
                continue;
            }
            if (streams.get(i).getStreamingMode().getValue() == Codec.H264.getType()) {
                ++numberOfH264Streams;
                continue;
            }
            if (streams.get(i).getStreamingMode().getValue() != Codec.H265.getType()) continue;
            ++numberOfH265Streams;
        }
        if (numberOfH265Streams + numberOfH264Streams == 0) {
            return -1;
        }
        return numberOfJpegStreams + Math.max(numberOfH264Streams, numberOfH265Streams);
    }

    private SupportedCameraResolutionsType getMJPEGCameraResolutions(String capabilities, String parameterName, int maxMilliFps) {
        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
        String[] resolutions = Panasonic2Helper.getValuesAsString(capabilities, parameterName);
        if (resolutions.length == 0) {
            parameterName = parameterName.replace("_all", "");
            resolutions = Panasonic2Helper.getValuesAsString(capabilities, parameterName);
        }
        for (String resolutionFromCamera : resolutions) {
            String[] resolutionParts = resolutionFromCamera.split("x");
            if (resolutionParts.length == 2) {
                CameraResolutionType cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setDisplayResolution(resolutionFromCamera);
                cameraResolutionType.setWidth(Integer.parseInt(resolutionParts[0]));
                cameraResolutionType.setHeight(Integer.parseInt(resolutionParts[1]));
                cameraResolutionType.setMinMilliFPS(1000);
                cameraResolutionType.setMaxMilliFPS(maxMilliFps);
                supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
                continue;
            }
            this.getLogger().warn("Could not parse resolution for " + this + " Resolution given by camera: " + resolutionFromCamera);
        }
        return supportedCameraResolutionsType;
    }

    protected String getCurrentCaptureModeFromDefinition() {
        String foundDisplayResolutionInDefinition = null;
        try {
            List<CaptureModeDefinitionType> list = this.getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition();
            if (!list.isEmpty()) {
                foundDisplayResolutionInDefinition = list.get(0).getModeSuffix();
            }
        }
        catch (Exception e) {
            this.logger.warn("Could not find out currently set capture mode.");
            foundDisplayResolutionInDefinition = null;
        }
        return foundDisplayResolutionInDefinition;
    }

    @Override
    public SupportedGenericEventsType getGenericEventTrigger() {
        SupportedGenericEventsType supportedGenericEventsType;
        block31: {
            supportedGenericEventsType = new SupportedGenericEventsType();
            try {
                String setup = this.getHttpHandler().readGetRequest("/cgi-bin/setdata");
                String deviceInfo = this.getHttpHandler().readGetRequest("/cgi-bin/getinfo?FILE=1");
                String setValue = Panasonic2Helper.readConfiguredValue(setup, "AVMDFUNCTYPE");
                AnalyticsMode analyticsMode = AnalyticsMode.VMD;
                if (setValue.equals("1")) {
                    analyticsMode = AnalyticsMode.IVMD;
                }
                String capabilities = this.getHttpHandler().readGetRequest("/cgi-bin/get_capability?");
                int[] formats = Panasonic2Helper.getValuesAsInt(capabilities, "video_server.alarm.get_io2.format");
                int numberOfChannels = Panasonic2Helper.getNumberOfVideoSourcesFromDevice(capabilities);
                if (formats.length == 3 && formats[2] == 3) {
                    this.genericEventsSupported = true;
                }
                if (this.genericEventsSupported) {
                    int i;
                    Panasonic2TriggerReader panasonic2TriggerReader = new Panasonic2TriggerReader(this.networkParameter);
                    panasonic2TriggerReader.init();
                    while (panasonic2TriggerReader.isServerPushRunning()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception ex) {
                            this.logger.warn("Exception while waiting for Panasonic2TriggerReader to finish for " + this);
                        }
                    }
                    String eventListFromAlarm = panasonic2TriggerReader.getData();
                    this.logger.info(eventListFromAlarm);
                    String[] eventListFromAlarmParts = eventListFromAlarm.split("\r\n");
                    String[][] events = new String[numberOfChannels][];
                    for (i = 0; i < numberOfChannels; ++i) {
                        events[i] = Panasonic2Helper.getValuesAsString(capabilities, "video_server.meta.type_ch" + (i + 1));
                    }
                    if (events.length == 0 || events[0].length == 0) {
                        for (i = 0; i < numberOfChannels; ++i) {
                            events[i] = Panasonic2Helper.getValuesAsString(capabilities, "video_server.meta.type");
                        }
                    }
                    for (String event : events[0]) {
                        if (!event.contains("audio_detect")) continue;
                        GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                        genericEventDefinitionType.setEventType("Audio Detection");
                        genericEventDefinitionType.setSourceNumber(0);
                        supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                    }
                    if (eventListFromAlarm.toLowerCase().contains("command=")) {
                        GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                        genericEventDefinitionType.setEventType("Command");
                        genericEventDefinitionType.setSourceNumber(0);
                        supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                    }
                    for (int i2 = 0; i2 < numberOfChannels; ++i2) {
                        String[] eventNames;
                        String[] eventList;
                        for (String event : eventList = events[i2]) {
                            Object genericEventDefinitionType;
                            if (analyticsMode == AnalyticsMode.VMD && event.equals("vmd")) {
                                genericEventDefinitionType = new GenericEventDefinitionType();
                                ((GenericEventDefinitionType)genericEventDefinitionType).setEventType("vmd");
                                ((GenericEventDefinitionType)genericEventDefinitionType).setSourceNumber(i2 + 1);
                                supportedGenericEventsType.getGenericEventDefinition().add((GenericEventDefinitionType)genericEventDefinitionType);
                                int numberOfMDWindows = Panasonic2Helper.getFirstValueAsInt(capabilities, "video_server.vmd.area_num");
                                for (int j = 0; j < numberOfMDWindows; ++j) {
                                    genericEventDefinitionType = new GenericEventDefinitionType();
                                    ((GenericEventDefinitionType)genericEventDefinitionType).setEventType("Motion detection window " + (j + 1));
                                    ((GenericEventDefinitionType)genericEventDefinitionType).setSourceNumber(i2 + 1);
                                    supportedGenericEventsType.getGenericEventDefinition().add((GenericEventDefinitionType)genericEventDefinitionType);
                                }
                                continue;
                            }
                            if (event.equals("attrack")) {
                                genericEventDefinitionType = new GenericEventDefinitionType();
                                ((GenericEventDefinitionType)genericEventDefinitionType).setEventType("Auto tracking");
                                ((GenericEventDefinitionType)genericEventDefinitionType).setSourceNumber(i2 + 1);
                                supportedGenericEventsType.getGenericEventDefinition().add((GenericEventDefinitionType)genericEventDefinitionType);
                                continue;
                            }
                            if (analyticsMode != AnalyticsMode.IVMD || !event.equals("ivmd")) continue;
                            for (String ivmdEvent : eventListFromAlarmParts) {
                                String eventName = "";
                                if (ivmdEvent.toLowerCase().startsWith("intruder")) {
                                    eventName = "Intruder detection";
                                } else if (ivmdEvent.toLowerCase().startsWith("loitering")) {
                                    eventName = "Loitering detection";
                                } else if (ivmdEvent.toLowerCase().startsWith("direction")) {
                                    eventName = "Direction detection";
                                } else if (ivmdEvent.toLowerCase().startsWith("scenechange")) {
                                    eventName = "Scene change detection";
                                } else if (ivmdEvent.toLowerCase().startsWith("object")) {
                                    eventName = "Object detection";
                                } else if (ivmdEvent.toLowerCase().startsWith("crossline")) {
                                    eventName = "Crossline detection";
                                }
                                if (eventName.isEmpty()) continue;
                                GenericEventDefinitionType genericEventDefinitionType2 = new GenericEventDefinitionType();
                                genericEventDefinitionType2.setEventType(eventName);
                                genericEventDefinitionType2.setSourceNumber(i2 + 1);
                                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType2);
                            }
                        }
                        if (!Panasonic2Helper.isAiVmdSupported(deviceInfo)) continue;
                        for (String eventName : eventNames = new String[]{"Intruder detection", "Loitering detection", "Direction detection", "Crossline detection"}) {
                            GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                            genericEventDefinitionType.setEventType(eventName);
                            genericEventDefinitionType.setSourceNumber(i2 + 1);
                            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                        }
                    }
                    break block31;
                }
                GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                genericEventDefinitionType.setEventType("vmd");
                genericEventDefinitionType.setSourceNumber(1);
                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
            }
            catch (Exception ex) {
                this.logger.warn("Could not read smart events from device " + this + ": " + ex.getMessage());
            }
        }
        return supportedGenericEventsType;
    }

    private SupportedMPEGProfileIDs getSupportedMPEGProfileIds() {
        SupportedMPEGProfileIDs supportedMPEGProfileIds = new SupportedMPEGProfileIDs();
        supportedMPEGProfileIds.getInt().add(MpegProfile.BASELINE.getType());
        supportedMPEGProfileIds.getInt().add(MpegProfile.HIGH.getType());
        return supportedMPEGProfileIds;
    }

    private boolean getIVMDSupport() {
        List<GenericEventDefinitionType> genericEvents = null;
        genericEvents = this.getDeviceDefinitionFromConfiguration().getSupportedGenericEvents().getGenericEventDefinition();
        for (GenericEventDefinitionType genericEventDefinitionType : genericEvents) {
            String eventName = genericEventDefinitionType.getEventType().toLowerCase();
            if (!eventName.equals("crossline detection") && !eventName.equals("intruder detection") && !eventName.equals("loitering detection") && !eventName.equals("object detection") && !eventName.equals("scene change detection")) continue;
            return true;
        }
        return false;
    }
}

