/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2;

import de.seetec.v5.re.cm.device.video.axis.utils.Query;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Query;

public class Panasonic2ControlQuery
extends Panasonic2Query {
    private static final String PTZ_ABSOLUTE_ZOOM = "zoom";
    private static final String SET_ZOOM_FUNCTION = "elzoom";

    public Panasonic2ControlQuery zoom(Integer value) {
        if (value == null) {
            return this;
        }
        super.setTarget(ControlType.PTZ_ABSOLUTE_CONTROL.getTarget());
        return this.newParam(PTZ_ABSOLUTE_ZOOM, value);
    }

    public Panasonic2ControlQuery autoFocus(Boolean value) {
        if (value == null) {
            return this;
        }
        super.setTarget(ControlType.PTZ_ABSOLUTE_CONTROL.getTarget());
        return this.newParam(PTZ_ABSOLUTE_ZOOM, value);
    }

    public String getPosition() {
        super.setTarget(ControlType.PTZ_GET_ABSOLUTE_VALUES.getTarget());
        return this.toString();
    }

    public String getCapabilities() {
        super.setTarget(ControlType.CAM_CAPABILITIES.getTarget());
        return this.toString();
    }

    public String getData() {
        super.setTarget(ControlType.CAM_DATA.getTarget());
        return this.toString();
    }

    public Panasonic2ControlQuery setZoomFunctionality(ZOOM_FUNCTIONALITY functionality) {
        super.setTarget(ControlType.SET_CAM_FUNCTIONS.getTarget());
        return this.newParam(SET_ZOOM_FUNCTION, functionality.getValue());
    }

    private <T> Panasonic2ControlQuery newParam(String name, T value) {
        this.addParam(new Query.Parameter(name, String.valueOf(value)));
        return this;
    }

    public static enum ZOOM_FUNCTIONALITY {
        EXTRA_OPTICAL_DISABLED("0"),
        EXTRA_OPTICAL_ENABLED("3"),
        DIGITAL_ENABLED("36");

        String value;

        private ZOOM_FUNCTIONALITY(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ControlType {
        PTZ_GET_ABSOLUTE_VALUES("/absget"),
        PTZ_ABSOLUTE_CONTROL("/absctrl"),
        CAM_CAPABILITIES("/get_capability"),
        CAM_DATA("/getdata"),
        SET_CAM_FUNCTIONS("/set_camfunc");

        private String path;

        private ControlType(String path) {
            this.path = path;
        }

        private String getTarget() {
            return "/cgi-bin" + this.path;
        }
    }
}

