/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2CameraControl;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Device;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Helper;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2TriggerHandler;
import de.seetec.v5.re.cm.device.video.panasonic2.jpeg.Panasonic2JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.panasonic2.mpeg.Panasonic2H26xVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.locks.ReentrantLock;

public class Panasonic2CameraSrv
extends LiveCameraSrv {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2CameraSrv";
    private boolean streamHandlingDone;
    private Boolean videoSourceParametersSet = false;
    private final ReentrantLock reentrantLock = new ReentrantLock(false);

    @Override
    public final CameraControl createCameraControl(Long entityType) {
        Panasonic2CameraControl panasonic2CameraControl = new Panasonic2CameraControl();
        panasonic2CameraControl.setPanasonic2Device((Panasonic2Device)this.device);
        return panasonic2CameraControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVideoSourceParameters(String data, String capabilities, boolean useDateTime, boolean useTitle, String title, int rotation, int channel) throws ConfigurationException, SeeTecException {
        block26: {
            this.reentrantLock.lock();
            try {
                StringBuilder url;
                boolean isMultiChannelDevice;
                boolean bl = isMultiChannelDevice = this.getDevice().getNumberOfVideoSources() > 1;
                if (this.videoSourceParametersSet.booleanValue()) break block26;
                String videoSource = "";
                if (isMultiChannelDevice) {
                    videoSource = videoSource + channel;
                }
                if (!Panasonic2CameraSrv.isTimeDisplaySet(data, useDateTime, channel)) {
                    url = new StringBuilder("/cgi-bin/set_basic?");
                    if (Panasonic2Helper.getNumberOfVideoSourcesFromDevice(capabilities) == 1) {
                        if (useDateTime) {
                            url.append("time_display=24");
                        } else {
                            url.append("time_display=off");
                        }
                    } else if (useDateTime) {
                        url.append("timeonoff_display").append(videoSource).append("=1");
                    } else {
                        url.append("timeonoff_display").append(videoSource).append("=0");
                    }
                    try {
                        this.getPanasonic2Device().getHttpHandler().readGetRequest(url.toString());
                    }
                    catch (Exception ex) {
                        this.logger.warn("Exception while setting time display for " + this + ": " + ex.getMessage());
                        this.logger.warn("Continuing anyway...");
                    }
                }
                if (!Panasonic2CameraSrv.isImageRotationSet(data, rotation, channel)) {
                    url = new StringBuilder("/cgi-bin/set_basic?");
                    switch (rotation) {
                        case 0: {
                            url.append("upsidedown").append(videoSource).append("=0");
                            break;
                        }
                        case 90: {
                            url.append("img_rotate").append("=90");
                            break;
                        }
                        case 180: {
                            url.append("upsidedown").append(videoSource).append("=1");
                            break;
                        }
                        default: {
                            url.append("img_rotate").append("=270");
                        }
                    }
                    try {
                        this.getPanasonic2Device().getHttpHandler().readGetRequest(url.toString());
                    }
                    catch (Exception ex) {
                        this.logger.warn("Exception while setting image rotation for " + this + ": " + ex.getMessage());
                        this.logger.warn("Continuing anyway...");
                    }
                }
                if (!Panasonic2CameraSrv.isTitleSet(data, useTitle, title, channel)) {
                    url = new StringBuilder("/cgi-bin/set_basic?");
                    if (useTitle) {
                        url.append("camid_display").append(videoSource).append("=1");
                        url.append("&camid").append(videoSource);
                        title = title.length() > 16 ? title.substring(0, 16) : title;
                        url.append("=");
                        url.append(title.toUpperCase());
                    } else {
                        url.append("camid_display").append(videoSource).append("=0");
                    }
                    try {
                        this.getPanasonic2Device().getHttpHandler().readGetRequest(url.toString());
                    }
                    catch (Exception ex) {
                        this.logger.warn("Exception while setting title display for " + this + ": " + ex.getMessage());
                        this.logger.warn("Continuing anyway...");
                    }
                }
                this.videoSourceParametersSet = true;
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
    }

    @Override
    public final VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        Panasonic2H26xVideoSourceClient panasonic2H26xVideoSourceClient = null;
        Panasonic2JPEGVideoSourceClient panasonic2JPEGVideoSourceClient = null;
        Codec codec = null;
        try {
            codec = listener.getVideoSourceParameter().getMediaCodec();
            if (codec == Codec.H264 || codec == Codec.H265) {
                panasonic2H26xVideoSourceClient = new Panasonic2H26xVideoSourceClient();
                panasonic2H26xVideoSourceClient.setDevice((Panasonic2Device)this.device);
                int errorCode = panasonic2H26xVideoSourceClient.init(core, this, listener);
                if (errorCode != 0) {
                    panasonic2H26xVideoSourceClient.shutdown();
                    this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                    throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
            } else {
                panasonic2JPEGVideoSourceClient = new Panasonic2JPEGVideoSourceClient();
                panasonic2JPEGVideoSourceClient.setDevice((Panasonic2Device)this.device);
                int errorCode = panasonic2JPEGVideoSourceClient.init(core, this, listener);
                if (errorCode != 0) {
                    panasonic2JPEGVideoSourceClient.shutdown();
                    this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                    throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (ConfigurationException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        if (codec == Codec.H264 || codec == Codec.H265) {
            return panasonic2H26xVideoSourceClient;
        }
        return panasonic2JPEGVideoSourceClient;
    }

    @Override
    public final ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public final synchronized int handleStreams() {
        if (this.streamHandlingDone) {
            return 0;
        }
        try {
            if (this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec() == Codec.MJPEG && this.getAdditionalVideoProfileHandler().length == 0) {
                String url = "/cgi-bin/set_h264";
                String body = "h264_transmit=0";
                this.getPanasonic2Device().getHttpHandler().readPostRequest(url, body);
                this.getPanasonic2Device().getHttpHandler().readPostRequest(url + "_2", body);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while handling h.264 streams for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while retrieving network parameters for " + this + ": " + ex.getMessage());
        }
        this.streamHandlingDone = true;
        return 0;
    }

    private Panasonic2Device getPanasonic2Device() throws SeeTecException {
        if (this.device instanceof Panasonic2Device) {
            return (Panasonic2Device)this.device;
        }
        throw new SeeTecException(-20002, "Device class does not match for " + this);
    }

    @Override
    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        return new Panasonic2TriggerHandler(this);
    }

    protected static boolean isTimeDisplaySet(String data, boolean useDateTime, int channel) {
        if (data == null || data.isEmpty()) {
            return false;
        }
        return useDateTime && !data.toLowerCase().contains("timedisp,\"off\"") && !data.toLowerCase().contains("timeonoffdisp_ch" + channel + ",\"0\"") || !useDateTime && (data.toLowerCase().contains("timedisp,\"off\"") || data.toLowerCase().contains("timeonoffdisp_ch" + channel + ",\"0\""));
    }

    protected static boolean isImageRotationSet(String data, int rotation, int channel) {
        String videoSourceNumber;
        if (data == null) {
            return false;
        }
        String string = videoSourceNumber = channel == 1 ? "" : "_ch" + channel;
        if (data.toLowerCase().contains("image_rotation")) {
            switch (rotation) {
                case 0: {
                    return data.toLowerCase().contains("upsidedown" + videoSourceNumber + ",\"0\"") && data.toLowerCase().contains("image_rotation" + videoSourceNumber + ",\"0\"");
                }
                case 90: {
                    return data.toLowerCase().contains("upsidedown" + videoSourceNumber + ",\"2\"") && data.toLowerCase().contains("image_rotation" + videoSourceNumber + ",\"90\"");
                }
                case 180: {
                    return data.toLowerCase().contains("upsidedown" + videoSourceNumber + ",\"1\"") && data.toLowerCase().contains("image_rotation" + videoSourceNumber + ",\"180\"");
                }
                case 270: {
                    return data.toLowerCase().contains("upsidedown" + videoSourceNumber + ",\"3\"") && data.toLowerCase().contains("image_rotation" + videoSourceNumber + ",\"270\"");
                }
            }
            return false;
        }
        switch (rotation) {
            case 0: {
                return data.toLowerCase().contains("upsidedown" + videoSourceNumber + ",\"0\"");
            }
            case 180: {
                return data.toLowerCase().contains("upsidedown" + videoSourceNumber + ",\"1\"");
            }
        }
        return false;
    }

    protected static boolean isTitleSet(String data, boolean useTitle, String title, int channel) {
        String videoSourceNumber;
        String videoSourceNumberAndCh = channel == 1 ? "" : "_ch" + channel;
        String string = videoSourceNumber = channel == 1 ? "" : "" + channel;
        if (data == null) {
            return false;
        }
        if (useTitle) {
            if (title == null) {
                return false;
            }
            return data.toLowerCase().contains("osdnamedisp" + videoSourceNumberAndCh + ",\"1\"") && data.toLowerCase().contains("osd" + videoSourceNumber + "name,\"" + title.toLowerCase() + "\"");
        }
        return data.toLowerCase().contains("osdnamedisp" + videoSourceNumberAndCh + ",\"0\"");
    }
}

