/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic2;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.CameraPreset;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.axis.utils.Query;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicHelper;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2ControlQuery;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Device;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Helper;
import de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2Query;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class Panasonic2CameraControl
extends CameraControl {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic2.Panasonic2CameraControl";
    private Panasonic2Device panasonic2Device;
    private int numberOfPresets;

    public Logger getLogger() {
        return this.logger;
    }

    public VideoSrv getVideoSrv() {
        return this.videoSrv;
    }

    public int getPreviousPanSpeed() {
        return this.previousPanSpeed;
    }

    public void setPreviousPanSpeed(int previousPanSpeed) {
        this.previousPanSpeed = previousPanSpeed;
    }

    public int getPreviousTiltSpeed() {
        return this.previousTiltSpeed;
    }

    public void setPreviousTiltSpeed(int previousTiltSpeed) {
        this.previousTiltSpeed = previousTiltSpeed;
    }

    public int getPreviousZoomSpeed() {
        return this.previousZoomSpeed;
    }

    public void setPreviousZoomSpeed(int previousZoomSpeed) {
        this.previousZoomSpeed = previousZoomSpeed;
    }

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        int errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        if (errorCode != 0) {
            return errorCode;
        }
        try {
            String capabilities = this.getPanasonic2Device().getHttpHandler().readGetRequest("/cgi-bin/get_capability");
            if (capabilities.contains("video_server.cam_ctrl.preset.number")) {
                this.numberOfPresets = Panasonic2Helper.getFirstValueAsInt(capabilities, "video_server.cam_ctrl.preset.number");
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while reading number of Presets for " + this + " : " + ex.getMessage());
        }
        VideoCameraDefinition config = this.getVideoSrv().getDevice().getVideoCameraDefinitionFromConfiguration();
        if (config != null) {
            this.ptzInfo = new PtzInfo();
            this.ptzInfo.setMinZoom(config.getFeatures().getMinAbsoluteZoom());
            this.ptzInfo.setMaxZoom(config.getFeatures().getMaxAbsoluteZoom());
            this.refreshAbsolutePosition(true);
        }
        return 0;
    }

    private void refreshAbsolutePosition(boolean sendStatus) {
        if (this.panasonic2Device == null) {
            return;
        }
        VideoCameraDefinition config = this.panasonic2Device.getVideoCameraDefinitionFromConfiguration();
        if (config == null || !config.getFeatures().isCanAbsoluteZoom()) {
            return;
        }
        try {
            String[] currentPositionArray;
            String currentPosition = this.panasonic2Device.getHttpHandler().readGetRequest(Panasonic2Query.getControlPtz().getPosition());
            for (String item : currentPositionArray = currentPosition.split("[\\r\\n]+")) {
                String key;
                if ((item = item.trim().toUpperCase().replace("&NBSP", "")).startsWith(key = "PAN=")) {
                    int pan = Integer.parseInt(item.substring(key.length()));
                    this.ptzInfo.setPan(pan);
                    continue;
                }
                key = "TILT=";
                if (item.startsWith(key)) {
                    int tilt = Integer.parseInt(item.substring(key.length()));
                    this.ptzInfo.setTilt(tilt);
                    continue;
                }
                key = "ZOOM=";
                if (!item.startsWith(key)) continue;
                int zoom = Integer.parseInt(item.substring(key.length()));
                this.ptzInfo.setZoom(zoom);
            }
            if (sendStatus) {
                this.videoSrv.sendStatusAbsolutePTZ(null, this.ptzInfo.getPan(), this.ptzInfo.getTilt(), this.ptzInfo.getZoom());
            }
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
        }
    }

    public int sendCameraCommand(String cmd, String url) {
        int errorCode = 0;
        try {
            String completeURL = "/cgi-bin/" + cmd + "?" + url;
            completeURL = completeURL.replace("?&", "?");
            this.getVideoSrv().notifyForCameraControl();
            this.getPanasonic2Device().getHttpHandler().readGetRequest(completeURL);
        }
        catch (SeeTecException ex) {
            this.getLogger().error((Object)ex, (Throwable)ex);
            errorCode = ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
            errorCode = -21600;
        }
        return errorCode;
    }

    public int sendCameraCommand(Query query) {
        int errorCode = 0;
        try {
            this.getVideoSrv().notifyForCameraControl();
            this.getPanasonic2Device().getHttpHandler().readGetRequest(query.toString());
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
            errorCode = -21600;
        }
        return errorCode;
    }

    @Override
    public final int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        Panasonic2ControlQuery query = Panasonic2Query.getControlPtz().zoom(zoom);
        int errorCode = this.sendCameraCommand(query);
        this.refreshAbsolutePosition(false);
        this.ptzInfo.setZoom(zoom);
        return errorCode;
    }

    @Override
    public final int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        String url = this.getContinuousPTZURL(panSpeed, tiltSpeed, zoomSpeed);
        if (url.isEmpty()) {
            return 0;
        }
        return this.sendCameraCommand("directctrl", url);
    }

    public final String getContinuousPTZURL(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        int STEP_SIZE = 390;
        int MAX = 256;
        int MIN = -256;
        int suggestedMIN = 80;
        if (panSpeed != null) {
            pan = panSpeed != 0 ? (panSpeed + STEP_SIZE * (panSpeed / Math.abs(panSpeed))) / STEP_SIZE : 0;
            pan = pan > MAX ? MAX : pan;
            int n = pan = pan < MIN ? MIN : pan;
            if (pan != 0 && (pan > 7 || pan < -15)) {
                pan = Math.abs(pan) < suggestedMIN ? (pan < 0 ? -suggestedMIN : suggestedMIN) : pan;
            }
            this.setPreviousPanSpeed(pan);
        } else {
            pan = this.getPreviousPanSpeed();
        }
        if (tiltSpeed != null) {
            tilt = tiltSpeed != 0 ? (tiltSpeed + STEP_SIZE * (tiltSpeed / Math.abs(tiltSpeed))) / -STEP_SIZE : 0;
            tilt = tilt > MAX ? MAX : tilt;
            int n = tilt = tilt < MIN ? MIN : tilt;
            if (tilt != 0 && (tilt > 4 || tilt < -15)) {
                tilt = Math.abs(tilt) < suggestedMIN ? (tilt < 0 ? -suggestedMIN : suggestedMIN) : tilt;
            }
            this.setPreviousTiltSpeed(tilt);
        } else {
            tilt = this.getPreviousTiltSpeed();
        }
        if (zoomSpeed != null) {
            zoom = zoomSpeed / 25000;
            if (zoomSpeed > 5000 && zoom == 0) {
                zoom = 1;
            }
            this.setPreviousZoomSpeed(zoom);
        } else {
            zoom = this.getPreviousZoomSpeed();
        }
        StringBuilder sb = new StringBuilder(256);
        try {
            if (panSpeed != null || tiltSpeed != null || zoomSpeed != null) {
                sb.append("&rpan=");
                sb.append(pan);
                sb.append("&rtilt=");
                sb.append(tilt);
                sb.append("&rzoom=");
                sb.append(zoom);
            }
            return sb.toString();
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
            return "";
        }
    }

    @Override
    public final int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            PanasonicHelper.CameraPosition camPos = Panasonic2CameraControl.calculateZoomAreaPoints(xPosition, yPosition, 0, 0, resolution);
            return this.sendCameraCommand("camctrl", "center_x=" + camPos.getAbsoluteStartX() + "&center_y=" + camPos.getAbsoluteStartY() + "&resolution=" + camPos.getResolution());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    public static PanasonicHelper.CameraPosition calculateZoomAreaPoints(Integer xPosition, Integer yPosition, Integer width, Integer heigth, int[] resolutionForZoomArea) {
        PanasonicHelper.CameraPosition camPos = new PanasonicHelper.CameraPosition(0, 0, 0, 0, 0);
        if (resolutionForZoomArea != null) {
            int widthZoomArea = resolutionForZoomArea[0];
            int heigthZoomArea = resolutionForZoomArea[1];
            int x = xPosition;
            int y = yPosition;
            x = x <= 0 ? 1 : x;
            y = y <= 0 ? 1 : y;
            camPos.setAbsoluteStartX(widthZoomArea * x / 100);
            camPos.setAbsoluteStartY(heigthZoomArea * y / 100);
            camPos.setAbsoluteEndX(0);
            camPos.setAbsoluteEndY(0);
            camPos.setResolution(widthZoomArea);
        }
        return camPos;
    }

    public Panasonic2Device getPanasonic2Device() {
        return this.panasonic2Device;
    }

    void setPanasonic2Device(Panasonic2Device panasonic2Device) {
        this.panasonic2Device = panasonic2Device;
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolutionForZoomArea) {
        try {
            PanasonicHelper.CameraPosition camPos = PanasonicHelper.calculateZoomAreaPoints(xPosition, yPosition, width, height, resolutionForZoomArea);
            return this.sendCameraCommand("camctrl", "sposition_x=" + camPos.getAbsoluteStartX() + "&sposition_y=" + camPos.getAbsoluteStartY() + "&eposition_x=" + camPos.getAbsoluteEndX() + "&eposition_y=" + camPos.getAbsoluteEndY() + "&resolution=" + camPos.getResolution());
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while setting zoom area for: " + this, (Throwable)ex);
            return -20001;
        }
    }

    @Override
    public final int setAbsoluteIris(Integer value) {
        return -21611;
    }

    @Override
    public final int setContinuousIris(Integer irisSpeed) {
        try {
            if (irisSpeed == null) {
                return 0;
            }
            if (irisSpeed > 0) {
                return this.sendCameraCommand("camctrl", "&iris=2");
            }
            if (irisSpeed < 0) {
                return this.sendCameraCommand("camctrl", "&iris=-2");
            }
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
            return -21600;
        }
        return 0;
    }

    @Override
    public final int setAutoIris(Boolean active) {
        try {
            if (active.booleanValue()) {
                return this.sendCameraCommand("camctrl", "&iris=0");
            }
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
            return -21600;
        }
        return 0;
    }

    @Override
    public final int setAbsoluteFocus(Integer value) {
        return -21611;
    }

    @Override
    public final int setContinuousFocus(Integer focusSpeed) {
        try {
            if (focusSpeed == null) {
                return 0;
            }
            if (focusSpeed > 0) {
                return this.sendCameraCommand("directctrl", "&focus=-1");
            }
            if (focusSpeed < 0) {
                return this.sendCameraCommand("directctrl", "&focus=1");
            }
            return this.sendCameraCommand("directctrl", "&focus=0");
        }
        catch (Throwable ex) {
            this.getLogger().error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active == null) {
            this.getLogger().error("Argument for setting Auto Focus is null for " + this);
            return -21600;
        }
        return this.sendCameraCommand("camctrl", "&af=" + (active != false ? "on" : "off"));
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (active == null) {
            this.getLogger().error("Argument for setting Zero Lux is null for " + this);
            return -21600;
        }
        return this.sendCameraCommand("image_adjust", "&black_white=" + (active != false ? "on" : "off"));
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        if (active == null) {
            this.getLogger().error("Argument for setting Auto Zero Lux is null for " + this);
            return -21600;
        }
        if (active.booleanValue()) {
            return this.sendCameraCommand("image_adjust", "&black_white=auto1");
        }
        return 0;
    }

    @Override
    public final int setHomePosition() {
        return 0;
    }

    @Override
    public final int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            boolean[] bitVector = new boolean[this.numberOfPresets + 1];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                try {
                    int presetPos = Integer.parseInt(presetCnf.getPresetPosition());
                    bitVector[presetPos] = true;
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Could not parse " + presetCnf.getPresetPosition() + " to number");
                }
            }
            for (i = 1; i <= this.numberOfPresets; ++i) {
                if (bitVector[i]) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.getLogger().error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            String encodedPresetName = Panasonic2CameraControl.encodeAndLimitPresetName(16, presetName);
            ArrayOfCameraPreset arrayOfCameraPreset = this.getPresetsFromCamera();
            List<CameraPreset> listOfCameraPresets = arrayOfCameraPreset.getCameraPreset();
            for (CameraPreset cameraPreset : listOfCameraPresets) {
                if (!cameraPreset.getName().equals(encodedPresetName)) continue;
                this.logger.warn("Could not set preset " + encodedPresetName + " on camera. Preset already exists for " + this);
                return -21683;
            }
            this.sendCameraCommand("set_preposi", "&UID=0&preno=" + presetPosition + "&preposiid=" + encodedPresetName);
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, Integer.toString(presetPosition), presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (ConfigurationException | UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public final int setPresetPosition(String presetName) {
        int errorCode = 0;
        try {
            String encodedPresetName = Panasonic2CameraControl.encodeAndLimitPresetName(16, presetName);
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                String presetCnfName = Panasonic2CameraControl.encodeAndLimitPresetName(16, presetCnf.getPresetName());
                if (!encodedPresetName.toLowerCase().equals(presetCnfName.toLowerCase()) && !presetName.toLowerCase().equals(presetCnf.getPresetName())) continue;
                return this.sendCameraCommand("camctrl", "&UID=0&PRESET=" + presetCnf.getPresetPosition());
            }
        }
        catch (ConfigurationException | UnsupportedEncodingException ex) {
            this.getLogger().error((Object)ex, ex);
            this.getLogger().error("Setting preset [" + presetName + "] failed");
            errorCode = -21600;
        }
        if (errorCode != -21600) {
            this.getLogger().error("Preset [" + presetName + "] not availabl");
            this.getLogger().error("PresetList=" + this.presetList);
            errorCode = -21683;
        }
        return errorCode;
    }

    @Override
    public final int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = Panasonic2CameraControl.encodeAndLimitPresetName(16, presetName);
            ArrayOfCameraPreset arrayOfCameraPreset = this.getPresetsFromCamera();
            List<CameraPreset> cameraPresetList = arrayOfCameraPreset.getCameraPreset();
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                String presetCnfName = Panasonic2CameraControl.encodeAndLimitPresetName(16, presetCnf.getPresetName());
                if (!encodedPresetName.equals(presetCnfName) && !presetName.equals(presetCnf.getPresetName())) continue;
                for (CameraPreset cameraPreset : cameraPresetList) {
                    if (!cameraPreset.getName().equals(presetName) && !cameraPreset.getName().equals(encodedPresetName)) continue;
                    this.presetList.removeElementAt(i);
                    String presetPosition = Panasonic2CameraControl.readPresetPositionFromCameraPreset(cameraPreset);
                    this.getLogger().info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                    return this.sendCameraCommand("camposiset", "&UID=0&presetdel=" + presetPosition);
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error((Object)ex, (Throwable)ex);
            this.getLogger().error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.getLogger().error("Preset [" + presetName + "] not available");
        this.getLogger().error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        if (presets == null) {
            this.logger.warn("Received null camera presets object in addCameraPresets!");
            return -20002;
        }
        List<CameraPreset> cameraPresets = presets.getCameraPreset();
        for (CameraPreset cameraPreset : cameraPresets) {
            try {
                Element ptzPosition;
                byte[] cameraPresetPtzData = cameraPreset.getPtzData().getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(cameraPresetPtzData);
                Document ptzDocument = new SAXBuilder().build((InputStream)bais);
                String presetPosition = "1";
                Element root = ptzDocument.getRootElement();
                if (root != null && (ptzPosition = root.getChild("PresetPosition")) != null) {
                    presetPosition = ptzPosition.getText().trim();
                }
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, cameraPreset.getName());
                this.presetList.addElement(presetCnf);
                this.logger.info("Adding preset configuration: " + presetCnf);
            }
            catch (JDOMException ex) {
                this.logger.warn("Exception while parsing XML data: " + ex.getMessage());
            }
        }
        return 0;
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        try {
            String url = "/cgi-bin/get_preposi?command=list";
            String presetsAll = this.getPanasonic2Device().getHttpHandler().readGetRequest(url);
            String[] presetsAllLines = presetsAll.split("\r\n");
            ArrayOfCameraPreset arrayOfCameraPreset = new ArrayOfCameraPreset();
            for (String presetLine : presetsAllLines) {
                String[] presetLineParts;
                String trimmedPresetLine = presetLine.trim();
                if (!trimmedPresetLine.toLowerCase().startsWith("posi") || (presetLineParts = trimmedPresetLine.split("=")).length != 2) continue;
                String presetName = presetLineParts[1].toUpperCase();
                String presetPosition = presetLineParts[0].replace("POSI", "").replace("_ID", "");
                CameraPreset cameraPreset = new CameraPreset();
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, presetName);
                cameraPreset.setName(presetName);
                cameraPreset.setPtzData(new String(presetCnf.getPresetCnf(), "UTF-8"));
                arrayOfCameraPreset.getCameraPreset().add(cameraPreset);
            }
            return arrayOfCameraPreset;
        }
        catch (Exception ex) {
            this.logger.error(ex + " for " + this, (Throwable)ex);
            return new ArrayOfCameraPreset();
        }
    }

    public static String encodeAndLimitPresetName(int numberOfDigits, String presetName) throws UnsupportedEncodingException {
        String encodedPresetName = "";
        if (presetName != null && !presetName.isEmpty() && (encodedPresetName = presetName.toUpperCase().replaceAll("[^A-Z0-9]", "")).length() > numberOfDigits) {
            encodedPresetName = encodedPresetName.substring(0, numberOfDigits);
        }
        return encodedPresetName;
    }

    private static String readPresetPositionFromCameraPreset(CameraPreset cameraPreset) throws JDOMException {
        Element ptzPosition;
        byte[] cameraPresetPtzData = cameraPreset.getPtzData().getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(cameraPresetPtzData);
        Document ptzDocument = new SAXBuilder().build((InputStream)bais);
        String presetPosition = "1";
        Element root = ptzDocument.getRootElement();
        if (root != null && (ptzPosition = root.getChild("PresetPosition")) != null) {
            presetPosition = ptzPosition.getText().trim();
        }
        return presetPosition;
    }
}

