/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.mpeg;

import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.AudioSetReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.GetUIDReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.KeepAliveReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.MPEGSetReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.Packet;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.StartReq;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.http.StopReq;
import de.seetec.v5.shared.SSLConstantsIntf;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPHandler
implements SSLConstantsIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.mpeg.HTTPHandler";
    private static final String CONTENT_LENGTH = "Content-Length:";
    private final Logger logger = LogManager.getLogger((String)"de.seetec.v5.re.cm.device.video.panasonic.mpeg.HTTPHandler");
    private boolean shutdown = false;
    private OutputStream outStream = null;
    private InputStream inStream = null;
    private Socket socket = null;

    public int init(String host, int port) {
        if (host == null || port < 0 || port > 65536) {
            return -21601;
        }
        try {
            this.socket = new Socket(host, port);
            this.socket.setKeepAlive(false);
            this.socket.setSoTimeout(5000);
        }
        catch (Exception e) {
            this.logger.error("Cannot connect to " + host + ":80", (Throwable)e);
            return -21656;
        }
        try {
            this.inStream = this.socket.getInputStream();
            this.outStream = this.socket.getOutputStream();
        }
        catch (Exception e) {
            this.logger.error("Cannot get streams from socket", (Throwable)e);
            return -21656;
        }
        return 0;
    }

    public void shutdown() {
        block7: {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            try {
                if (this.inStream != null) {
                    this.inStream.close();
                }
                if (this.outStream != null) {
                    this.outStream.close();
                }
                if (this.socket == null) break block7;
                try {
                    this.socket.close();
                }
                catch (Exception e) {
                    this.logger.error("Cannot close socket", (Throwable)e);
                }
                this.socket = null;
            }
            catch (Exception e) {
                this.logger.error("Exception closing stream", (Throwable)e);
            }
        }
    }

    public Packet send(Packet p) {
        byte[] data = p.serialize();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        int len = 0;
        int contentLength = -1;
        int startPos = -1;
        int startOfContent = -1;
        long bytesOfContentRead = 0L;
        if (this.shutdown) {
            return null;
        }
        try {
            Packet packet;
            this.outStream.write(data);
            this.outStream.flush();
            while ((len = this.inStream.read(buffer, 0, buffer.length)) > 0) {
                if (len <= 0) continue;
                baos.write(buffer, 0, len);
                String tmp = new String(buffer);
                if (tmp.contains(CONTENT_LENGTH)) {
                    startPos = tmp.indexOf(CONTENT_LENGTH) + CONTENT_LENGTH.length();
                    startOfContent = tmp.indexOf("\r\n\r\n") + "\r\n".length() + "\r\n".length();
                    bytesOfContentRead = len - startOfContent;
                    try {
                        contentLength = Integer.parseInt(tmp.substring(startPos, tmp.indexOf("\r\n", startPos)).trim());
                    }
                    catch (NumberFormatException nfe) {
                        this.logger.error("Can't convert content-length into number: " + nfe.getMessage(), (Throwable)nfe);
                    }
                } else {
                    long l = bytesOfContentRead = startPos != -1 ? bytesOfContentRead + (long)len : bytesOfContentRead;
                }
                if ((startPos == -1 || bytesOfContentRead < (long)contentLength) && !baos.toString().endsWith("\r\n\r\n")) continue;
                break;
            }
            if ((packet = p.deserialize(baos.toByteArray())) instanceof GetUIDReq) {
                GetUIDReq responsePacket = (GetUIDReq)packet;
                return responsePacket;
            }
            if (packet instanceof StartReq) {
                StartReq responsePacket = (StartReq)packet;
                return responsePacket;
            }
            if (packet instanceof KeepAliveReq) {
                KeepAliveReq responsePacket = (KeepAliveReq)packet;
                return responsePacket;
            }
            if (packet instanceof StopReq) {
                StopReq responsePacket = (StopReq)packet;
                return responsePacket;
            }
            if (packet instanceof MPEGSetReq) {
                MPEGSetReq responsePacket = (MPEGSetReq)packet;
                return responsePacket;
            }
            if (packet instanceof AudioSetReq) {
                AudioSetReq responsePacket = (AudioSetReq)packet;
                return responsePacket;
            }
            return null;
        }
        catch (SocketTimeoutException ste) {
            this.logger.warn("SOTimeout reached. Aborting RTSPHandler.");
            return null;
        }
        catch (Exception e) {
            if (this.shutdown) {
                return null;
            }
            this.logger.error("Exception writing to network", (Throwable)e);
            return null;
        }
    }
}

