/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic.jpeg;

import de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class PanasonicVideoSourceClient_NW474
extends PanasonicVideoSourceClient {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient_NW474";

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            long fps = (this.highestFramerate + 999L) / 1000L;
            String url = "/cgi-bin/push?CH=1&UID=" + this.createUID() + "&MODE=START&FRAMERATE=" + fps + "&PAGE=" + System.currentTimeMillis();
            this.handleServerPush(url, false);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private Long createUID() {
        Socket socket = null;
        Long uid = 0L;
        try {
            String key;
            String url = "/cgi-bin/getuid?PAGE=" + System.currentTimeMillis() + "&FILE=uid.html";
            socket = super.establishStream(url);
            if (socket == null) {
                this.logger.error("Cannot establish stream to [" + this.host + ":" + this.port + "] with url [" + url + "] :-(");
                return 0L;
            }
            String result = new String(this.readURL(socket, url));
            int position = result.indexOf(key = "UID=");
            if (position > 0) {
                char c;
                StringBuilder sb = new StringBuilder();
                position += key.length();
                while ((c = result.charAt(position)) >= '0' && c <= '9') {
                    sb.append(c);
                    ++position;
                }
                uid = Long.valueOf(sb.toString());
            } else {
                this.logger.warn("Cannot find UID in [" + result + "]");
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        this.logger.info("UID=[" + uid + "]");
        return uid;
    }

    private byte[] readURL(Socket socket, String url) throws IOException {
        byte[] result;
        String authorization = null;
        this.logger.info("[" + Basic.longToFormattedString((long)System.currentTimeMillis()) + "]: Reading URL=[" + url + "] for " + this + " ...");
        try {
            authorization = NetworkHelper.createBasicAuthorization((NetworkParameter)this.networkParameter);
        }
        catch (Exception ex) {
            this.logger.error("Exception while creating Basic Authorization for " + this + ": " + ex.getMessage());
        }
        authorization = authorization == null ? "" : authorization;
        String request = "GET " + url + " HTTP/1.1\r\n" + authorization + "User-Agent: Java/1.4.2\r\nHost: " + this.host + "\r\nAccept: text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2\r\nConnection: keep-alive\r\n\r\n";
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Request=[\r\n" + request + "]");
        }
        try (OutputStream os = socket.getOutputStream();){
            os.write(request.getBytes());
            os.flush();
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(buffer.length);
            try (InputStream is = socket.getInputStream();){
                int len;
                while ((len = is.read(buffer)) > 0) {
                    baos.write(buffer, 0, len);
                }
                result = baos.toByteArray();
            }
        }
        socket.close();
        return result;
    }
}

