/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.shared.net.NetworkParameter;
import org.apache.logging.log4j.LogManager;

public class PanasonicMotionDetectionHandler
extends MotionDetectionHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.PanasonicMotionDetectionHandler";
    private HttpServerPushHandler httpServerPushHandler = null;
    private NetworkParameter networkParameter = null;

    public PanasonicMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        int errorCode;
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        String url = "/cgi-bin/get_io?mode=monitor";
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.networkParameter.setSoTimeout(20000);
            this.httpServerPushHandler = new HttpServerPushHandler();
            errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
            } else {
                errorCode = this.httpServerPushHandler.startServerPush(true);
            }
        }
        catch (Exception e) {
            this.logger.error("Reading configuration from " + this.listener.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
            errorCode = -21601;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
        }
        return errorCode;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
            this.httpServerPushHandler = null;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.isShutdown(CLASS_NAME)) {
            return;
        }
        if (statusCode != 0) {
            this.listener.notifyForNetworkProblems();
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21650);
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] content = httpServerPushContent.getContentBody();
        if (content != null) {
            String[] windows;
            for (String window : windows = new String(content).split("\r\n")) {
                if (!window.toLowerCase().contains("motiondetect") || !window.toLowerCase().contains("true") || this.listener == null) continue;
                this.listener.evaluateWindow(0);
            }
        }
    }
}

