/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicIOHandler;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.shared.EntityType;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class PanasonicIOHandler_Default
extends PanasonicIOHandler
implements EntityType {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.PanasonicIOHandler_Default";
    private String terminalPart = "";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        if (this.device.getDeviceType() == 200528L) {
            this.terminalPart = "&almtrmno=2";
        } else if (this.device.getDeviceType() == 200531L) {
            this.terminalPart = "&almtrmno=3";
        } else if (this.device.getDeviceType() == 200534L || this.device.getDeviceType() == 200535L || this.device.getDeviceType() == 200532L || this.device.getDeviceType() == 200533L || this.device.getDeviceType() == 200536L || this.device.getDeviceType() == 200545L || this.device.getDeviceType() == 200548L || this.device.getDeviceType() == 200546L) {
            try {
                if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/jpeg_alarm?trm_alarm=1", (int)Integer.MAX_VALUE) == null) {
                    this.logger.error("Error enabling Alarm Input for " + this);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception occured while enabling Alarm Input for " + this + ": " + ex.getMessage());
            }
        }
        try {
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                this.checkDigitalInputs();
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private void checkDigitalInputs() throws SeeTecException {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Reading digital inputs of " + this);
        }
        String digitalInput = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/get_io?command=all", (int)65536, (boolean)false));
        if (this.logger.isDebugEnabled()) {
            this.logger.info("DigitalInput [" + digitalInput + "] for " + this);
        }
        for (DigitalInputSrv iService : iServices) {
            String value;
            int inputNumber = iService.getInputNumber();
            String key = "terminal " + inputNumber + ": ";
            int index = digitalInput.indexOf(key);
            if (index < 0) continue;
            iService.checkInput("H".equals(value = digitalInput.substring(index += key.length(), index + 1)) ? 0 : 1);
        }
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber);
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            String[] stringArray;
            if (this.authorization) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = this.usr;
                stringArray = stringArray2;
                stringArray2[1] = this.pwd;
            } else {
                stringArray = null;
            }
            String[] userPWD = stringArray;
            String url = value != 0 ? "/cgi-bin/pioctrl?almtrm=nc" + this.terminalPart : "/cgi-bin/pioctrl?almtrm=no" + this.terminalPart;
            String resolvedHost = new LteHostResolver(this.getCore().getLTESupportConfiguration()).resolve(this.host);
            NetworkHelper.readGetRequest((String)resolvedHost, (int)this.port, (String[])userPWD, (String)url);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            this.logger.warn("Problems setting output [" + outputNumber + "] of " + this + " :-(");
        }
        return 0;
    }
}

