/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

public class PanasonicHelper {
    public static CameraPosition calculateZoomAreaPoints(Integer xPosition, Integer yPosition, Integer width, Integer heigth, int[] resolutionForZoomArea) {
        CameraPosition camPos = new CameraPosition(0, 0, 0, 0, 0);
        if (resolutionForZoomArea != null) {
            int widthFromZoomArea = resolutionForZoomArea[0];
            int heigthFromZoomArea = resolutionForZoomArea[1];
            camPos.absoluteStartX = widthFromZoomArea * xPosition / 100;
            camPos.absoluteStartY = heigthFromZoomArea * yPosition / 100;
            camPos.absoluteEndX = camPos.absoluteStartX + widthFromZoomArea * width / 100;
            camPos.absoluteEndY = camPos.absoluteStartY + heigthFromZoomArea * heigth / 100;
            if (camPos.absoluteStartX > 0) {
                camPos.absoluteStartX--;
            }
            if (camPos.absoluteStartY > 0) {
                camPos.absoluteStartY--;
            }
            camPos.resolution = widthFromZoomArea;
        }
        return camPos;
    }

    public static class CameraPosition {
        private int absoluteStartX;
        private int absoluteStartY;
        private int absoluteEndX;
        private int absoluteEndY;
        private int resolution;

        public CameraPosition() {
        }

        public CameraPosition(int absoluteStartX, int absoluteStartY, int absoluteEndX, int absoluteEndY, int resolution) {
            this.absoluteStartX = absoluteStartX;
            this.absoluteStartY = absoluteStartY;
            this.absoluteEndX = absoluteEndX;
            this.absoluteEndY = absoluteEndY;
            this.resolution = resolution;
        }

        public int getAbsoluteStartX() {
            return this.absoluteStartX;
        }

        public void setAbsoluteStartX(int absoluteStartX) {
            this.absoluteStartX = absoluteStartX;
        }

        public int getAbsoluteStartY() {
            return this.absoluteStartY;
        }

        public void setAbsoluteStartY(int absoluteStartY) {
            this.absoluteStartY = absoluteStartY;
        }

        public int getAbsoluteEndX() {
            return this.absoluteEndX;
        }

        public void setAbsoluteEndX(int absoluteEndX) {
            this.absoluteEndX = absoluteEndX;
        }

        public int getAbsoluteEndY() {
            return this.absoluteEndY;
        }

        public void setAbsoluteEndY(int absoluteEndY) {
            this.absoluteEndY = absoluteEndY;
        }

        public int getResolution() {
            return this.resolution;
        }

        public void setResolution(int resolution) {
            this.resolution = resolution;
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + this.absoluteStartX;
            hash = 29 * hash + this.absoluteStartY;
            hash = 29 * hash + this.absoluteEndX;
            hash = 29 * hash + this.absoluteEndY;
            hash = 29 * hash + this.resolution;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CameraPosition other = (CameraPosition)obj;
            if (this.absoluteStartX != other.absoluteStartX) {
                return false;
            }
            if (this.absoluteStartY != other.absoluteStartY) {
                return false;
            }
            if (this.absoluteEndX != other.absoluteEndX) {
                return false;
            }
            if (this.absoluteEndY != other.absoluteEndY) {
                return false;
            }
            return this.resolution == other.resolution;
        }
    }
}

