/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicCameraControl_Bx;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicCameraControl_Hx;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicCameraControl_NS202;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicCameraControl_Nx;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicCameraControl_direct;
import de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient_Hx;
import de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient_NP1000;
import de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient_NW474;
import de.seetec.v5.re.cm.device.video.panasonic.jpeg.PanasonicVideoSourceClient_Nx;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicH264VideoSourceClient;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicH264VideoSourceClientRTP;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicH264VideoSourceClient_BB;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicMPEGVideoSourceClient_Hx;
import de.seetec.v5.re.cm.device.video.panasonic.mpeg.PanasonicMPEGVideoSourceClient_Nx;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class PanasonicCameraSrv
extends LiveCameraSrv {
    private boolean streamHandlingDone;
    private int numberOfH264Streams;

    @Override
    public CameraControl createCameraControl(Long entityType) {
        if (this.usesPanasonicCameraControl_Nx(entityType)) {
            return new PanasonicCameraControl_Nx();
        }
        if (this.usesPanasonicCameraControl_direct(entityType)) {
            return new PanasonicCameraControl_direct();
        }
        if (this.usesPanasonicCameraControl_NS202(entityType)) {
            return new PanasonicCameraControl_NS202();
        }
        if (this.usesPanasonicCameraControl_Bx(entityType)) {
            return new PanasonicCameraControl_Bx();
        }
        if (this.usesPanasonicCameraControl_Hx(entityType)) {
            return new PanasonicCameraControl_Hx();
        }
        this.logger.error("Unknown entity type [" + entityType + "]");
        return null;
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        VideoSourceClient videoSourceClient = null;
        try {
            int errorCode;
            long entityType = super.getEntityType();
            if ((entityType == 210642L || entityType == 210646L) && (errorCode = this.handleStreams()) != 0) {
                this.logger.error("Error while handling stream parameters for " + this);
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
            if (listener.getVideoSourceParameter().getMediaCodec() == Codec.MPEG4) {
                if (this.usesPanasonicMPEGVideoSourceClient_Hx(entityType)) {
                    videoSourceClient = new PanasonicMPEGVideoSourceClient_Hx();
                } else if (this.usesPanasonicMPEGVideoSourceClient_Nx(entityType)) {
                    videoSourceClient = new PanasonicMPEGVideoSourceClient_Nx();
                }
            } else if (listener.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                videoSourceClient = this.usesPanasonicH264VideoSourceClient_BB(entityType) ? new PanasonicH264VideoSourceClient_BB() : (this.usesPanasonicH264VideoSourceClientRTP(entityType) ? new PanasonicH264VideoSourceClientRTP() : new PanasonicH264VideoSourceClient());
            } else if (this.usesPanasonicVideoSourceClient_NW474(entityType)) {
                videoSourceClient = new PanasonicVideoSourceClient_NW474();
            } else if (this.usesPanasonicVideoSourceClient_Nx(entityType)) {
                videoSourceClient = new PanasonicVideoSourceClient_Nx();
            } else if (this.usesPanasonicVideoSourceClient_NP1000(entityType)) {
                videoSourceClient = new PanasonicVideoSourceClient_NP1000();
            } else if (this.usesPanasonicVideoSourceClient_Hx(entityType)) {
                videoSourceClient = new PanasonicVideoSourceClient_Hx();
            }
            if (videoSourceClient == null) {
                this.logger.error("Unknown entity type [" + entityType + "] :-(");
                return null;
            }
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public synchronized int handleStreams() {
        if (this.streamHandlingDone) {
            return 0;
        }
        try {
            long entityType = super.getEntityType();
            if (entityType == 210642L || entityType == 210646L) {
                this.numberOfH264Streams = 0;
                if (this.getBasicVideoProfileHandler().getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                    ++this.numberOfH264Streams;
                }
                if (this.getAdditionalVideoProfileHandler().length > 0) {
                    if (this.getAdditionalVideoProfileHandler()[0].getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                        ++this.numberOfH264Streams;
                    }
                    if (this.getAdditionalVideoProfileHandler().length > 1 && this.getAdditionalVideoProfileHandler()[1].getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                        ++this.numberOfH264Streams;
                    }
                }
                NetworkParameter networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
                switch (this.numberOfH264Streams) {
                    case 0: {
                        String body = "h264_transmit=0";
                        NetworkHelper.readPostRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/set_h264", (String)body, (int)Integer.MIN_VALUE, (boolean)true);
                        NetworkHelper.readPostRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/set_h264_2", (String)body, (int)Integer.MIN_VALUE, (boolean)true);
                        break;
                    }
                    case 1: {
                        String body = "h264_transmit=1";
                        NetworkHelper.readPostRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/set_h264", (String)body, (int)Integer.MIN_VALUE, (boolean)true);
                        body = "h264_transmit=0";
                        NetworkHelper.readPostRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/set_h264_2", (String)body, (int)Integer.MIN_VALUE, (boolean)true);
                        break;
                    }
                    default: {
                        String body = "h264_transmit=1";
                        NetworkHelper.readPostRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/set_h264", (String)body, (int)Integer.MIN_VALUE, (boolean)true);
                        NetworkHelper.readPostRequest((NetworkParameter)networkParameter, (String)"/cgi-bin/set_h264_2", (String)body, (int)Integer.MIN_VALUE, (boolean)true);
                        break;
                    }
                }
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while handling h.264 streams for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while retrieving network parameters for " + this + ": " + ex.getMessage());
        }
        this.streamHandlingDone = true;
        return 0;
    }

    public int getNumberOfH264Streams() {
        return this.numberOfH264Streams;
    }

    protected boolean usesPanasonicCameraControl_Nx(Long entityType) {
        return entityType == 210601L || entityType == 210603L || entityType == 210602L || entityType == 210604L || entityType == 210608L || entityType == 210609L || entityType == 210617L || entityType == 210610L || entityType == 210611L || entityType == 210624L || entityType == 210625L || entityType == 210627L || entityType == 210628L || entityType == 210632L || entityType == 210633L || entityType == 210630L || entityType == 210631L || entityType == 210640L || entityType == 210641L || entityType == 210642L || entityType == 210643L || entityType == 210644L;
    }

    protected boolean usesPanasonicCameraControl_direct(Long entityType) {
        return entityType == 210646L;
    }

    protected boolean usesPanasonicCameraControl_NS202(Long entityType) {
        return entityType == 210616L || entityType == 219900L || entityType == 219901L || entityType == 210623L || entityType == 210634L;
    }

    protected boolean usesPanasonicCameraControl_Bx(Long entityType) {
        return entityType == 210613L || entityType == 210618L;
    }

    protected boolean usesPanasonicCameraControl_Hx(Long entityType) {
        return entityType == 210613L || entityType == 210615L || entityType == 210614L || entityType == 210612L || entityType == 210620L || entityType == 210622L || entityType == 210621L || entityType == 210619L || entityType == 210626L || entityType == 210639L || entityType == 210637L || entityType == 210636L || entityType == 210638L || entityType == 210635L || entityType == 210629L;
    }

    protected boolean usesPanasonicMPEGVideoSourceClient_Hx(Long entityType) {
        return entityType == 210614L || entityType == 210613L || entityType == 210615L || entityType == 210621L || entityType == 210620L || entityType == 210619L || entityType == 210618L || entityType == 210611L || entityType == 210612L || entityType == 210622L || entityType == 210626L || entityType == 210629L || entityType == 210632L || entityType == 210633L || entityType == 210631L || entityType == 210630L || entityType == 210634L || entityType == 210638L || entityType == 210635L || entityType == 210636L || entityType == 210639L || entityType == 210637L;
    }

    protected boolean usesPanasonicMPEGVideoSourceClient_Nx(Long entityType) {
        return entityType == 210601L || entityType == 210602L || entityType == 210603L || entityType == 210604L || entityType == 210608L || entityType == 210609L || entityType == 210610L || entityType == 210616L || entityType == 210617L || entityType == 210623L || entityType == 210624L || entityType == 210625L || entityType == 219900L || entityType == 219901L;
    }

    protected boolean usesPanasonicH264VideoSourceClient_BB(Long entityType) {
        return entityType == 210639L || entityType == 210637L;
    }

    protected boolean usesPanasonicH264VideoSourceClientRTP(Long entityType) {
        return entityType == 210633L || entityType == 210631L || entityType == 210634L || entityType == 210630L || entityType == 210640L || entityType == 210641L || entityType == 210642L || entityType == 210632L || entityType == 210634L || entityType == 210643L || entityType == 210644L || entityType == 210646L;
    }

    protected boolean usesPanasonicVideoSourceClient_NW474(Long entityType) {
        return entityType == 210608L;
    }

    protected boolean usesPanasonicVideoSourceClient_Nx(Long entityType) {
        return entityType == 210601L || entityType == 210603L || entityType == 210604L || entityType == 210602L;
    }

    protected boolean usesPanasonicVideoSourceClient_NP1000(Long entityType) {
        return entityType == 210610L || entityType == 210609L || entityType == 210617L || entityType == 219900L || entityType == 219901L || entityType == 210624L || entityType == 210625L || entityType == 210627L || entityType == 210628L || entityType == 210632L || entityType == 210633L || entityType == 210631L || entityType == 210630L || entityType == 210634L || entityType == 210640L || entityType == 210641L || entityType == 210642L || entityType == 210643L || entityType == 210644L || entityType == 210646L;
    }

    protected boolean usesPanasonicVideoSourceClient_Hx(Long entityType) {
        return entityType == 210611L || entityType == 210612L || entityType == 210613L || entityType == 210615L || entityType == 210614L || entityType == 210618L || entityType == 210620L || entityType == 210619L || entityType == 210626L || entityType == 210622L || entityType == 210629L || entityType == 210638L || entityType == 210635L || entityType == 210636L || entityType == 210639L || entityType == 210637L || entityType == 210616L || entityType == 210623L;
    }
}

