/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicHelper;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;

public class PanasonicCameraControl_Nx
extends CameraControl {
    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return -21611;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int zoom;
        int tilt;
        int pan;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed.intValue();
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed.intValue();
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed.intValue();
        } else {
            zoom = this.previousZoomSpeed;
        }
        StringBuilder sb = new StringBuilder(256);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("PanSpeed=[" + panSpeed + "], TiltSpeed=[" + tiltSpeed + "], ZoomSpeed=[" + zoomSpeed + "]");
        }
        try {
            String url;
            if (panSpeed != null || tiltSpeed != null) {
                sb.append("&PAN=").append(pan / 16000);
                sb.append("&TILT=").append(-tilt / 20000);
            }
            if (zoomSpeed != null) {
                if (zoom != 0) {
                    sb.append(zoom < 0 ? "&ZOOM=-3" : "&ZOOM=3");
                } else {
                    sb.append("&ZOOM=0");
                }
            }
            if ((url = sb.toString()).length() <= 0) {
                return 0;
            }
            return this.sendCameraCommand(url);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            PanasonicHelper.CameraPosition camPos = PanasonicHelper.calculateZoomAreaPoints(xPosition, yPosition, 0, 0, resolution);
            return this.sendCameraCommand("center_x=" + camPos.getAbsoluteStartX() + "&center_y=" + camPos.getAbsoluteStartY() + "&resolution=" + camPos.getResolution());
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        return -21611;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return -21611;
    }

    @Override
    public int setContinuousIris(Integer irisSpeed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info("IrisSpeed=[" + irisSpeed + "]");
        }
        try {
            if (irisSpeed == null || irisSpeed == 0) {
                return 0;
            }
            if (irisSpeed < 0) {
                return this.sendCameraCommand("&IRIS=-2");
            }
            return this.sendCameraCommand("&IRIS=2");
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAutoIris(Boolean active) {
        return -21611;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return -21611;
    }

    @Override
    public int setContinuousFocus(Integer focusSpeed) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info("FocusSpeed=[" + focusSpeed + "]");
        }
        try {
            if (focusSpeed == null || focusSpeed == 0) {
                return 0;
            }
            if (focusSpeed < 0) {
                return this.sendCameraCommand("&FOCUS=-3");
            }
            return this.sendCameraCommand("&FOCUS=3");
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&AF=ON");
        }
        return this.sendCameraCommand("&AF=OFF");
    }

    @Override
    public int setZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf((long)presetID, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.logger.info("super.presetList=" + this.presetList);
            return 0;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        return this.sendCameraCommand("&UID=0&PRESET=" + presetName);
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    private int sendCameraCommand(String url) {
        String completeURL = null;
        try {
            String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            long entityType = this.videoSrv.getEntityType();
            this.videoSrv.notifyForCameraControl();
            if (entityType == 210604L) {
                completeURL = "/cgi-bin/camctrlid?suid=" + seeTecID + url;
            } else if (entityType == 219901L) {
                String sChannel = "&CH=" + this.videoSrv.getVideoSourceCnf().getServerEntryNo();
                completeURL = "/cgi-bin/camctrl?suid=" + seeTecID + sChannel + url;
            } else {
                completeURL = "/cgi-bin/camctrl?suid=" + seeTecID + url;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.info("CameraCommand=[" + completeURL + "]");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL, (int)Integer.MIN_VALUE);
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Sending HTTP request [" + completeURL + "] failed with error [" + ex.getErrorCode() + "]");
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

