/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.panasonic;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.panasonic.PanasonicHelper;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;

public class PanasonicCameraControl_Bx
extends CameraControl {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.panasonic.PanasonicCameraControl_Bx";

    private int sendCameraCommand(String url) {
        try {
            String seeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
            String completeURL = "/set?suid=" + seeTecID + url;
            this.logger.info("CompleteURL=[" + completeURL + "]");
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)completeURL);
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return -21611;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        int errorCode = 0;
        try {
            if (panSpeed != null && panSpeed < 0) {
                this.sendCameraCommand("&Kind=1&Func=Pan&DegMode=4");
            }
            if (panSpeed != null && panSpeed > 0) {
                this.sendCameraCommand("&Kind=1&Func=Pan&DegMode=6");
            }
            if (tiltSpeed != null && tiltSpeed < 0) {
                this.sendCameraCommand("&Kind=1&Func=Tilt&DegMode=2");
            }
            if (tiltSpeed != null && tiltSpeed > 0) {
                this.sendCameraCommand("&Kind=1&Func=Tilt&DegMode=8");
            }
            if (zoomSpeed != null && zoomSpeed < 0) {
                this.sendCameraCommand("&Kind=1&Func=Zoom&ZoomMode=6");
            }
            if (zoomSpeed != null && zoomSpeed > 0) {
                this.sendCameraCommand("&Kind=1&Func=Zoom&ZoomMode=4");
            }
            return errorCode;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            PanasonicHelper.CameraPosition camPos = PanasonicHelper.calculateZoomAreaPoints(xPosition, yPosition, 0, 0, resolution);
            return this.sendCameraCommand("/cgi-bin/camctrl?center_x=" + camPos.getAbsoluteStartX() + "&center_y=" + camPos.getAbsoluteStartY() + "&resolution=" + camPos.getResolution());
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        return -21611;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        return -21611;
    }

    @Override
    public int setContinuousIris(Integer value) {
        return -21611;
    }

    @Override
    public int setAutoIris(Boolean active) {
        return -21611;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        return -21611;
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return -21611;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            return this.sendCameraCommand("&autofocus=on");
        }
        return this.sendCameraCommand("&autofocus=off");
    }

    @Override
    public int setZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return -21611;
    }

    @Override
    public int setHomePosition() {
        return -21611;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf((long)presetID, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.logger.info("super.presetList=" + this.presetList);
            return 0;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getMessage());
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                return this.sendCameraCommand("&Set?Func=PresetName&Kind=" + (i + 1) + "&Data=" + encodedPresetName);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

