/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.sistore;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceIoService;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifDevice;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifEventHandler;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;

public class SistoreOnvifIoHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifIoHandler";
    private DeviceIoService deviceIoService = null;
    private SistoreOnvifEventHandler genericOnvifEventHandler = null;

    @Override
    public final int init(Core core, Device device, Entity[] srvEnities, boolean ignoreSomeParameter, boolean unconditionalStartOfThread) {
        try {
            SistoreOnvifDevice onvifDevice = (SistoreOnvifDevice)device;
            OnvifCore onvifCore = onvifDevice.getOnvifCore();
            this.deviceIoService = onvifCore.getDeviceIoService();
        }
        catch (SeeTecException exception) {
            this.logger.error((Object)exception, (Throwable)exception);
            return exception.getErrorCode();
        }
        int errorCode = super.init(core, device, srvEnities, ignoreSomeParameter, unconditionalStartOfThread);
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        if (iServices.length > 0) {
            SistoreOnvifDevice genericOnvifDevice = (SistoreOnvifDevice)this.device;
            this.genericOnvifEventHandler = genericOnvifDevice.getGenericOnvifEventHandler();
            this.genericOnvifEventHandler.activateInputAlarms(this);
        }
        return errorCode;
    }

    @Override
    public final void run() {
        super.setRunFinished(CLASS_NAME, true);
    }

    @Override
    public final int shutdown() {
        if (this.genericOnvifEventHandler != null) {
            this.genericOnvifEventHandler.deactivateInputAlarms();
            this.genericOnvifEventHandler = null;
        }
        return super.shutdown();
    }

    public final void receiveAlarm(int number, int value) {
        if (super.getDigitalInputSrv().length > number + 1) {
            super.getDigitalInputSrv()[2 * number].checkInput(value);
            super.getDigitalInputSrv()[2 * number + 1].checkInput(value);
        }
    }

    @Override
    public DigitalInputSrv[] getDigitalInputSrv() {
        return super.getDigitalInputSrv();
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        int errorCode = 0;
        try {
            IOHandler.HoldTimer holdTimer;
            DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
            if (service == null) {
                return -21601;
            }
            if (value < 0) {
                this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
                return -21601;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
            }
            this.logger.info("nHoldTime: " + holdTime);
            this.logger.info("nValue: " + value);
            this.deviceIoService.setOutputState(outputNumber - 1, value);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
        }
        catch (Throwable throwable) {
            this.logger.warn("Problems setting output [" + outputNumber + "] of " + this, throwable);
        }
        return errorCode;
    }

    @Override
    protected final int discard() {
        return 0;
    }
}

