/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.sistore;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessage;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessageDescription;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifDevice;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifIoHandler;
import de.seetec.v5.shared.Basic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.onvif.ver10.events.wsdl.PullMessagesFaultResponse;
import org.onvif.ver10.events.wsdl.PullMessagesFaultResponse_Exception;

public final class SistoreOnvifEventHandler
extends Basic
implements Runnable {
    private Logger logger = null;
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifEventHandler";
    private Thread thread = null;
    private OnvifCore onvifCore = null;
    private SistoreOnvifDevice genericOnvifDevice = null;
    private final Collection<HardwareMotionDetection<? extends MotionDetectionHandler>> hardwareMotionDetections = Collections.synchronizedList(new ArrayList());
    private SistoreOnvifIoHandler genericOnvifIoHandler = null;
    private int timeoutInSeconds = 5;
    private int messageLimit = 30;
    private Duration timeoutDuration = null;

    public SistoreOnvifEventHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    public int init(OnvifCore onvifCore, SistoreOnvifDevice genericOnvifDevice) {
        this.onvifCore = onvifCore;
        this.genericOnvifDevice = genericOnvifDevice;
        try {
            this.timeoutDuration = OnvifHelper.intToDuration(this.timeoutInSeconds);
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            this.logger.error("Incorrect Input for intToDuration for " + this.genericOnvifDevice);
        }
        this.thread = new Thread((Runnable)this, CLASS_NAME);
        this.thread.start();
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        int tryCounter = 0;
        while (!this.isShutdown(CLASS_NAME)) {
            try {
                List<EventMessage> eventMessages;
                if (tryCounter == 10) {
                    Thread.sleep(59500L);
                    this.onvifCore.getEventService().resetEventService();
                    tryCounter = 0;
                } else {
                    Thread.sleep(50L);
                }
                try {
                    eventMessages = this.onvifCore.getEventService().pullMessages(this.timeoutDuration, this.messageLimit);
                    tryCounter = 0;
                }
                catch (PullMessagesFaultResponse_Exception pullMessagesFaultResponse_Exception) {
                    ++tryCounter;
                    PullMessagesFaultResponse pullMessagesFaultResponse = pullMessagesFaultResponse_Exception.getFaultInfo();
                    if (this.timeoutInSeconds > OnvifHelper.durationToInt(pullMessagesFaultResponse.getMaxTimeout())) {
                        this.timeoutDuration = pullMessagesFaultResponse.getMaxTimeout();
                        this.timeoutInSeconds = OnvifHelper.durationToInt(this.timeoutDuration);
                    }
                    if (this.messageLimit > pullMessagesFaultResponse.getMaxMessageLimit()) {
                        this.messageLimit = pullMessagesFaultResponse.getMaxMessageLimit();
                    }
                    this.logger.warn("ONVIF FAULT : " + pullMessagesFaultResponse_Exception.getMessage() + " for " + this.genericOnvifDevice);
                    this.logger.info("Using MaxTimeout = " + this.timeoutInSeconds + " and MaxMessageLimit = " + this.messageLimit + " " + this.genericOnvifDevice);
                    continue;
                }
                catch (Exception exception) {
                    ++tryCounter;
                    this.logger.info("Error message : " + exception.getMessage() + " for " + this.genericOnvifDevice);
                    this.logger.warn("Error while evaluating Onvif event for " + this.genericOnvifDevice);
                    continue;
                }
                HashMap<Integer, Boolean> inputs = new HashMap<Integer, Boolean>();
                for (EventMessage eventMessage : eventMessages) {
                    DigitalInputSrv[] iServices;
                    if (this.hardwareMotionDetections != null) {
                        for (HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection : this.hardwareMotionDetections) {
                            HardwareMotionDetectionCnf[] hardwareMotionDetectionCnfs = hardwareMotionDetection.getHardwareMotionDetectionCnf();
                            if (hardwareMotionDetectionCnfs == null || hardwareMotionDetectionCnfs.length <= 0) continue;
                            String onvifEventType = hardwareMotionDetectionCnfs[0].getOnvifEventType();
                            String topic = this.removeNamespace(eventMessage.getTopic());
                            if (!topic.contains(onvifEventType)) continue;
                            EventMessageDescription eventMessageDefinition = this.genericOnvifDevice.getEventTypesMap().get(onvifEventType);
                            int window = 0;
                            if (eventMessageDefinition.getDataName().length <= 0 || !eventMessage.getDataName().equals(eventMessageDefinition.getDataName()[0]) || !eventMessage.getDataValue().toLowerCase().equals("true") && !eventMessage.getDataValue().equals("1") && !eventMessage.getDataValue().equals("Trigger") && !eventMessage.getDataValue().equals("Notify")) continue;
                            hardwareMotionDetection.evaluateWindow(window);
                        }
                    }
                    if (this.genericOnvifIoHandler == null || (iServices = this.genericOnvifIoHandler.getDigitalInputSrv()) == null) continue;
                    for (int i = 0; i < iServices.length; i += 2) {
                        if (!iServices[i + 1].getDigitalInputSrvCnf().isEnabled()) continue;
                        String onvifEventType = iServices[i + 1].getDigitalInputSrvCnf().getOnvifEventType();
                        String topic = this.removeNamespace(eventMessage.getTopic());
                        if (!topic.contains(onvifEventType)) continue;
                        EventMessageDescription eventMessageDefinition = this.genericOnvifDevice.getEventTypesMap().get(onvifEventType);
                        int input = 0;
                        input = i / 2;
                        boolean inputDetected = false;
                        if (eventMessageDefinition.getDataName().length > 0 && eventMessage.getDataName().equals(eventMessageDefinition.getDataName()[0]) && (eventMessage.getDataValue().toLowerCase().equals("true") || eventMessage.getDataValue().equals("1"))) {
                            inputDetected = true;
                        }
                        if (inputs.get(input) != null && ((Boolean)inputs.get(input)).booleanValue()) continue;
                        inputs.put(input, inputDetected);
                    }
                }
                for (Map.Entry entry : inputs.entrySet()) {
                    this.genericOnvifIoHandler.receiveAlarm((Integer)entry.getKey(), (Boolean)entry.getValue() != false ? 1 : 0);
                }
            }
            catch (Exception exception) {
                this.logger.warn("Error while evaluating Onvif event for " + this, (Throwable)exception);
            }
        }
        super.setRunFinished(CLASS_NAME, true);
    }

    public int shutdown() {
        this.startShutdown(CLASS_NAME);
        return 0;
    }

    public void activateMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        if (!this.hardwareMotionDetections.contains(hardwareMotionDetection) && hardwareMotionDetection != null) {
            this.hardwareMotionDetections.add(hardwareMotionDetection);
        }
    }

    public void deactivateMotionDetection(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        if (this.hardwareMotionDetections.contains(hardwareMotionDetection)) {
            this.hardwareMotionDetections.remove(hardwareMotionDetection);
        }
    }

    public void activateInputAlarms(SistoreOnvifIoHandler genericOnvifIoHandler) {
        this.genericOnvifIoHandler = genericOnvifIoHandler;
    }

    public void deactivateInputAlarms() {
        this.genericOnvifIoHandler = null;
    }

    private String removeNamespace(String inputString) {
        if (inputString == null) {
            return null;
        }
        String[] stringWithoutSlashes = inputString.split("/");
        if (stringWithoutSlashes.length < 2) {
            return inputString;
        }
        for (int i = 0; i < stringWithoutSlashes.length; ++i) {
            String[] stringWithoutColon;
            String stringBetweenSlashes = stringWithoutSlashes[i];
            if (!stringBetweenSlashes.contains(":") || (stringWithoutColon = stringBetweenSlashes.split(":")).length != 2) continue;
            stringWithoutSlashes[i] = stringWithoutColon[1];
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < stringWithoutSlashes.length; ++i) {
            result.append(stringWithoutSlashes[i]);
            if (i >= stringWithoutSlashes.length - 1) continue;
            result.append("/");
        }
        return result.toString();
    }
}

