/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.sistore;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.shared.onvif.services.PtzService;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifCameraSrv;
import de.seetec.v5.re.cm.device.video.onvif.sistore.SistoreOnvifDevice;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import java.util.Vector;
import javax.xml.ws.Holder;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.PTZConfiguration;
import org.onvif.ver10.schema.PTZPreset;
import org.onvif.ver10.schema.Profile;

public class SistoreOnvifCameraControl
extends CameraControl {
    private PtzService ptzService = null;
    private String profileName = null;

    @Override
    public int init(VideoSrv videoSrv, String sAPI, String sHost, int nPort, String sUSR, String sPWD, Vector<PresetCnf> vPresetList) {
        if (this.ptzService == null) {
            try {
                SistoreOnvifDevice onvifDevice = (SistoreOnvifDevice)((SistoreOnvifCameraSrv)videoSrv).getDevice();
                OnvifCore onvifCore = onvifDevice.getOnvifCore();
                this.ptzService = onvifCore.getPtzService();
                Media mediaService = onvifCore.getMediaService().getOnvifMediaService();
                int videoSourceNumber = 0;
                try {
                    videoSourceNumber = videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                }
                catch (ConfigurationException exception) {
                    this.logger.warn("Error while initializing ONVIF PTZ configuration, could not read VideoSourceNumber from configuration", (Throwable)exception);
                }
                String[] selectedOnvifProfileAndStreamName = OnvifHelper.extractOnvifProfileAndStreamName(((SistoreOnvifCameraSrv)videoSrv).getBasicVideoProfileHandler().getVideoSourceParameter().getStreamName());
                String selectedOnvifProfile = selectedOnvifProfileAndStreamName[0];
                this.profileName = onvifCore.getMediaService().getProfile(selectedOnvifProfile, "VMS default", videoSourceNumber, 0).getToken();
                Profile profile = onvifCore.getMediaService().getOnvifMediaService().getProfile(this.profileName);
                if (profile.getPTZConfiguration() == null) {
                    String ptzConfigurationToken;
                    List ptzConfigurations = onvifCore.getPtzService().getOnvifPtzService().getConfigurations();
                    if (videoSourceNumber < ptzConfigurations.size()) {
                        ptzConfigurationToken = ((PTZConfiguration)ptzConfigurations.get(videoSourceNumber)).getToken();
                    } else {
                        ptzConfigurationToken = ((PTZConfiguration)ptzConfigurations.get(0)).getToken();
                        this.logger.warn("Error while initializing ONVIF PTZ configuration, not enough PTZ configurations available, use first one instead");
                    }
                    mediaService.addPTZConfiguration(profile.getToken(), ptzConfigurationToken);
                }
            }
            catch (ConfigurationException exception) {
                this.logger.warn("Error while initializing ONVIF PTZ configuration", (Throwable)exception);
                return -21602;
            }
            catch (SeeTecException exception) {
                this.logger.warn("Error while initializing ONVIF PTZ configuration", (Throwable)exception);
                return exception.getErrorCode();
            }
        }
        return super.init(videoSrv, sAPI, sHost, nPort, sUSR, sPWD, vPresetList);
    }

    public int[] getAbsolutePTZ() {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer nPan, Integer nTilt, Integer nZoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousPTZ(Integer nPanSpeed, Integer nTiltSpeed, Integer nZoomSpeed) {
        try {
            this.ptzService.sendContinuousPtzCommand(this.profileName, nPanSpeed, nTiltSpeed, nZoomSpeed, 10, 100L);
            this.videoSrv.notifyForCameraControl();
            return 0;
        }
        catch (SeeTecException exception) {
            this.logger.error((Object)exception);
            return exception.getErrorCode();
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
            return -21653;
        }
    }

    @Override
    public int setCenterPT(Integer nXPosition, Integer nYPosition, int[] resolution) {
        try {
            this.ptzService.sendContinuousPtzCommand(this.profileName, nXPosition, nYPosition, 1, 100, 100L);
            this.videoSrv.notifyForCameraControl();
            return 0;
        }
        catch (SeeTecException exception) {
            this.logger.error((Object)exception);
            return exception.getErrorCode();
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
            return -21653;
        }
    }

    @Override
    public int setZoomArea(Integer nXPosition, Integer nYPosition, Integer nWidth, Integer nHeigth, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer nValue) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer nValue) {
        return 0;
    }

    @Override
    public int setAutoIris(Boolean bActive) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteFocus(Integer nValue) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer nValue) {
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean bActive) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZeroLux(Boolean bActive) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoZeroLux(Boolean bActive) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setHomePosition() {
        try {
            this.ptzService.getOnvifPtzService().gotoHomePosition(this.profileName, null);
            this.videoSrv.notifyForCameraControl();
            return 0;
        }
        catch (Exception exception) {
            this.logger.warn("Setting HomePosition failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() != null && !preset.getName().equals(encodedPresetName)) continue;
                this.ptzService.getOnvifPtzService().removePreset(this.profileName, preset.getToken());
            }
            Holder presetToken = new Holder();
            this.ptzService.getOnvifPtzService().setPreset(this.profileName, encodedPresetName, presetToken);
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, (String)presetToken.value, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Setting preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() == null || !preset.getName().equals(encodedPresetName)) continue;
                this.ptzService.getOnvifPtzService().gotoPreset(this.profileName, preset.getToken(), null);
                this.videoSrv.notifyForCameraControl();
                break;
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.warn("Going to preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String encodedPresetName = this.getEncodedPresetNameEmptyNotAllowed(presetName);
            List presets = this.ptzService.getOnvifPtzService().getPresets(this.profileName);
            for (PTZPreset preset : presets) {
                if (preset.getName() != null && !preset.getName().equals(encodedPresetName)) continue;
                this.ptzService.getOnvifPtzService().removePreset(this.profileName, preset.getToken());
            }
            return 0;
        }
        catch (Exception exception) {
            this.logger.error("Removing preset [" + presetName + "] failed", (Throwable)exception);
            return -21600;
        }
    }
}

