/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.simple;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.videoprofile.AdditionalVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.onvif.simple.SimpleGenericOnvifDevice;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.TransportProtocol;

public final class SimpleGenericOnvifVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.generic.GenericOnvifVideoSourceClient";

    @Override
    public int init() {
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        try {
            SimpleGenericOnvifDevice onvifDevice = (SimpleGenericOnvifDevice)this.getVideoSrv().getDevice();
            TransportProtocol transportProtocol = this.transmissionID == TransmissionType.RTP_OVER_RTSP_OVER_TCP ? TransportProtocol.TCP : TransportProtocol.UDP;
            String profileToken = null;
            if (this.listener instanceof BasicVideoProfileHandler) {
                try {
                    profileToken = onvifDevice.getProfileToken1();
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    this.logger.error("No ONVIF Profile exists");
                    this.logger.error((Object)exception);
                    return -21600;
                }
            } else if (this.listener instanceof AdditionalVideoProfileHandler) {
                try {
                    profileToken = onvifDevice.getProfileToken2();
                }
                catch (ArrayIndexOutOfBoundsException exception) {
                    this.logger.warn("No 2nd ONVIF Profile exists");
                    this.logger.warn((Object)exception);
                    return -21600;
                }
            } else {
                return -21600;
            }
            OnvifCore onvifCore = onvifDevice.getOnvifCore();
            this.rtspUrl = onvifCore.getMediaService().getStreamUri(profileToken, StreamType.RTP_UNICAST, transportProtocol);
            this.logger.info("Profile: " + profileToken);
            this.logger.info("RTSP URL: " + this.rtspUrl);
            try {
                this.logger.info(this.rtspUrl);
                String regex = ":([\\p{Digit}]+)/";
                String result = "";
                Matcher matcher = Pattern.compile(":([\\p{Digit}]+)/").matcher(this.rtspUrl);
                if (matcher.find()) {
                    result = matcher.group(1);
                }
                this.logger.info("Set RTSP PORT to " + result);
                this.listener.getVideoSourceParameter().setRtspPort(Integer.parseInt(result));
            }
            catch (Exception exception) {
                this.logger.warn((Object)exception);
                this.listener.getVideoSourceParameter().setRtspPort(554);
            }
        }
        catch (Exception exception) {
            this.logger.error("There is no generic RTSP Url in the configuration or it can not be read =(");
            this.logger.error((Object)exception);
            return -21662;
        }
        try {
            this.networkParameter.setSoTimeout(5000);
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 3, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting RTSP parameters for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.setUdpBuffer(65535);
            this.rtspSettings.setUserAgent("Java / Seetec");
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP stream for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.info((Object)ex);
            this.logger.error("Error while first RTSP request. errorCode: " + ex.getErrorCode() + " for " + this.getVideoSrv());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.info((Object)ex);
            this.logger.error("Error while first RTSP request. errorCode: " + this.errorCode + " for " + this.getVideoSrv());
            return this.errorCode;
        }
        this.publishRTSPUrl(this.rtspUrl);
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

