/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.simple;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.video.onvif.simple.SimpleGenericOnvifIoHandler;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import org.onvif.ver10.media.wsdl.Media;
import org.onvif.ver10.schema.Profile;

public final class SimpleGenericOnvifDevice
extends VideoServer {
    private OnvifCore onvifCore = null;
    private String profileToken1 = null;
    private String profileToken2 = null;

    @Override
    public int initializeDevice(long nSrvType) {
        super.initializeDevice(nSrvType);
        int errorCode = 0;
        if (this.isOnvifDevice()) {
            try {
                NetworkParameter networkParameter = this.getDeviceCnf().getNetworkParameter();
                if (networkParameter != null) {
                    if (this.onvifCore == null) {
                        this.onvifCore = new OnvifCore();
                    }
                    String user = null;
                    if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[0] != null) {
                        user = networkParameter.getUserPWD()[0];
                    }
                    String pw = null;
                    if (networkParameter.getUserPWD() != null && networkParameter.getUserPWD()[1] != null) {
                        pw = networkParameter.getUserPWD()[1];
                    }
                    boolean useAuthorization = false;
                    if (user != null && pw != null) {
                        useAuthorization = true;
                    }
                    OnvifDevice onvifDevice = new OnvifDevice(this.getDeviceEntity().getEntityName(), networkParameter, user, pw, "PasswordDigest", useAuthorization);
                    try {
                        this.onvifCore.init(onvifDevice, this.logger.isDebugEnabled());
                    }
                    catch (OnvifException onvifException) {
                        this.onvifCore.shutdown();
                        errorCode = onvifException.getErrorCode();
                        this.logger.error(onvifException.getCause().getMessage());
                    }
                }
            }
            catch (ConfigurationException exception) {
                this.logger.info((Object)exception);
            }
        }
        return errorCode;
    }

    @Override
    protected IOHandler createIOHandler() {
        return new SimpleGenericOnvifIoHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public OnvifCore getOnvifCore() {
        return this.onvifCore;
    }

    public boolean isOnvifDevice() {
        return this.getDeviceType() == 209600L;
    }

    public String getProfileToken(int profileNumber) {
        Media media = this.onvifCore.getMediaService().getOnvifMediaService();
        List profiles = media.getProfiles();
        Object profile = profiles.toArray()[profileNumber];
        String profileToken = ((Profile)profile).getToken();
        return profileToken;
    }

    public String getProfileToken1() throws ArrayIndexOutOfBoundsException {
        if (this.profileToken1 == null) {
            this.profileToken1 = this.getProfileToken(0);
        }
        return this.profileToken1;
    }

    public String getProfileToken2() throws ArrayIndexOutOfBoundsException {
        if (this.profileToken2 == null) {
            this.profileToken2 = this.getProfileToken(1);
        }
        return this.profileToken2;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

