/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.device.shared.onvif.services.ReplayService;
import de.seetec.v5.re.cm.device.shared.onvif.services.SearchService;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifHelper;
import de.seetec.v5.shared.util.ConfigurationException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.logging.log4j.Logger;
import org.onvif.ver10.schema.DateTime;
import org.onvif.ver10.schema.FindRecordingResultList;
import org.onvif.ver10.schema.RecordingInformation;
import org.onvif.ver10.schema.SearchScope;
import org.onvif.ver10.schema.SearchScopeExtension;
import org.onvif.ver10.schema.SearchState;
import org.onvif.ver10.schema.StreamSetup;
import org.onvif.ver10.schema.StreamType;
import org.onvif.ver10.schema.Transport;
import org.onvif.ver10.schema.TransportProtocol;

public class GenericOnvifPlaybackVideoSourceClient
extends PlaybackVideoSourceClient {
    private GenericOnvifDevice device = null;

    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.device = (GenericOnvifDevice)this.getVideoSrv().getDevice();
            this.networkParameter.setSoTimeout(30000);
            try {
                this.setTimeDifference(this.getTimeDifferenceFromDevice());
            }
            catch (Exception ex) {
                this.logger.error("Error getting time from device " + this + ": " + ex.getMessage());
            }
            this.printDebug = false;
            double speed = this.listener.getVideoSourceParameter().getEdgeStorageParameter().getPlaybackSpeed();
            this.setRtspPlaybackSpeed(speed);
            this.setStartAllTrackIds(true);
            this.setLocalStorageReady(true);
        }
        catch (Throwable ex) {
            this.logger.error("Error while initalizing " + this, ex);
        }
        return 0;
    }

    @Override
    protected Long getTimeDifferenceFromDevice() throws Exception {
        DateTime dateTime = this.getDevice().getOnvifCore().getDeviceService().getOnvifDeviceService().getSystemDateAndTime().getUTCDateTime();
        if (dateTime == null) {
            dateTime = this.getDevice().getOnvifCore().getDeviceService().getOnvifDeviceService().getSystemDateAndTime().getLocalDateTime();
        }
        Calendar calendar = Calendar.getInstance();
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        calendar.setTimeZone(timeZone);
        calendar.set(dateTime.getDate().getYear(), dateTime.getDate().getMonth() - 1, dateTime.getDate().getDay(), dateTime.getTime().getHour(), dateTime.getTime().getMinute(), dateTime.getTime().getSecond());
        Date now = new Date();
        long diff = calendar.getTimeInMillis() - now.getTime();
        this.logger.info("Time Difference from device: " + diff + "(Device time: " + new Date(calendar.getTimeInMillis()) + ", PC time: " + new Date(now.getTime()));
        return diff;
    }

    @Override
    protected final double getMaxPlaybackSpeed() {
        return 1.0;
    }

    @Override
    protected String getRtspUrl(long startTimestamp, long endTimestamp, String nameOfRecording) throws ConfigurationException {
        try {
            SearchService searchService = this.device.getOnvifCore().getSearchService();
            SearchScope searchScope = new SearchScope();
            searchScope.setRecordingInformationFilter(null);
            SearchScopeExtension searchScopeExtension = new SearchScopeExtension();
            searchScope.setExtension(searchScopeExtension);
            DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
            Duration duration = datatypeFactory.newDuration("PT10S");
            String session = searchService.getOnvifSearchService().findRecordings(searchScope, null, duration);
            FindRecordingResultList findRecordingResultList = searchService.getOnvifSearchService().getRecordingSearchResults(session, null, null, null);
            List recordingInformationList = findRecordingResultList.getRecordingInformation();
            for (int counter = 0; (findRecordingResultList.getSearchState().equals((Object)SearchState.SEARCHING) || findRecordingResultList.getSearchState().equals((Object)SearchState.QUEUED)) && counter < 10; ++counter) {
                Thread.sleep(10L);
                findRecordingResultList = searchService.getOnvifSearchService().getRecordingSearchResults(session, null, null, null);
                recordingInformationList.addAll(findRecordingResultList.getRecordingInformation());
            }
            try {
                searchService.getOnvifSearchService().endSearch(session);
            }
            catch (Exception ex) {
                this.logger.info("Exception while ending search " + session + ". Search has probably ended already for " + this);
            }
            Iterator iterator = recordingInformationList.iterator();
            if (iterator.hasNext()) {
                RecordingInformation recordingInformation = (RecordingInformation)iterator.next();
                StreamSetup streamSetup = new StreamSetup();
                streamSetup.setStream(StreamType.RTP_UNICAST);
                Transport transport = new Transport();
                transport.setProtocol(TransportProtocol.UDP);
                streamSetup.setTransport(transport);
                ReplayService replayService = this.device.getOnvifCore().getReplayService();
                String uri = replayService.getOnvifReplayService().getReplayUri(streamSetup, recordingInformation.getRecordingToken());
                return uri;
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while trying to get URI for RTSP Playback: " + ex.getMessage() + " for " + this);
        }
        return "";
    }

    @Override
    protected String getTimeRange(long startTimestamp, long endTimestamp, String nameOfTimerange) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        long newStartTimestamp = GenericOnvifHelper.convertTimestampToCamera(startTimestamp, this.getTimeDifference());
        long newEndTimestamp = GenericOnvifHelper.convertTimestampToCamera(endTimestamp, this.getTimeDifference());
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String start = sdf.format(new Date(newStartTimestamp));
        String end = sdf.format(new Date(newEndTimestamp));
        return "clock=" + start + "Z-" + end + "Z";
    }

    @Override
    protected String getRequireField() {
        return "onvif-replay";
    }

    protected GenericOnvifDevice getDevice() {
        return this.device;
    }
}

