/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceIoService;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifEventHandler;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;
import org.onvif.ver10.device.wsdl.Device;
import org.onvif.ver10.schema.RelayLogicalState;
import org.onvif.ver10.schema.RelayMode;
import org.onvif.ver10.schema.RelayOutput;
import org.onvif.ver10.schema.RelayOutputSettings;

public class GenericOnvifIoHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifIoHandler";
    private GenericOnvifEventHandler genericOnvifEventHandler = null;
    private Device device = null;
    private List<RelayOutput> relayOutputs = null;
    private DeviceIoService deviceIoService = null;

    @Override
    public int init(Core core, de.seetec.v5.re.cm.device.shared.Device device, Entity[] srvEnities, boolean ignoreSomeParameter, boolean unconditionalStartOfThread) {
        try {
            if (device instanceof GenericOnvifDevice) {
                GenericOnvifDevice onvifDevice = (GenericOnvifDevice)device;
                OnvifCore onvifCore = onvifDevice.getOnvifCore();
                this.device = onvifCore.getDeviceService().getOnvifDeviceService();
                this.relayOutputs = this.device.getRelayOutputs();
                for (RelayOutput relayOutput : this.relayOutputs) {
                    RelayOutputSettings relayOutputSettings = relayOutput.getProperties();
                    relayOutputSettings.setMode(RelayMode.BISTABLE);
                    this.device.setRelayOutputSettings(relayOutput.getToken(), relayOutputSettings);
                }
            }
        }
        catch (Exception exception) {
            try {
                if (device instanceof GenericOnvifDevice) {
                    GenericOnvifDevice onvifDevice = (GenericOnvifDevice)device;
                    OnvifCore onvifCore = onvifDevice.getOnvifCore();
                    this.deviceIoService = onvifCore.getDeviceIoService();
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while looking for IO-Service for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
        }
        int errorCode = super.init(core, device, srvEnities, ignoreSomeParameter, unconditionalStartOfThread);
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        if (iServices.length > 0) {
            GenericOnvifDevice genericOnvifDevice = (GenericOnvifDevice)device;
            this.genericOnvifEventHandler = genericOnvifDevice.getGenericOnvifEventHandler();
            this.genericOnvifEventHandler.activateInputAlarms(this);
        }
        return errorCode;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, true);
    }

    @Override
    public int shutdown() {
        if (this.genericOnvifEventHandler != null) {
            this.genericOnvifEventHandler.deactivateInputAlarms();
            this.genericOnvifEventHandler = null;
        }
        return super.shutdown();
    }

    public void receiveAlarm(int number, int value) {
        for (DigitalInputSrv digitalInputSrv : super.getDigitalInputSrv()) {
            if (digitalInputSrv.getInputNumber() - 1 != number) continue;
            digitalInputSrv.checkInput(value);
        }
    }

    @Override
    public DigitalInputSrv[] getDigitalInputSrv() {
        return super.getDigitalInputSrv();
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        int errorCode = 0;
        try {
            IOHandler.HoldTimer holdTimer;
            DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
            if (service == null) {
                return -21601;
            }
            if (value < 0) {
                this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
                return -21601;
            }
            if (this.deviceIoService != null) {
                this.deviceIoService.setOutputState(outputNumber - 1, value);
            } else {
                if (this.relayOutputs == null) {
                    this.relayOutputs = this.device.getRelayOutputs();
                }
                String outputToken = this.getDigitalOutputToken(outputNumber, this.relayOutputs);
                RelayLogicalState state = value > 0 ? RelayLogicalState.ACTIVE : RelayLogicalState.INACTIVE;
                this.device.setRelayOutputState(outputToken, state);
            }
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "]");
            }
        }
        catch (Throwable throwable) {
            this.logger.warn("Problems setting output [" + outputNumber + "] of " + this, throwable);
        }
        return errorCode;
    }

    @Override
    protected int discard() {
        return 0;
    }

    private String getDigitalOutputToken(int outputNumber, List<RelayOutput> relayOutputs) throws SeeTecException {
        if (relayOutputs == null || relayOutputs.isEmpty()) {
            throw new SeeTecException(-20002, "Output not available");
        }
        if (relayOutputs.size() >= outputNumber) {
            return relayOutputs.get(outputNumber - 1).getToken();
        }
        return relayOutputs.get(0).getToken();
    }
}

