/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifAudioOutServer;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifCameraControl;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifVideoSourceClient;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifVideoSourceClientMedia2;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.UnknownHostException;
import java.util.List;

public class GenericOnvifCameraSrv
extends LiveCameraSrv {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifCameraSrv";

    @Override
    public int initLive() throws UnknownHostException, ConfigurationException {
        int errorCode = super.initLive();
        EdgeStorageParameter edgeStorageParameter = this.getVideoSourceCnf().getEdgeStorageParameter();
        if (edgeStorageParameter != null && edgeStorageParameter.isEnabled()) {
            this.logger.info(((GenericOnvifDevice)this.device).checkEdgeStorageReady(this.getVideoSourceCnf().getServerEntryNo()));
        }
        return errorCode;
    }

    @Override
    public CameraControl createCameraControl(Long entityType) {
        GenericOnvifDevice genericOnvifDevice = (GenericOnvifDevice)this.device;
        if (genericOnvifDevice.getDeviceDefinitionFromConfiguration() != null && genericOnvifDevice.getDeviceDefinitionFromConfiguration().getMiscVideoServerCapabilities().isCanPTZ()) {
            return new GenericOnvifCameraControl();
        }
        return new DoNothingCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        StreamingVideoSourceClientRTSP videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            if (!(listener.getVideoSourceParameter().getMediaCodec() == Codec.H265 || !this.isSupportingMedia1Profile() || this.isSupportingMedia2Profile() && this.device.getDeviceCnf().getAPI().equals("ONVIF: Prioritize Media2 service (Profile-T)"))) {
                videoSourceClient = new GenericOnvifVideoSourceClient();
                this.logger.info("Device is using Media Service for " + this);
            } else {
                videoSourceClient = new GenericOnvifVideoSourceClientMedia2();
                this.logger.info("Device is using Media2 Service for " + this);
            }
            int errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seeTecException) {
            throw seeTecException;
        }
        catch (Throwable throwable) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            String errorMessage = "Creating [VideoSourceClient] for " + this + " failed";
            this.logger.error(errorMessage, throwable);
            throw new SeeTecException(-20001, errorMessage);
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED...");
    }

    @Override
    protected GenericOnvifAudioOutServer createAudioOutServer() {
        GenericOnvifAudioOutServer genericOnvifAudioOutServer;
        try {
            NetworkParameter networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
            int rtspPort = 554;
            GenericOnvifDevice genericOnvifDevice = (GenericOnvifDevice)this.device;
            OnvifCore onvifCore = genericOnvifDevice.getOnvifCore();
            genericOnvifAudioOutServer = new GenericOnvifAudioOutServer(onvifCore, networkParameter, rtspPort);
            genericOnvifAudioOutServer.init();
        }
        catch (Exception ex) {
            this.logger.error("Exception while creating Onvif Audio Out server for " + this + ": " + ex.getMessage());
            return null;
        }
        return genericOnvifAudioOutServer;
    }

    protected boolean isSupportingMedia1Profile() {
        List profiles = null;
        try {
            GenericOnvifDevice genericOnvifDevice = (GenericOnvifDevice)this.device;
            OnvifCore onvifCore = genericOnvifDevice.getOnvifCore();
            profiles = onvifCore.getMediaService().getOnvifMediaService().getProfiles();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profiles != null;
    }

    protected boolean isSupportingMedia2Profile() {
        List profiles = null;
        try {
            GenericOnvifDevice genericOnvifDevice = (GenericOnvifDevice)this.device;
            OnvifCore onvifCore = genericOnvifDevice.getOnvifCore();
            profiles = onvifCore.getMedia2Service().getOnvifMedia2Service().getProfiles(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return profiles != null;
    }
}

