/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.onvif.generic;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministration;
import de.seetec.v5.re.cm.device.shared.cameraadministration.CameraAdministrationBase;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifException;
import de.seetec.v5.re.cm.device.shared.onvif.services.DeviceService;
import de.seetec.v5.re.cm.device.video.onvif.generic.GenericOnvifDevice;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.SeetecHttpClient;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.onvif.ver10.schema.IPv4NetworkInterfaceSetConfiguration;
import org.onvif.ver10.schema.NetworkGateway;
import org.onvif.ver10.schema.NetworkInterface;
import org.onvif.ver10.schema.NetworkInterfaceSetConfiguration;
import org.onvif.ver10.schema.PrefixedIPv4Address;
import org.onvif.ver10.schema.User;

public class GenericOnvifCameraAdministration
extends CameraAdministrationBase
implements CameraAdministration {
    public GenericOnvifCameraAdministration(SeetecHttpClient httpClient) throws SeeTecException {
        super(httpClient);
    }

    protected OnvifDevice createOnvifDevice(boolean useAuthorization, NetworkParameter networkParameter) {
        String user = null;
        String password = null;
        if (networkParameter.getUserPWD() != null) {
            user = networkParameter.getUserPWD()[0];
            password = networkParameter.getUserPWD()[1];
        }
        String authenticationType = this.checkAuthenticationType(useAuthorization, networkParameter, user, password);
        OnvifDevice onvifDevice = new OnvifDevice("", networkParameter, user, password, authenticationType, useAuthorization);
        return onvifDevice;
    }

    public String checkAuthenticationType(boolean useAuthorization, NetworkParameter networkParameter, String user, String password) {
        String passwordType = "PasswordDigest";
        if (useAuthorization) {
            try {
                int authenticationCheckTimeout = 7000;
                passwordType = GenericOnvifDevice.checkAuthenticationType(networkParameter.getHost(), networkParameter.getHTTPport(), networkParameter.getSSLport(), user, password, authenticationCheckTimeout, networkParameter.useHTTPS());
            }
            catch (Exception exception) {
                passwordType = "PasswordDigest";
            }
        }
        return passwordType;
    }

    protected OnvifCore createOnvifCore(OnvifDevice onvifDevice) throws OnvifException {
        OnvifCore newOnvifCore = new OnvifCore();
        newOnvifCore.init(onvifDevice, false);
        return newOnvifCore;
    }

    @Override
    protected void modifyPasswordOnDevice(String passwordToSet, NetworkParameter networkParameter) throws SeeTecException {
        try {
            List userList;
            OnvifDevice onvifDevice = this.createOnvifDevice(true, networkParameter);
            OnvifCore onvifCore = this.createOnvifCore(onvifDevice);
            DeviceService deviceService = onvifCore.getDeviceService();
            String userName = networkParameter.getUserPWD()[0];
            try {
                userList = deviceService.getOnvifDeviceService().getUsers();
            }
            catch (Exception e) {
                userList = deviceService.getOnvifDeviceService().getUsers();
            }
            for (User user : userList) {
                if (!user.getUsername().equals(userName)) continue;
                user.setPassword(passwordToSet);
                ArrayList<User> listToSet = new ArrayList<User>();
                listToSet.add(user);
                deviceService.getOnvifDeviceService().setUser(listToSet);
            }
        }
        catch (OnvifException ex) {
            String errorMessage = "";
            if (ex.getMessage().contains("UsernameMissing")) {
                errorMessage = "Username not recognized";
            } else if (ex.getMessage().contains("PasswordTooLong")) {
                errorMessage = "The password is too long";
            } else if (ex.getMessage().contains("PasswordTooWeak")) {
                errorMessage = "The password is too weak";
            } else if (ex.getMessage().contains("AnonymousNotAllowed")) {
                errorMessage = "User level Anonymous is not allowed";
            } else if (ex.getMessage().contains("FixedUser")) {
                errorMessage = "Password or User level may not be changed";
            }
            throw new SeeTecException(-20002, errorMessage);
        }
        catch (Exception t) {
            String errorMessage = t.getMessage();
            throw new SeeTecException(-20002, errorMessage);
        }
    }

    @Override
    protected void upgradeFirmwareOnDevice(byte[] firmwareData, NetworkParameter networkParameter) throws SeeTecException {
    }

    @Override
    public void changeDeviceIP(String newIP, String networkMask, EntMgrProxy entMgrProxy, Entity entity, Core core) throws SeeTecException {
        try {
            int prefix = this.convertSubnetMaskToPrefix(networkMask);
            DeviceCnf deviceCnf = new DeviceCnf(null);
            int errorCode = deviceCnf.init(entity.getConfiguration());
            if (errorCode != 0) {
                throw new SeeTecException(errorCode, "Reading device configuration " + deviceCnf + " failed with error [" + errorCode + "]");
            }
            NetworkParameter networkParameter = deviceCnf.getNetworkParameter();
            OnvifDevice onvifDevice = this.createOnvifDevice(true, networkParameter);
            OnvifCore onvifCore = this.createOnvifCore(onvifDevice);
            DeviceService deviceService = onvifCore.getDeviceService();
            NetworkGateway networkGateway = onvifCore.getDeviceService().getOnvifDeviceService().getNetworkDefaultGateway();
            List ipv4Address = networkGateway.getIPv4Address();
            List ipv6Address = networkGateway.getIPv6Address();
            onvifCore.getDeviceService().getOnvifDeviceService().setNetworkDefaultGateway(ipv4Address, ipv6Address);
            List networkInterfaces = deviceService.getOnvifDeviceService().getNetworkInterfaces();
            NetworkInterface networkInterface = (NetworkInterface)networkInterfaces.get(0);
            String networkInterfaceToken = networkInterface.getToken();
            NetworkInterfaceSetConfiguration networkInterfaceSetConfiguration = new NetworkInterfaceSetConfiguration();
            networkInterfaceSetConfiguration.setEnabled(Boolean.valueOf(networkInterface.isEnabled()));
            IPv4NetworkInterfaceSetConfiguration ipv4NetworkInterfaceSetConfiguration = networkInterfaceSetConfiguration.getIPv4();
            if (ipv4NetworkInterfaceSetConfiguration == null) {
                ipv4NetworkInterfaceSetConfiguration = new IPv4NetworkInterfaceSetConfiguration();
                ipv4NetworkInterfaceSetConfiguration.setDHCP(Boolean.valueOf(false));
                ipv4NetworkInterfaceSetConfiguration.setEnabled(Boolean.valueOf(true));
                PrefixedIPv4Address prefixedIpv4Address = new PrefixedIPv4Address();
                prefixedIpv4Address.setAddress(newIP);
                prefixedIpv4Address.setPrefixLength(prefix);
                ipv4NetworkInterfaceSetConfiguration.getManual().add(prefixedIpv4Address);
            } else {
                ipv4NetworkInterfaceSetConfiguration.setDHCP(Boolean.valueOf(networkInterface.getIPv4().getConfig().isDHCP()));
                ipv4NetworkInterfaceSetConfiguration.setEnabled(Boolean.valueOf(networkInterface.getIPv4().isEnabled()));
                ((PrefixedIPv4Address)ipv4NetworkInterfaceSetConfiguration.getManual().get(0)).setAddress(newIP);
                ((PrefixedIPv4Address)ipv4NetworkInterfaceSetConfiguration.getManual().get(0)).setPrefixLength(prefix);
            }
            networkInterfaceSetConfiguration.setIPv4(ipv4NetworkInterfaceSetConfiguration);
            onvifCore.getDeviceService().getOnvifDeviceService().setNetworkInterfaces(networkInterfaceToken, networkInterfaceSetConfiguration);
        }
        catch (Exception ex) {
            throw new SeeTecException(-20002, ex.getMessage());
        }
    }

    protected int convertSubnetMaskToPrefix(String networkMask) {
        String[] networkMaskParts;
        if (networkMask != null && !networkMask.isEmpty() && (networkMaskParts = networkMask.split("\\.")).length == 4) {
            int counter;
            String maskAsBinary = "";
            for (String subnetPart : networkMaskParts) {
                try {
                    int number = Integer.parseInt(subnetPart);
                    maskAsBinary = maskAsBinary + StringUtils.leftPad((String)Integer.toBinaryString(number), (int)4, (char)'0');
                }
                catch (Exception ex) {
                    this.logger.error("Exception while converting string " + subnetPart + " to number for " + this);
                    return 0;
                }
            }
            for (counter = 0; counter < 32 && maskAsBinary.charAt(counter) != '0'; ++counter) {
            }
            return counter;
        }
        return 0;
    }
}

