/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.norbain;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.video.norbain.NorbainDevice;
import de.seetec.v5.re.cm.device.video.norbain.NorbainModel;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public final class NorbainIoHandler
extends IOHandler
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.norbain.NorbainIoHandler";
    private NorbainDevice norbainDevice;
    private boolean[] outputsActivated = new boolean[4];
    private HttpServerPushHandler httpServerPushHandler = null;

    @Override
    public final void run() {
        int errorCode = 0;
        super.setRunFinished(CLASS_NAME, false);
        if (this.norbainDevice == null) {
            this.norbainDevice = (NorbainDevice)this.device;
        }
        for (int i = 0; i < this.outputsActivated.length; ++i) {
            this.outputsActivated[i] = false;
        }
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            for (int i = 0; i < iServices.length; ++i) {
                String url = "/event/alarm_in.php?app=set&alarm_in_" + (i + 1) + "_enable=1";
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            }
            errorCode = 0;
            super.setRunFinished(CLASS_NAME, false);
            String url = "/stream/event_stream.php?ch=1&strm=1&alarm=1";
            boolean bAsynchronous = true;
            this.httpServerPushHandler = new HttpServerPushHandler();
            errorCode = this.httpServerPushHandler.init(this, this.networkParameter, url);
            if (errorCode != 0) {
                this.logger.error("Error [" + errorCode + "]with " + this.httpServerPushHandler);
            } else {
                errorCode = this.httpServerPushHandler.startServerPush(bAsynchronous);
                if (errorCode != 0) {
                    this.logger.warn("ServerPush of " + this.httpServerPushHandler + " terminated with error [" + errorCode + "]");
                }
            }
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(iServices[i].getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable throwable) {
                    previousLoopWithError = true;
                    if (throwable instanceof IOException || throwable instanceof UnknownHostException || throwable instanceof NoRouteToHostException || throwable instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)throwable, throwable);
                        if (throwable.getMessage().indexOf("Address already in use") >= 0) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable throwable2) {
                        this.logger.warn((Object)throwable2, throwable2);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable, throwable);
        }
        this.logger.info("Thread of this " + this + " finished");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public final int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        int errorCode = 0;
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] ");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            long time = holdTime / 1000L;
            if (time <= 0L || time > 180L) {
                time = 180L;
            }
            if (!this.outputsActivated[outputNumber - 1]) {
                this.outputsActivated[outputNumber - 1] = true;
                StringBuilder activateTriggerUrl = new StringBuilder("/event/trigger.php?app=set&trigger1_enable=1&trigger1_time=" + time);
                this.logger.info((CharSequence)activateTriggerUrl);
                this.logger.info(new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)activateTriggerUrl.toString(), (int)Integer.MAX_VALUE)));
                if (this.norbainDevice == null) {
                    this.norbainDevice = (NorbainDevice)this.device;
                }
                if (this.norbainDevice.getNorbainModel() != NorbainModel.B) {
                    StringBuilder activateAlarmOutUrl = new StringBuilder("/event/alarm_out.php?app=set&alarm_out_enable=1");
                    this.logger.info(new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)activateAlarmOutUrl.toString(), (int)Integer.MAX_VALUE)));
                }
                int eventId = 600;
                if (this.norbainDevice.getNorbainModel() == NorbainModel.B) {
                    eventId = 700;
                }
                StringBuilder createEventOnMapUrl = new StringBuilder("/event/event_pop.php?app=set&method=add&event_name=OutputTrigger" + outputNumber + "&event_out_smtp=0&event_out_smtp_en1=0&event_out_smtp_en2=0&event_out_smtp_en3=0&event_out_smtp_en4=0&event_out_smtp_en5=0&event_out_smtp_en6=0&event_out_smtp_en7=0&event_out_smtp_en8=0&event_out_smtp_title=&event_out_smtp_msg=&event_out_ftp=0&event_out_http=0&event_out_http_msg=&event_out_alarm=1&event_out_audio=0&event_out_audio_file=1&event_out_preset=0&event_out_preset_num=1&event_out_preset_home=0&event_out_record=0&event_out_privacy_mask=0&event_in_id=0" + (eventId += outputNumber - 1) + "&event_out_event_push=0&event_out_light=0");
                this.logger.info(createEventOnMapUrl.toString());
                this.logger.info(new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)createEventOnMapUrl.toString(), (int)Integer.MAX_VALUE)));
            }
            StringBuilder triggerUrl = new StringBuilder("/event/trigger.php?app=set&make_trigger=1");
            this.logger.info(new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)triggerUrl.toString(), (int)Integer.MAX_VALUE)));
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [ " + errorCode + " ] :-( ");
            }
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Exception while writing digital output for " + this + ": " + seeTecException.getMessage());
            return seeTecException.getErrorCode();
        }
        return 0;
    }

    @Override
    protected final int discard() {
        return 0;
    }

    @Override
    public final void deliverContent(HttpServerPushContent httpServerPushContent) {
        try {
            byte[] content = httpServerPushContent.getContentBody();
            String body = new String(content);
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            for (int i = 0; i < iServices.length / 2; ++i) {
                if (body.contains("alarm" + (i + 1) + "=1")) {
                    iServices[2 * i].checkInput(1);
                    iServices[2 * i + 1].checkInput(1);
                    continue;
                }
                if (!body.contains("alarm=0")) continue;
                iServices[2 * i].checkInput(0);
                iServices[2 * i + 1].checkInput(0);
            }
        }
        catch (Exception exception) {
            this.logger.warn("Error while handling input alarms on " + this);
            this.shutdown();
        }
    }

    @Override
    public final void sendStatusService(int nStatusCode) {
    }

    @Override
    public final void notifyForNetworkProblems() {
        this.logger.warn("Error while handling input alarms on " + this);
        this.shutdown();
    }

    @Override
    public final int shutdown() {
        if (this.httpServerPushHandler != null) {
            this.httpServerPushHandler.shutdown();
        }
        return super.shutdown();
    }
}

