/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.norbain;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.norbain.NorbainCameraControl;
import de.seetec.v5.re.cm.device.video.norbain.NorbainDevice;
import de.seetec.v5.re.cm.device.video.norbain.NorbainHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.norbain.NorbainHardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.norbain.NorbainModel;
import de.seetec.v5.re.cm.device.video.norbain.NorbainVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;

public final class NorbainCameraSrv
extends LiveCameraSrv {
    private final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.norbain.NorbainCameraSrv";
    private boolean videoLossEnabled = false;

    @Override
    public final CameraControl createCameraControl(Long entityType) {
        return new NorbainCameraControl();
    }

    @Override
    public final VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        NorbainVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            videoSourceClient = new NorbainVideoSourceClient();
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                if (errorCode == HTTPStatusCode.HTTP_NOT_FOUND.getStatusCode()) {
                    throw new SeeTecException(-21656, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
            if (this.device.getDeviceType() == 204903L && this.getHardwareMotionDetection() == null) {
                boolean motionDetectionDisabled;
                long[] nTypeList = new long[]{9808L};
                Entity[] entities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, nTypeList);
                boolean bl = motionDetectionDisabled = entities.length == 0;
                if (this.videoLossEnabled && motionDetectionDisabled) {
                    this.logger.info("No hardware motion detection entities enabled. Start videoloss for " + this);
                    NorbainHardwareMotionDetectionCnf norbainHardwareMotionDetectionCnf = new NorbainHardwareMotionDetectionCnf();
                    HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf = new HardwareMotionDetectionCnf[]{norbainHardwareMotionDetectionCnf};
                    this.hardwareMotionDetection = new NorbainHardwareMotionDetection();
                    this.hardwareMotionDetection.init(this, hardwareMotionDetectionCnf);
                    this.videoLossEnabled = true;
                    String videoLossEnableUrl = "/event/loss.php?app=get&vloss1_enable=1";
                    byte[] videoLossResult = NetworkHelper.readGetRequest((NetworkParameter)this.device.getDeviceCnf().getNetworkParameter(), (String)"/event/loss.php?app=get&vloss1_enable=1", (int)Integer.MAX_VALUE);
                    this.logger.info((Object)videoLossResult);
                }
            }
        }
        catch (SeeTecException seeTecException) {
            throw seeTecException;
        }
        catch (Throwable throwable) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)throwable, throwable);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public final ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED!");
    }

    public final String getResolutionTag(int width, int height) {
        NorbainDevice norbainDevice = (NorbainDevice)this.getDevice();
        if (norbainDevice.getNorbainModel() == NorbainModel.A) {
            if (width == 704 && (height == 480 || height == 576)) {
                return "4CIF";
            }
            if (width == 704 && (height == 240 || height == 288)) {
                return "2CIF";
            }
            if (width == 352 && (height == 240 || height == 288)) {
                return "CIF";
            }
            if (width == 176 && (height == 120 || height == 144)) {
                return "QCIF";
            }
            if (width == 640 && height == 480) {
                return "VGA";
            }
            if (width == 320 && height == 240) {
                return "QVGA";
            }
            if (width == 160 && height == 120) {
                return "QQVGA";
            }
            return null;
        }
        if (norbainDevice.getNorbainModel() == NorbainModel.B) {
            if (width == 1920 && height == 1080) {
                return "1080P";
            }
            if (width == 1280 && height == 1024) {
                return "SXGA";
            }
            if (width == 1152 && height == 864) {
                return "XGA+";
            }
            if (width == 1280 && height == 960) {
                return "960P";
            }
            if (width == 1280 && height == 720) {
                return "720P";
            }
            if (width == 720 && height == 576) {
                return "576P";
            }
            if (width == 720 && height == 480) {
                return "480P";
            }
            if (width == 640 && height == 480) {
                return "VGA";
            }
            if (width == 320 && height == 240) {
                return "QVGA";
            }
            return null;
        }
        if (norbainDevice.getNorbainModel() == NorbainModel.C) {
            if (width == 1920 && height == 1080) {
                return "1080P";
            }
            if (width == 1280 && height == 1024) {
                return "SXGA";
            }
            if (width == 1280 && height == 720) {
                return "720P";
            }
            if (width == 720 && height == 576) {
                return "576P";
            }
            if (width == 720 && height == 480) {
                return "480P";
            }
            if (width == 640 && height == 480) {
                return "VGA";
            }
            if (width == 352 && height == 288) {
                return "CIFP";
            }
            if (width == 352 && height == 240) {
                return "CIFN";
            }
            if (width == 320 && height == 240) {
                return "QVGA";
            }
            return null;
        }
        return null;
    }

    public final boolean onlyVideoLossEnabled() {
        return this.videoLossEnabled;
    }
}

