/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.mobotix;

import de.seetec.v5.re.cm.DeviceManagerConstantsIntf;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Vector;

public class MobotixCameraControl
extends CameraControl
implements DeviceManagerConstantsIntf {
    static final String CONTENTLENGTH = "Content-Length: ";

    private byte[] int2LittleEndianByteArray(int a) {
        byte[] tempBufferArray = Basic.int4ToByteArray((int)a);
        byte[] ret = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ret[i] = tempBufferArray[3 - i];
        }
        return ret;
    }

    private int sendCameraCommand(String sURL) {
        String sCompleteURL = "/control" + sURL;
        try {
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sCompleteURL, (int)Integer.MIN_VALUE);
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Sending HTTP request [" + sCompleteURL + "] failed with error [" + ex.getErrorCode() + "] :-(");
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    private int sendContinuousCommand(String sCMD, Integer value) {
        if (value != null) {
            return this.sendCameraCommand("?continuous" + sCMD + "move=" + value / 1000);
        }
        return this.sendCameraCommand("?continuous" + sCMD + "move=0");
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        int errorCode = 0;
        StringBuilder sb = new StringBuilder(256);
        try {
            if (pan != null) {
                sb.append("?pan=" + (double)pan.intValue() / 1000.0);
            }
            if (tilt != null) {
                sb.append("&tilt=" + (double)tilt.intValue() / 1000.0);
            }
            if (zoom != null) {
                sb.append("&zoom=" + (zoom - 1) / 10);
            }
            if ((errorCode = this.sendCameraCommand(sb.toString())) != 0) {
                return errorCode;
            }
            errorCode = this.videoSrv.sendStatusAbsolutePTZ(sender, pan, tilt, zoom);
            if (errorCode != 0) {
                this.logger.error("Send HTTP request failed with error [" + errorCode + "] :-(");
                return errorCode;
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        String normalModeCommandString;
        int result = 0;
        result = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        if (result != 0) {
            this.logger.error("Could not initialize Mobotix Camera Control");
            return result;
        }
        long srvType = videoSrv.getEntityType();
        if ((srvType == 210215L || srvType == 210205L || srvType == 210216L || srvType == 210221L || srvType == 210222L || srvType == 210223L || srvType == 210224L || srvType == 210226L || srvType == 210228L || srvType == 210231L || srvType == 210232L) && (result = this.sendCameraCommand(normalModeCommandString = "/control?set&section=imagecontrol&display_mode=lenscorr_l11")) != 0) {
            this.logger.error("Could not set camera to normal mode");
            return result;
        }
        return result;
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        String ptzUrl = "/control/rotorcgi";
        int pan = 0;
        int tilt = 0;
        int zoom = 0;
        if (panSpeed != null) {
            this.previousPanSpeed = pan = panSpeed << 14;
        } else {
            pan = this.previousPanSpeed;
        }
        if (tiltSpeed != null) {
            this.previousTiltSpeed = tilt = tiltSpeed << 14;
        } else {
            tilt = this.previousTiltSpeed;
        }
        if (zoomSpeed != null) {
            this.previousZoomSpeed = zoom = zoomSpeed << 14;
        } else {
            zoom = this.previousZoomSpeed;
        }
        String startSequence = "MxR";
        int protocolVersion = 1;
        int commandTypeMove = 1;
        int commandTypeZoom = 3;
        byte[] startSequenceBytes = startSequence.getBytes();
        byte[] ptCommands = new byte[24];
        System.arraycopy(startSequenceBytes, 0, ptCommands, 0, startSequenceBytes.length);
        ptCommands[3] = 0;
        int arrayPointer = 4;
        byte[] protocolVersionByteArray = this.int2LittleEndianByteArray(protocolVersion);
        System.arraycopy(protocolVersionByteArray, 0, ptCommands, arrayPointer, protocolVersionByteArray.length);
        byte[] commandTypeMoveByteArray = this.int2LittleEndianByteArray(commandTypeMove);
        System.arraycopy(commandTypeMoveByteArray, 0, ptCommands, arrayPointer += 4, commandTypeMoveByteArray.length);
        byte[] xSpeedByteArray = this.int2LittleEndianByteArray(pan);
        System.arraycopy(xSpeedByteArray, 0, ptCommands, arrayPointer += 4, xSpeedByteArray.length);
        byte[] ySpeedByteArray = this.int2LittleEndianByteArray(tilt);
        System.arraycopy(ySpeedByteArray, 0, ptCommands, arrayPointer += 4, ySpeedByteArray.length);
        byte[] param3ByteArray = new byte[]{0, 0, 0, 0};
        System.arraycopy(param3ByteArray, 0, ptCommands, arrayPointer += 4, param3ByteArray.length);
        byte[] zoomCommands = new byte[24];
        System.arraycopy(startSequenceBytes, 0, zoomCommands, 0, startSequenceBytes.length);
        zoomCommands[3] = 0;
        arrayPointer = 4;
        System.arraycopy(protocolVersionByteArray, 0, zoomCommands, arrayPointer, protocolVersionByteArray.length);
        byte[] commandTypeZoomByteArray = this.int2LittleEndianByteArray(commandTypeZoom);
        System.arraycopy(commandTypeZoomByteArray, 0, zoomCommands, arrayPointer += 4, commandTypeZoomByteArray.length);
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>>> Zoom: " + zoom);
        byte[] zoomSpeedByteArray = this.int2LittleEndianByteArray(zoom);
        System.arraycopy(zoomSpeedByteArray, 0, zoomCommands, arrayPointer += 4, zoomSpeedByteArray.length);
        byte[] param2ByteArray = new byte[]{0, 0, 0, 0};
        System.arraycopy(param2ByteArray, 0, zoomCommands, arrayPointer += 4, param2ByteArray.length);
        System.arraycopy(param3ByteArray, 0, zoomCommands, arrayPointer += 4, param3ByteArray.length);
        try {
            if (panSpeed != null || tiltSpeed != null) {
                NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)ptzUrl, (byte[])ptCommands, (boolean)true);
            }
            if (zoomSpeed != null) {
                this.logger.info(">>>>>>>>>>>>>>>>>>>>>>>>>>> Send Camera command: " + ptzUrl + " [" + Basic.byteArrayToHexString((byte[])zoomCommands) + "]");
                NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)ptzUrl, (byte[])zoomCommands, (boolean)true);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Could not send data: " + (Object)((Object)ex));
            this.logger.info("--------------------------------------------");
            return ex.getErrorCode();
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        int errorCode = 0;
        StringBuilder sb = new StringBuilder(256);
        try {
            int[] pos = this.calcCenterPT(xPosition, yPosition, resolution[0], resolution[1]);
            sb.append("/click.cgi?x=" + pos[0] + "&y=" + pos[1] + "&mode=0&rand=" + Tools.random(1, 999999));
            errorCode = this.sendCameraCommand(sb.toString());
            if (errorCode != 0) {
                return errorCode;
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }

    protected final int[] calcCenterPT(Integer x, Integer y, int w, int h) throws SeeTecException {
        if (x == null || x < 0 || x > 100 || y == null || y < 0 || y > 100 || w <= 0 || h <= 0) {
            throw new SeeTecException(-21653, "Invalid CenterPT parameters for " + this.videoSrv + ": x=" + x + ",y=" + y + ",w=" + w + ",h=" + h);
        }
        return new int[]{w * x / 100, h * y / 100};
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoIris(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        return this.sendContinuousCommand("focus", value);
    }

    @Override
    public int setAutoFocus(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setHomePosition() {
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> vResult, Long presetID, String presetName) {
        int presetPosition = -1;
        int result = 0;
        String ptzUrl = "/control/rotorcgi";
        try {
            int i;
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            long nBitVector = 0L;
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                nBitVector |= 1L << Integer.parseInt(presetCnf.getPresetPosition());
            }
            for (i = 1; i <= 64; ++i) {
                if ((nBitVector & 1L << i) != 0L) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            this.logger.info("Creating Preset [" + presetPosition + "]/[" + presetName.trim() + "] ...");
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, encodedPresetName);
            this.presetList.addElement(presetCnf);
            vResult.addElement(presetCnf.getPresetCnf());
            String startSequence = "MxR";
            int protocolVersion = 1;
            int commandTypeSetPosition = 5;
            byte[] startSequenceBytes = startSequence.getBytes();
            byte[] setCommand = new byte[24];
            System.arraycopy(startSequenceBytes, 0, setCommand, 0, startSequenceBytes.length);
            setCommand[3] = 0;
            int arrayPointer = 4;
            byte[] protocolVersionByteArray = this.int2LittleEndianByteArray(protocolVersion);
            System.arraycopy(protocolVersionByteArray, 0, setCommand, arrayPointer, protocolVersionByteArray.length);
            byte[] commandTypeMoveByteArray = this.int2LittleEndianByteArray(commandTypeSetPosition);
            System.arraycopy(commandTypeMoveByteArray, 0, setCommand, arrayPointer += 4, commandTypeMoveByteArray.length);
            byte[] parameter1 = this.int2LittleEndianByteArray(presetPosition);
            System.arraycopy(parameter1, 0, setCommand, arrayPointer += 4, parameter1.length);
            byte[] param2ByteArray = new byte[]{0, 0, 0, 0};
            System.arraycopy(param2ByteArray, 0, setCommand, arrayPointer += 4, param2ByteArray.length);
            byte[] param3ByteArray = new byte[]{0, 0, 0, 0};
            System.arraycopy(param3ByteArray, 0, setCommand, arrayPointer, param3ByteArray.length);
            try {
                NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)ptzUrl, (byte[])setCommand);
            }
            catch (SeeTecException ex) {
                this.logger.error("Could not send data: " + (Object)((Object)ex));
                return ex.getErrorCode();
            }
            String url = "/admin/rcontrol?action=storeconfig";
            if (NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE) == null) {
                this.logger.error("Error storing PTZ position to camera memory");
                return -21654;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Error storing PTZ position to camera memory");
            return -21654;
        }
        catch (ConfigurationException ex) {
            this.logger.error("A configuration exception occured: " + (Object)((Object)ex));
        }
        catch (UnsupportedEncodingException ueex) {
            this.logger.error("An unsopported encoding exception occured: " + ueex);
        }
        return result;
    }

    @Override
    public int setPresetPosition(String presetName) {
        String ptzUrl = "/control/rotorcgi";
        String startSequence = "MxR";
        int protocolVersion = 1;
        int commandTypeShowPosition = 6;
        int presetPosition = 0;
        try {
            String encodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                presetPosition = Integer.parseInt(presetCnf.getPresetPosition());
                byte[] startSequenceBytes = startSequence.getBytes();
                byte[] getPositionCommand = new byte[24];
                System.arraycopy(startSequenceBytes, 0, getPositionCommand, 0, startSequenceBytes.length);
                getPositionCommand[3] = 0;
                int arrayPointer = 4;
                byte[] protocolVersionByteArray = this.int2LittleEndianByteArray(protocolVersion);
                System.arraycopy(protocolVersionByteArray, 0, getPositionCommand, arrayPointer, protocolVersionByteArray.length);
                byte[] commandTypeMoveByteArray = this.int2LittleEndianByteArray(commandTypeShowPosition);
                System.arraycopy(commandTypeMoveByteArray, 0, getPositionCommand, arrayPointer += 4, commandTypeMoveByteArray.length);
                byte[] parameter1 = this.int2LittleEndianByteArray(presetPosition);
                System.arraycopy(parameter1, 0, getPositionCommand, arrayPointer += 4, parameter1.length);
                byte[] param2ByteArray = new byte[]{0, 0, 0, 0};
                System.arraycopy(param2ByteArray, 0, getPositionCommand, arrayPointer += 4, param2ByteArray.length);
                byte[] param3ByteArray = new byte[]{0, 0, 0, 0};
                System.arraycopy(param3ByteArray, 0, getPositionCommand, arrayPointer, param3ByteArray.length);
                try {
                    NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)ptzUrl, (byte[])getPositionCommand);
                    return 0;
                }
                catch (SeeTecException ex) {
                    this.logger.error("Could not send data: " + (Object)((Object)ex));
                    return ex.getErrorCode();
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.error("An encoding exception occured: " + ex);
        }
        catch (ConfigurationException confEx) {
            this.logger.error("A configuration exception occured: " + (Object)((Object)confEx));
        }
        return 0;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            String sEncodedPresetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!sEncodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.logger.info("Removing preset: " + new String(presetCnf.getPresetCnf()));
                this.presetList.removeElementAt(i);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error("Removing preset [" + presetName + "] failed :-(", (Throwable)ex);
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available :-(");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }
}

