/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.lg;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.video.lg.LGCameraSrv;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import org.apache.logging.log4j.LogManager;

public class LGMotionDetectionHandler
extends MotionDetectionHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.lg.LGMotionDetectionHandler";
    private Thread myThread = null;
    private static final int INTERVAL = 500;
    private NetworkParameter networkParameter = null;
    private long lastVideoLossEventSent = 0L;

    public LGMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        try {
            this.networkParameter = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }
        catch (Exception e) {
            this.logger.error("Problem while initiating MotionDetectionHandler for " + this.listener.getVideoSrv());
            this.logger.error((Object)e, (Throwable)e);
            return -21656;
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        super.shutdown();
        return 0;
    }

    @Override
    public final void run() {
        super.setRunFinished(CLASS_NAME, false);
        long time = System.currentTimeMillis();
        try {
            String motionDetectionUrl = "/alarm?Check&type=Motion";
            while (!this.isShutdown(CLASS_NAME)) {
                if (System.currentTimeMillis() - time < 500L) {
                    Thread.sleep(500L + time - System.currentTimeMillis());
                }
                if (this.isShutdown(CLASS_NAME)) continue;
                if (!((LGCameraSrv)this.listener.getVideoSrv()).onlyVideoLossEnabled()) {
                    time = System.currentTimeMillis();
                    byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/alarm?Check&type=Motion", (int)Integer.MAX_VALUE);
                    String motionDetectionResponseString = new String(result);
                    String[] motionDetectionParameterList = motionDetectionResponseString.split(new String(CRLF_BYTE));
                    for (int i = 0; i < motionDetectionParameterList.length; ++i) {
                        String[] parameterLine = motionDetectionParameterList[i].toLowerCase().split(":");
                        if (parameterLine.length != 2 || !parameterLine[0].startsWith("motiondetection")) continue;
                        int area = Integer.parseInt(parameterLine[0].substring("motiondetection".length()));
                        if (!parameterLine[1].startsWith("h")) continue;
                        this.listener.evaluateWindow(area);
                    }
                }
                if (this.listener.getVideoSrv().getDevice().getDeviceType() != 203908L || !this.listener.getVideoSrv().getVideoSourceCnf().isEnableVideoloss()) continue;
                String videoLossUrl = "/alarm?Check&type=VideoLoss";
                byte[] result2 = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/alarm?Check&type=VideoLoss", (int)Integer.MAX_VALUE);
                String videoLossresponseString = new String(result2);
                String[] videoLossparameterList = videoLossresponseString.split(new String(CRLF_BYTE));
                for (int i = 0; i < videoLossparameterList.length; ++i) {
                    String[] parameterLine = videoLossparameterList[i].toLowerCase().split(":");
                    if (parameterLine.length != 2 || !parameterLine[0].startsWith("videoloss") || !parameterLine[1].startsWith("h") || System.currentTimeMillis() <= this.lastVideoLossEventSent + 5000L) continue;
                    this.lastVideoLossEventSent = System.currentTimeMillis();
                    this.listener.getVideoSrv().getCore().sendVideoLossEvent(this.listener.getVideoSrv());
                }
            }
        }
        catch (Throwable throwable) {
            if (this.listener != null) {
                this.logger.warn("Exception for " + this.listener.getVideoSrv());
            }
            this.logger.error("Problems while checking for motion detection", throwable);
            this.shutdown();
        }
    }

    public void notifyForNetworkProblems() {
        this.logger.info("Network problem signaled for " + this.listener.getVideoSrv());
    }
}

