/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.lg;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.lg.LGCameraControl;
import de.seetec.v5.re.cm.device.video.lg.LGHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.lg.LGHardwareMotionDetectionCnf;
import de.seetec.v5.re.cm.device.video.lg.LGVideoSourceClient;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.SeeTecException;

public class LGCameraSrv
extends LiveCameraSrv {
    private LGHardwareMotionDetection lgHardwareMotionDetection = null;
    private boolean videoLossEnabled = false;

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new LGCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        LGVideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            videoSourceClient = new LGVideoSourceClient();
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                if (errorCode == HTTPStatusCode.HTTP_NOT_FOUND.getStatusCode()) {
                    throw new SeeTecException(-21656, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
                }
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
            if (this.device.getDeviceType() == 203908L && this.getHardwareMotionDetection() == null) {
                boolean motionDetectionDisabled;
                long[] nTypeList = new long[]{9808L};
                Entity[] entities = this.device.getEnabledEntities(new long[]{this.getEntityID()}, nTypeList);
                boolean bl = motionDetectionDisabled = entities.length == 0;
                if (!this.videoLossEnabled && motionDetectionDisabled) {
                    this.logger.info("No hardware motion detection entities enabled. Start videoloss for " + this);
                    LGHardwareMotionDetectionCnf lgHardwareMotionDetectionCnf = new LGHardwareMotionDetectionCnf();
                    HardwareMotionDetectionCnf[] hardwareMotionDetectionCnf = new HardwareMotionDetectionCnf[]{lgHardwareMotionDetectionCnf};
                    this.lgHardwareMotionDetection = new LGHardwareMotionDetection();
                    this.lgHardwareMotionDetection.init(this, hardwareMotionDetectionCnf);
                    this.videoLossEnabled = true;
                }
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public final boolean onlyVideoLossEnabled() {
        return this.videoLossEnabled;
    }
}

