/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.lg;

import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.URLEncoder;
import java.util.Vector;

public class LGCameraControl
extends CameraControl {
    private boolean ptCommandSent = false;
    private boolean zCommandSent = false;
    private boolean isStopCommand = false;

    private int sendCameraCommand(String url) {
        try {
            this.videoSrv.notifyForCameraControl();
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE);
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousPTZ(Integer panSpeed, Integer tiltSpeed, Integer zoomSpeed) {
        long interval = 200L;
        int pan = panSpeed != null ? panSpeed * 5 / 100000 * 20 : this.previousPanSpeed;
        int tilt = tiltSpeed != null ? tiltSpeed * 5 / 100000 * 20 : this.previousTiltSpeed;
        int zoom = zoomSpeed != null ? zoomSpeed * 5 / 100000 * 20 : this.previousZoomSpeed;
        String moveCommand = "";
        if (pan == 0 && tilt > 0) {
            moveCommand = "up";
        } else if (pan == 0 && tilt < 0) {
            moveCommand = "down";
        } else if (pan < 0 && tilt == 0) {
            moveCommand = "left";
        } else if (pan > 0 && tilt == 0) {
            moveCommand = "right";
        } else if (pan < 0 && tilt > 0) {
            moveCommand = "upleft";
        } else if (pan > 0 && tilt > 0) {
            moveCommand = "upright";
        } else if (pan < 0 && tilt < 0) {
            moveCommand = "downleft";
        } else if (pan > 0 && tilt < 0) {
            moveCommand = "downright";
        } else if (pan == 0 && tilt == 0) {
            moveCommand = "stop";
        }
        double movespeed = Math.abs(pan) > Math.abs(tilt) ? (double)Math.abs(pan) : (double)Math.abs(tilt);
        if (this.isInverted(pan, this.previousPanSpeed) || this.isInverted(tilt, this.previousTiltSpeed) || this.isInverted(zoom, this.previousZoomSpeed)) {
            this.ptCommandSent = false;
        }
        if (pan == 0 && tilt == 0 && !this.isStopCommand) {
            String command = "/httpapi?ControlPTZ&channel=0&Parameter_T=movespeed:60/move:stop";
            this.sendCameraCommand("/httpapi?ControlPTZ&channel=0&Parameter_T=movespeed:60/move:stop");
            this.previousPanSpeed = 0;
            this.previousTiltSpeed = 0;
            this.ptCommandSent = false;
            this.isStopCommand = true;
        } else if (!this.ptCommandSent) {
            long time1 = System.currentTimeMillis();
            if (pan != this.previousPanSpeed || tilt != this.previousTiltSpeed) {
                String command = "/httpapi?ControlPTZ&channel=0&Parameter_T=movespeed:" + (int)movespeed + "/move:" + moveCommand;
                this.sendCameraCommand(command);
                this.ptCommandSent = true;
                this.previousPanSpeed = pan;
                this.previousTiltSpeed = tilt;
                this.isStopCommand = false;
                long time2 = System.currentTimeMillis();
                final long timeStep = time2 - time1;
                if (timeStep < 200L) {
                    new Thread(new Runnable(){

                        @Override
                        public final void run() {
                            try {
                                Thread.sleep(200L - timeStep);
                                LGCameraControl.this.ptCommandSent = false;
                            }
                            catch (Exception exception) {
                                LGCameraControl.this.logger.debug("Error while sleeping.");
                            }
                        }
                    }, "LG CameraControl Pan/Tilt Waiting thread for " + this.videoSrv).start();
                } else {
                    this.ptCommandSent = false;
                }
            }
        }
        String zoomCommand = "";
        zoomCommand = zoom > 0 ? "in" : (zoom < 0 ? "out" : "stop");
        zoom = Math.abs(zoom);
        if (zoom == 0 && this.previousZoomSpeed != 0) {
            String command = "/httpapi?ControlPTZ&channel=0&Parameter_T=zoomspeed:3/zoom:stop";
            this.sendCameraCommand("/httpapi?ControlPTZ&channel=0&Parameter_T=zoomspeed:3/zoom:stop");
            this.zCommandSent = false;
            this.previousZoomSpeed = 0;
        } else if (!this.zCommandSent && zoom != 0 && zoom != this.previousZoomSpeed) {
            long time1 = System.currentTimeMillis();
            String command = "/httpapi?ControlPTZ&channel=0&Parameter_T=zoomspeed:" + zoom + "/zoom:" + zoomCommand;
            this.sendCameraCommand(command);
            this.zCommandSent = true;
            this.previousZoomSpeed = zoom;
            long time2 = System.currentTimeMillis();
            final long timeStep = time2 - time1;
            if (timeStep < 200L) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(200L - timeStep);
                            LGCameraControl.this.zCommandSent = false;
                        }
                        catch (Exception exception) {
                            LGCameraControl.this.logger.debug("Error while sleeping.");
                        }
                    }
                }, "LG CameraControl Zoom Waiting thread for " + this.videoSrv).start();
            } else {
                this.zCommandSent = false;
            }
        }
        return 0;
    }

    private boolean isInverted(int x, int y) {
        return x * y < 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (value != null) {
            String url = "/httpapi?ControlPTZ&channel=0&Parameter_T=iris:";
            if (value > 0) {
                this.sendCameraCommand(url + "open");
            } else if (value < 0) {
                this.sendCameraCommand(url + "close");
            } else {
                this.sendCameraCommand(url + "stop");
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (value != null) {
            String url = "/httpapi?ControlPTZ&channel=0&Parameter_T=focusspeed:" + value / 1000 + "/focus:";
            if (value > 0) {
                this.sendCameraCommand(url + "far");
            } else if (value < 0) {
                this.sendCameraCommand(url + "near");
            } else {
                this.sendCameraCommand(url + "stop");
            }
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        return 0;
    }

    @Override
    public int setHomePosition() {
        this.sendCameraCommand("/httpapi?GotoPreset&channel=0&alias=HOME");
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        int presetPosition = -1;
        try {
            int i;
            byte[] assignedPositions = new byte[10];
            for (i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                assignedPositions[Integer.parseInt((String)presetCnf.getPresetPosition())] = 1;
            }
            for (i = 1; i <= assignedPositions.length; ++i) {
                if (assignedPositions[i] != 0) continue;
                presetPosition = i;
                break;
            }
            if (presetPosition < 0) {
                this.logger.error("Cannot add preset [" + presetName + "], 'cause no more free preset positions are available for " + this + " :-(");
                return -21600;
            }
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            PresetCnf presetCnf = PresetCnf.createPresetCnf(presetID, "" + presetPosition, presetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
            String alias = this.getPresetAlias("" + presetPosition, presetName);
            this.sendCameraCommand("/httpapi?AddPreset&channel=" + channelNo + "&alias=" + alias + "&sequence=" + presetPosition + "&presetSpeed=50&parkTime=1");
            return 0;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Adding preset [" + presetName + "] failed");
            return -21600;
        }
    }

    @Override
    public int setPresetPosition(String presetName) {
        try {
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                String presetPosition = presetCnf.getPresetPosition();
                this.logger.info("GOTO Preset: " + presetName + " has position: " + presetPosition);
                int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                String alias = this.getPresetAlias(presetPosition, presetName);
                this.sendCameraCommand("/httpapi?GotoPreset&channel=" + channelNo + "&alias=" + alias);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Setting preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    @Override
    public int removePresetPosition(String presetName) {
        try {
            presetName = URLEncoder.encode(presetName.trim(), "UTF-8");
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!presetName.equals(presetCnf.getPresetName())) continue;
                String presetPosition = presetCnf.getPresetPosition();
                this.presetList.removeElementAt(i);
                int channelNo = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
                String alias = this.getPresetAlias(presetPosition, presetName);
                this.sendCameraCommand("/httpapi?RemovePreset&channel=" + channelNo + "&alias=" + alias);
                return 0;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed");
            return -21600;
        }
        this.logger.error("Preset [" + presetName + "] not available");
        this.logger.error("PresetList=" + this.presetList);
        return -21683;
    }

    protected final String getPresetAlias(String presetPosition, String presetName) {
        return this.getPresetAlias(this.videoSrv.getDevice().getDeviceType(), presetPosition, presetName);
    }

    protected final String getPresetAlias(long type, String presetPosition, String presetName) {
        if (type == 203907L) {
            return presetPosition;
        }
        return presetName;
    }
}

