/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jvc.jpeg;

import de.seetec.v5.re.cm.device.shared.net.HttpPersistentConnectionHandler;
import de.seetec.v5.re.cm.device.shared.net.HttpPersistentConnectionListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class JVCJPEGVideoSourceClient_C655
extends JPEGVideoSourceClient
implements HttpPersistentConnectionListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.jvc.jpeg.JVCJPEGVideoSourceClient_C655";
    private HttpPersistentConnectionHandler httpPersistentConnectionHandler = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        int errorCode = 0;
        try {
            errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("/ConfigType1.cgi?");
            this.quality /= 14286;
            ++this.quality;
            this.quality = this.quality > 7 ? 7 : this.quality;
            this.quality = this.quality < 1 ? 1 : this.quality;
            switch (this.quality) {
                case 1: {
                    this.quality = 34;
                    break;
                }
                case 2: {
                    this.quality = 36;
                    break;
                }
                case 3: {
                    this.quality = 40;
                    break;
                }
                case 4: {
                    this.quality = 22;
                    break;
                }
                case 5: {
                    this.quality = 24;
                    break;
                }
                case 6: {
                    this.quality = 5;
                    break;
                }
                default: {
                    this.quality = 8;
                }
            }
            sb.append("Quality=");
            sb.append(this.quality);
            sb.append("&Xsize=");
            sb.append(this.width);
            sb.append("&Ysize=");
            sb.append(this.height);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE, (boolean)true, null, (boolean)true);
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (SeeTecException se) {
            this.logger.error("Setting/adjusting parameters from " + this.getVideoSrv().getDevice() + " failed", (Throwable)se);
            if (se.getErrorCode() == -21657) {
                return -21657;
            }
            return se.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return errorCode;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            this.networkParameter = super.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter();
        }
        catch (ConfigurationException ex) {
            this.logger.error("Exception while retrieveing network parameters for " + this + ": " + ex.getMessage());
        }
        this.networkParameter.setSoTimeout(5000);
        this.httpPersistentConnectionHandler = new HttpPersistentConnectionHandler();
        String url = "/java.jpg";
        int frameInterval = (int)(1000000L / this.highestFramerate);
        this.httpPersistentConnectionHandler.init(this, this.networkParameter, url, frameInterval);
        int errorCode = this.httpPersistentConnectionHandler.startPersistentConnection(false);
        if (errorCode != 0) {
            this.logger.warn("Persistent HTTP connection " + this.httpPersistentConnectionHandler + " terminated with error [" + errorCode + "]");
            errorCode = errorCode == -21657 ? -21657 : errorCode;
            this.listener.sendStatusService(errorCode);
        }
        this.httpPersistentConnectionHandler.shutdown();
        this.logger.info("End grabbing images for " + this);
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public void deliverContent(byte[] httpPersistentConnectionContent) {
        super.deliverContent(httpPersistentConnectionContent);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.httpPersistentConnectionHandler != null) {
            this.httpPersistentConnectionHandler.shutdown();
        }
        this.httpPersistentConnectionHandler = null;
        return super.shutdown();
    }
}

