/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jvc;

import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.apache.logging.log4j.LogManager;

public class JVCMotionDetectionHandler
extends MotionDetectionHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.jvc.JVCMotionDetectionHandler";
    private Thread myThread = null;
    private String host = null;
    private int port = Integer.MIN_VALUE;
    private Socket socket = null;
    private InputStream is = null;
    private boolean isNetworkProblemSignaled = false;

    public JVCMotionDetectionHandler() {
        this.logger = LogManager.getLogger((String)CLASS_NAME);
    }

    @Override
    public int init(HardwareMotionDetection<? extends MotionDetectionHandler> hardwareMotionDetection) {
        this.listener = hardwareMotionDetection;
        if (this.listener == null) {
            return -20003;
        }
        if (this.listener.getVideoSrv().getDevice().getDeviceEntity().getEntityType() == 200314L) {
            return 0;
        }
        try {
            this.host = this.listener.getVideoSrv().getDevice().getDeviceCnf().getNetworkParameter().getHost();
            if (this.host == null) {
                this.logger.error("Host is null for " + this.listener.getVideoSrv());
                return -20002;
            }
        }
        catch (Exception e) {
            this.logger.error("Host is null for " + this.listener.getVideoSrv());
            return -20002;
        }
        this.port = 32040;
        try {
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
        }
        catch (Exception e) {
            this.logger.error("Problem while initiating socket to: " + this.host + ":" + this.port + " for " + this.listener.getVideoSrv(), (Throwable)e);
            return -21656;
        }
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.host = null;
        super.shutdown();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (true) {
                if (this.isShutdown(CLASS_NAME)) {
                    super.setRunFinished(CLASS_NAME, true);
                    this.shutdown();
                    return;
                }
                try {
                    this.socket = new Socket(this.host, this.port);
                    this.socket.setSoTimeout(100);
                    this.is = this.socket.getInputStream();
                    this.isNetworkProblemSignaled = false;
                    block15: while (!this.isShutdown(CLASS_NAME) && !this.isNetworkProblemSignaled) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception ex) {
                            this.logger.error("Problem while sleeping: " + ex, (Throwable)ex);
                        }
                        if (this.isShutdown(CLASS_NAME) || this.isNetworkProblemSignaled) break;
                        try {
                            int len;
                            byte[] buffer;
                            block19: {
                                buffer = new byte[4096];
                                len = -1;
                                try {
                                    len = this.is.read(buffer);
                                    if (len >= 0) break block19;
                                    break;
                                }
                                catch (SocketTimeoutException ste) {
                                    continue;
                                }
                            }
                            byte[] result = new byte[len];
                            System.arraycopy(buffer, 0, result, 0, result.length);
                            String[] splittedResult = new String(result).split("\r\n");
                            for (int i = 0; i < splittedResult.length; ++i) {
                                if (splittedResult[i].indexOf("detection(motion).status=on") == -1) continue;
                                this.listener.evaluateWindow(0);
                                continue block15;
                            }
                        }
                        catch (Throwable t) {
                            if (this.isShutdown(CLASS_NAME)) continue;
                            this.logger.warn("Exception for " + this.listener.getVideoSrv(), t);
                            break;
                        }
                    }
                }
                catch (Throwable ex) {
                    this.logger.error("Error accessing: " + this.host + ":" + this.port + "  for " + this.listener.getVideoSrv() + ". Message: " + ex.getMessage());
                    try {
                        Thread.sleep(7000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    if (this.socket == null) continue;
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException ioex) {
                    this.logger.error("Error closing port: " + this.host + ":" + this.port + " for " + this.listener.getVideoSrv(), (Throwable)ioex);
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Exception for " + this.listener.getVideoSrv());
            this.logger.fatal((Object)ex, ex);
            this.shutdown();
        }
    }

    public void notifyForNetworkProblems() {
        this.logger.info("Network problem signaled for " + this.listener.getVideoSrv());
        this.isNetworkProblemSignaled = true;
    }
}

