/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.jpegemulator;

import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperJpeg;
import de.seetec.v5.re.cm.filesystemwatcher.FileSystemListener;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class JPEGEmulatorVideoSourceClient
extends JPEGVideoSourceClient
implements FileSystemListener {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.jpegemulator.JPEGEmulatorVideoSourceClient";
    private long timestampOfLastImage = Long.MIN_VALUE;
    private long timeout = Long.MIN_VALUE;
    private String alias = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        try {
            this.logger.info("init started for" + this.getVideoSrv());
            int errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            this.timeout = this.listener.getLiveCameraSrv().getDevice().getDeviceCnf().getNetworkParameter().getSoTimeout();
            this.alias = this.listener.getVideoSourceParameter().getStreamAlias();
            if (this.alias == null) {
                return -20002;
            }
            errorCode = this.getCore().getFileSystemWatcherServer().register(this, FileSystems.getDefault().getPath(this.host, new String[0]), this.alias);
            if (errorCode != 0) {
                this.logger.error("Error while registering at FileSystemWatcher. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            this.timestampOfLastImage = System.currentTimeMillis();
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        try {
            this.getCore().getFileSystemWatcherServer().deregister(this, FileSystems.getDefault().getPath(this.host, new String[0]));
        }
        catch (InterruptedException ex) {
            this.logger.warn("Deregistering from FileSystemWatcher not possible. Go on...");
        }
        return super.shutdown();
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        while (!this.isShutdown()) {
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException ie) {
                this.logger.warn("I hate it to get interrupted when I'm sleeping!");
            }
            if (!this.isTimedout(this.timeout)) continue;
            this.logger.warn("Last image received at " + new Date(this.timestampOfLastImage).toString() + " for " + this);
            this.listener.sendStatusService(-20008);
            super.getListener().notifyForNetworkProblems();
            try {
                this.getVideoSrv().getDevice().sendCannotEstablishConnectionLoggingEvent(-20008);
            }
            catch (ConfigurationException ex) {
                this.logger.error("Cannot send logging event for " + this);
            }
            this.shutdown();
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private boolean isTimedout(long timeout) {
        return this.timestampOfLastImage > 0L && System.currentTimeMillis() > this.timestampOfLastImage + timeout;
    }

    @Override
    public void nofify(Path file, byte[] content) {
        try {
            if (StreamingHelperJpeg.isJpeg(content)) {
                this.timestampOfLastImage = System.currentTimeMillis();
                this.deliverContent(content);
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Can't process received content for " + this);
        }
    }

    @Override
    public void error(Path file, int error, String description) {
        this.logger.error(String.format("Got error for '%s'. Error '%s' has description '%s' for %s", file, error, description, this));
        this.listener.sendStatusService(error);
        super.getListener().notifyForNetworkProblems();
        this.shutdown();
    }
}

