/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqle;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.iqle.IqleCameraSrv;
import de.seetec.v5.re.cm.device.video.iqle.IqleDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class IqleVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqle.DahuaVideoSourceClient";
    private static final int CAPS = 2;
    private int streamNumber;
    private IqleDevice iqleDevice;
    private String streamName;
    private int channelID;
    private String cameraConfiguration;

    @Override
    public int init() {
        try {
            boolean isIFrameDistanceSet;
            boolean isQualitySet;
            boolean isBitrateControlEnabled;
            int bitrate;
            boolean isVideoEnabled;
            this.printDebug = false;
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.iqleDevice = (IqleDevice)((IqleCameraSrv)this.getVideoSrv()).getDevice();
            this.channelID = this.videoSourceNr - 1;
            this.resolutionTag = this.iqleDevice.getResolutionTag(this.width, this.height);
            int videoProfileID = this.listener.getDynamicVideoProfileID();
            this.errorCode = ((IqleCameraSrv)this.getVideoSrv()).handleChannelParameters(this.channelID, this.title, this.useTitle, this.useDateTime, this.resolutionTag, this.networkParameter, videoProfileID);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting channel parameters for " + this.getVideoSrv() + ": " + this.errorCode);
                return this.errorCode;
            }
            this.cameraConfiguration = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/cgi-bin/configManager.cgi?action=getConfig&name=Encode", (int)Integer.MAX_VALUE, (boolean)false));
            this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, (int)this.fps / 1000, 150);
            if (this.iqleDevice == null) {
                this.iqleDevice = (IqleDevice)this.getVideoSrv().getDevice();
            }
            this.streamNumber = ((IqleCameraSrv)this.getVideoSrv()).getStreamNumber(videoProfileID);
            if (this.streamNumber == -1) {
                this.logger.error("Error while selecting stream number for " + this);
                return -20001;
            }
            this.streamName = this.streamNumber == 0 ? "MainFormat[0]" : "ExtraFormat[0]";
            boolean isVideoCodecSet = false;
            String[] parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.Compression");
            if (parametersOnCamera.length == 1) {
                isVideoCodecSet = this.videoCodec == Codec.H264 ? parametersOnCamera[0].equals("h.264") : parametersOnCamera[0].equals("mjpg");
            }
            parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".VideoEnable");
            boolean bl = isVideoEnabled = this.streamNumber == 1 && parametersOnCamera.length == 1 && parametersOnCamera[0].equals("true");
            if (this.streamNumber == 0) {
                isVideoEnabled = true;
            }
            boolean isResolutionEnabled = (parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.Height")).length == 1 && parametersOnCamera[0].equals("" + this.height);
            parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.Width");
            isResolutionEnabled &= parametersOnCamera.length == 1 && parametersOnCamera[0].equals("" + this.width);
            parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".AudioEnable");
            boolean isAudioSet = parametersOnCamera.length == 1 && this.isAudioEnabled && parametersOnCamera[0].equals("true") || !this.isAudioEnabled && parametersOnCamera[0].equals("false");
            StringBuilder url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig");
            String header = "&Encode[" + this.channelID + "]." + this.streamName + ".";
            if (!isVideoCodecSet) {
                url.append(header);
                url.append("Video.Compression=");
                url.append(this.videoCodec == Codec.H264 ? "H.264" : "MJPG");
            }
            if (!isVideoEnabled) {
                url.append(header);
                url.append("VideoEnable=true");
            }
            if (!isResolutionEnabled) {
                url.append(header);
                url.append("Video.Width=");
                url.append(this.width);
                url.append(header);
                url.append("Video.Height=");
                url.append(this.height);
            }
            if (!isAudioSet) {
                url.append(header).append("AudioEnable=");
                url.append(this.isAudioEnabled ? "true" : "false");
            }
            if (!(isAudioSet && isResolutionEnabled && isVideoCodecSet && isVideoEnabled)) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true);
            }
            url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig");
            this.fps /= 1000L;
            try {
                boolean isFramerateSet;
                String[] framerateLimit = this.iqleDevice.getCaps(this.networkParameter, 2, "caps.caps[" + this.channelID + "]." + this.streamName + ".Video.FPSMax");
                int fpsMax = 25;
                if (framerateLimit.length == 1) {
                    fpsMax = Integer.parseInt(framerateLimit[0]);
                }
                this.fps = this.fps < 1L ? 1L : this.fps;
                this.fps = this.fps > (long)fpsMax ? (long)fpsMax : this.fps;
                parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.FPS");
                boolean bl2 = isFramerateSet = parametersOnCamera.length == 1 && parametersOnCamera[0].equals("" + this.fps);
                if (!isFramerateSet) {
                    url.append(header);
                    url.append("Video.FPS=");
                    url.append(this.fps);
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true);
                }
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while getting Framerate capabilities for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
            url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig");
            String[] bitrateLimits = this.iqleDevice.getCaps(this.networkParameter, 2, "caps.caps[" + this.channelID + "]." + this.streamName + ".Video.BitRateOptions");
            int lowerBitrateLimit = 0;
            int upperBitrateLimit = 4096;
            if (bitrateLimits.length == 2) {
                lowerBitrateLimit = Integer.parseInt(bitrateLimits[0]);
                upperBitrateLimit = Integer.parseInt(bitrateLimits[1]);
            }
            bitrate = (bitrate = this.bandwidth / 1024) < lowerBitrateLimit ? lowerBitrateLimit : bitrate;
            bitrate = bitrate > upperBitrateLimit ? upperBitrateLimit : bitrate;
            parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.BitRate");
            boolean isBitrateEnabled = parametersOnCamera.length == 1 && parametersOnCamera[0].equals("" + bitrate);
            parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.BitRateControl");
            boolean bl3 = isBitrateControlEnabled = parametersOnCamera.length == 1 && this.isConstantBitrateUsed && parametersOnCamera[0].equals("cbr") || !this.isConstantBitrateUsed && parametersOnCamera[0].equals("vbr");
            if (this.videoCodec == Codec.H264) {
                this.quality = this.quality / 16000 + 1;
                this.quality = this.quality > 6 ? 6 : this.quality;
                parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.Quality");
                isQualitySet = parametersOnCamera.length == 1 && parametersOnCamera[0].equals("" + this.quality);
            } else {
                isQualitySet = true;
            }
            parametersOnCamera = IqleDevice.getParameterValues(this.cameraConfiguration, "table.Encode[" + this.channelID + "]." + this.streamName + ".Video.GOP");
            boolean bl4 = isIFrameDistanceSet = parametersOnCamera.length == 1 && parametersOnCamera[0].equals("" + this.iFrameDist);
            if (this.videoCodec == Codec.H264) {
                if (this.isConstantBitrateUsed) {
                    if (!isBitrateControlEnabled) {
                        url.append(header);
                        url.append("Video.BitRateControl=CBR");
                    }
                    if (!isBitrateEnabled) {
                        url.append(header);
                        url.append("Video.BitRate=");
                        url.append(bitrate);
                    }
                } else {
                    if (!isBitrateControlEnabled) {
                        url.append(header);
                        url.append("Video.BitRateControl=VBR");
                    }
                    if (!isQualitySet) {
                        url.append(header);
                        url.append("Video.Quality=");
                        url.append(this.quality);
                    }
                }
                if (!isIFrameDistanceSet) {
                    url.append(header);
                    url.append("Video.GOP=");
                    url.append(this.iFrameDist);
                }
                if (this.isConstantBitrateUsed && !isBitrateEnabled || !this.isConstantBitrateUsed && !isQualitySet || !isBitrateControlEnabled || !isIFrameDistanceSet) {
                    NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true);
                }
            }
            this.rtspUrl = "rtsp://" + this.getHost() + "/cam/realmonitor?channel=" + this.videoSourceNr + "&subtype=" + this.streamNumber;
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1);
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing RTSP settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initialization for " + this, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }
}

