/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqle;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.iqle.IqleDevice;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class IqleIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqle.IqleIOHandler";
    private byte[] result;

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean previousLoopWithError = false;
            DigitalInputSrv[] iServices = super.getDigitalInputSrv();
            for (int i = 0; i < iServices.length; ++i) {
                String url = "/cgi-bin/configManager.cgi?action=setConfig&Alarm[" + i + "].Enable=true";
                this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            }
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (previousLoopWithError) {
                        previousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] digitalInputSrvArray = iServices;
                        int n = digitalInputSrvArray.length;
                        for (int i = 0; i < n; ++i) {
                            DigitalInputSrv iService = digitalInputSrvArray[i];
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(iService.getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    previousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().contains("Address already in use")) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        for (DigitalInputSrv iService : iServices) {
                            if (!iService.getEntity().isEnabled().booleanValue()) continue;
                            iService.publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Reading digital inputs of " + this + " ...");
        }
        for (int i = 0; i < iServices.length / 2; ++i) {
            String url = "/cgi-bin/alarm.cgi?action=getInStates";
            this.result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
            String[] ioLines = IqleDevice.getParameterValues(new String(this.result), "result");
            if (ioLines.length != 1) continue;
            int ioData = Integer.parseInt(ioLines[0]);
            if ((double)(ioData & (int)Math.pow(2.0, i)) == Math.pow(2.0, i)) {
                iServices[2 * i].checkInput(1);
                iServices[2 * i + 1].checkInput(1);
                continue;
            }
            iServices[2 * i].checkInput(0);
            iServices[2 * i + 1].checkInput(0);
        }
        return 0;
    }

    @Override
    public int writeDigitalOutput(int outputNumber, int value, long holdTime) {
        DigitalOutputSrv service = super.getDigitalOutputSrv(outputNumber);
        if (service == null) {
            this.logger.error(this + " has no digital output service configured for [" + outputNumber + "] ");
            return -21601;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this);
            return -21601;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + outputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            StringBuilder url = new StringBuilder("/cgi-bin/configManager.cgi?action=setConfig&AlarmOut[" + (outputNumber - 1) + "].Mode=");
            if (value == 0) {
                url.append("2");
            } else {
                url.append("1");
            }
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE, (boolean)true);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(outputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [ " + errorCode + " ] :-( ");
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while writing digital output for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        return 0;
    }
}

