/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqle;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.iqle.IqleIOHandler;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class IqleDevice
extends VideoServer {
    private static final int VIDEOSTANDARD = 1;
    private static final int CAPS = 2;
    private static final int VIDEOWIDGET = 3;
    private static final int TITLE = 4;
    private int streamSet;
    private int minBitrate;
    private int maxBitrate;
    private String videoStandard = null;
    private String caps = null;
    private String videoWidget = null;
    private String title = null;

    @Override
    protected IOHandler createIOHandler() {
        return new IqleIOHandler();
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    public int getStreamSet() {
        return this.streamSet;
    }

    public void setStreamSet(int streamSet) {
        this.streamSet = streamSet;
    }

    public void setModelInformation(int width, int height) {
        if (width == 352) {
            this.minBitrate = 192;
            this.maxBitrate = 1024;
        } else if (width == 704) {
            this.minBitrate = 768;
            this.maxBitrate = 4096;
        } else if (width == 1280) {
            if (height == 720) {
                this.minBitrate = 1024;
                this.maxBitrate = 6144;
            } else if (height == 960) {
                this.minBitrate = 1280;
                this.maxBitrate = 8192;
            } else {
                this.minBitrate = 1536;
                this.maxBitrate = 8192;
            }
        } else if (width == 1920) {
            this.minBitrate = 2048;
            this.maxBitrate = 8192;
        } else {
            this.minBitrate = 3584;
            this.maxBitrate = 8192;
        }
    }

    int[] getBitrateLimits(int width, int height) {
        int[] ret = new int[]{this.minBitrate, this.maxBitrate};
        return ret;
    }

    public String[] getCaps(NetworkParameter networkParameter, int parameterGroup, String parameterName) throws SeeTecException {
        return this.getCaps(networkParameter, parameterGroup, parameterName, true);
    }

    public String[] getCaps(NetworkParameter networkParameter, int parameterGroup, String parameterName, boolean readFromCamera) throws SeeTecException {
        String url = "";
        switch (parameterGroup) {
            case 1: {
                url = "/cgi-bin/configManager.cgi?action=getConfig&name=VideoStandard";
                break;
            }
            case 2: {
                url = "/cgi-bin/encode.cgi?action=getConfigCaps";
                break;
            }
            case 3: {
                url = "/cgi-bin/configManager.cgi?action=getConfig&name=VideoWidget";
                break;
            }
            case 4: {
                url = "/cgi-bin/configManager.cgi?action=getConfig&name=ChannelTitle";
                break;
            }
        }
        String responseString = null;
        if (!readFromCamera) {
            switch (parameterGroup) {
                case 1: {
                    responseString = this.videoStandard;
                    break;
                }
                case 2: {
                    responseString = this.caps;
                    break;
                }
                case 3: {
                    responseString = this.videoWidget;
                    break;
                }
                case 4: {
                    responseString = this.title;
                    break;
                }
            }
        }
        if (responseString == null || readFromCamera) {
            responseString = new String(NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true));
            switch (parameterGroup) {
                case 1: {
                    this.videoStandard = responseString;
                    break;
                }
                case 2: {
                    this.caps = responseString;
                    break;
                }
                case 3: {
                    this.videoWidget = responseString;
                    break;
                }
                case 4: {
                    this.title = responseString;
                    break;
                }
            }
        }
        return IqleDevice.getParameterValues(responseString, parameterName);
    }

    public String getResolutionTag(int width, int height) {
        switch (width) {
            case 160: {
                return "qqvga";
            }
            case 176: {
                return "qcif";
            }
            case 240: {
                return "nd1";
            }
            case 320: {
                return "qvga";
            }
            case 352: {
                if (height == 288 || height == 240) {
                    return "cif";
                }
                return "hd1";
            }
            case 480: {
                return "svcd";
            }
            case 640: {
                return "vga";
            }
            case 704: {
                if (height == 288 || height == 240) {
                    return "bcif";
                }
                return "d1";
            }
            case 800: {
                return "svga";
            }
            case 960: {
                if (height == 576 || height == 480) {
                    return "960h";
                }
                return "dv720p";
            }
            case 1024: {
                return "xvga";
            }
            case 1216: {
                return "1216x1024";
            }
            case 1280: {
                if (height == 720) {
                    return "720";
                }
                if (height == 800) {
                    return "wxga";
                }
                if (height == 960) {
                    return "1280x960";
                }
                return "sxga";
            }
            case 1408: {
                return "1408x1024";
            }
            case 1600: {
                if (height == 1024) {
                    return "wsxga";
                }
                return "uxga";
            }
            case 1872: {
                return "1872x1408";
            }
            case 1920: {
                if (height == 1080) {
                    return "1080";
                }
                return "wuxga";
            }
            case 2048: {
                return "2048x1536";
            }
            case 2432: {
                return "2432x2048";
            }
            case 2560: {
                return "2560x1920";
            }
            case 3296: {
                return "3296x2472";
            }
        }
        return "3744x1408";
    }

    public static String[] getParameterValues(String responseString, String parameterName) {
        String[] parameterList;
        String[] ret = null;
        for (String parameter : parameterList = responseString.split(new String(CRLF_BYTE))) {
            String[] parameterLine = parameter.toLowerCase().split("=");
            if (parameterLine.length != 2 || !parameterLine[0].toLowerCase().equals(parameterName.toLowerCase())) continue;
            ret = parameterLine[1].split(",");
            for (int j = 0; j < ret.length; ++j) {
                ret[j] = ret[j].trim();
            }
        }
        return ret;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        return null;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        return null;
    }
}

