/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqinvision.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionDevice;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionHardwareMotionDetection;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IQinVisionH264VideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqinvision.mpeg.IQinVisionH264VideoSourceClient";
    private String parameterString = null;
    private String resolutionRTSPURL = "";

    @Override
    public int init() {
        StringBuffer url = null;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        long[] allowedIntValues = new long[]{5000L, 7500L, 10000L, 15000L, 30000L};
        if (this.getVideoSrv().getDevice().getDeviceType() == 201325L || this.getVideoSrv().getDevice().getDeviceType() == 201324L || this.getVideoSrv().getDevice().getDeviceType() == 201323L) {
            allowedIntValues = new long[]{1000L, 2000L, 3000L, 4000L, 5000L, 7500L, 10000L, 15000L, 30000L};
        }
        double fpsValue = (double)Tools.convertToCameraValues(allowedIntValues, this.fps) / 1000.0;
        String fpsValueAsString = "" + fpsValue;
        if (fpsValueAsString.indexOf(".0") != -1) {
            fpsValueAsString = fpsValueAsString.substring(0, fpsValueAsString.length() - 2);
        }
        this.bandwidth /= 1024;
        try {
            this.errorCode = ((IQinVisionDevice)this.getVideoSrv().getDevice()).setRTSPPort(this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort());
            if (this.errorCode != 0) {
                this.logger.error("Could not set RTSP port");
                return this.errorCode;
            }
        }
        catch (ConfigurationException exception) {
            this.logger.warn("RTSP port could not be read", (Throwable)exception);
        }
        if (this.width == 1920 && this.height == 1080) {
            this.resolutionTag = "mode1";
        } else if (this.width == 1280 && this.height == 720) {
            this.resolutionTag = "mode2";
        } else if (this.width == 720 && this.height == 480) {
            this.resolutionTag = "mode9";
        } else if (this.width == 352 && this.height == 240) {
            this.resolutionTag = "mode10";
            this.resolutionRTSPURL = "/rtsp/now.mp4?res=low";
        }
        this.parameterString = "OidSR1.17.2.6=" + this.resolutionTag;
        this.parameterString = this.parameterString + "&OidTR1.17.2.4=" + fpsValueAsString;
        this.parameterString = this.parameterString + "&OidTR1.17.2.2=" + this.bandwidth;
        this.parameterString = this.isConstantBitrateUsed ? this.parameterString + "&OidTR1.17.2.7=CBR" : this.parameterString + "&OidTR1.17.2.7=VBR";
        this.parameterString = this.parameterString + "&OidSB1.2.9.1.8.1=%22" + (this.useDateTime ? "enabled" : "disabled") + "%22";
        if (this.useTitle) {
            if (this.title != null && this.title.trim().length() > 0) {
                this.parameterString = this.parameterString + "&OidTB1.2.9.1.9.2=%22" + this.title + "%22";
            }
        } else {
            this.parameterString = this.parameterString + "&OidTB1.2.9.1.9.2=%22%22";
        }
        String startUrl = "/set.oid?" + this.parameterString;
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)startUrl, (int)Integer.MAX_VALUE);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/set.oid?OidTB1.17.2.15=1", (int)Integer.MAX_VALUE);
            String setRotation = "/set.oid?OidTR1.2.4=" + (this.getRotationAngle() == 0 ? "none" : "180");
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)setRotation, (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException ex) {
            if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED) {
                this.logger.error("Authorization NOT successful");
                return -21657;
            }
            this.logger.error("Error setting parameters for " + this);
            return -21601;
        }
        if (this.isAudioEnabled) {
            this.logger.info("Audio Parameter: " + this.audioCodec + " with " + this.audioBitrate + "bit for " + this.getVideoSrv().getDevice());
            url = new StringBuffer("/set.oid?OidSB1.9.5=enabled&OidSB1.9.6=enabled");
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MAX_VALUE);
            }
            catch (SeeTecException e) {
                this.logger.error("Exception while setting Audio association for " + this.getVideoSrv(), (Throwable)e);
                return e.getErrorCode();
            }
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.rtspUrl = "rtsp://" + this.getHost() + this.resolutionRTSPURL;
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 0, null);
            if (this.errorCode != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.setCheckResolution(true, this.resolution);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("RTSPHandler.init failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP streaming for " + this.getVideoSrv() + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.getListener().sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void processData(byte[] data) {
        if (this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null && Basic.indexOfByteArray((byte[])data, (byte[])"motion".getBytes(), (int)0) != -1) {
            String regex = "motion ([\\p{Print}]+)";
            String result = "";
            Matcher matcher = Pattern.compile("motion ([\\p{Print}]+)").matcher(new String(data));
            if (matcher.find()) {
                result = matcher.group(1);
            }
            for (String w : result.split(" ")) {
                ((IQinVisionHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).evaluateWindow(Integer.parseInt(w) - 1);
            }
        }
        this.processRtpData(data);
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

