/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqinvision.jpeg;

import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionCameraSrv;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;

public class IQinVisionJPEGSingleImageVideoSourceClient
extends JPEGVideoSourceClient {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionJPEGSingleImageVideoSourceClient";
    private static final int STREAM_ID = 2;
    private final StringBuilder parameterString = new StringBuilder(256);
    private String[][] oidTable;
    private IQinVisionCameraSrv iqInvisionCameraSrv;
    private long[] allowedIntValues;
    private volatile int timeForIteration;

    @Override
    public int init() {
        int errorCode = super.init();
        if (errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
            return errorCode;
        }
        errorCode = ((IQinVisionDevice)this.getVideoSrv().getDevice()).setGlobalParameters(this.networkParameter, this.rotationAngle);
        if (errorCode != 0) {
            this.logger.error("Could not set RTSP port");
            return errorCode;
        }
        try {
            String oidString = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/oidtable.html", (int)Integer.MAX_VALUE));
            String newOidString = oidString.replaceAll("\\<.*?>", "<>").replaceAll("&nbsp;", "").replace("<><>", "<>").replace("<>\r\n", "\r\n").replace("\r\n<>", "\r\n");
            String[] oidLines = newOidString.split("\r\n");
            this.oidTable = new String[oidLines.length][];
            for (int i = 0; i < oidLines.length; ++i) {
                this.oidTable[i] = oidLines[i].split("<>");
            }
            if (this.iqInvisionCameraSrv == null) {
                this.iqInvisionCameraSrv = (IQinVisionCameraSrv)this.getVideoSrv();
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
        }
        String[] allowedFramerates = this.iqInvisionCameraSrv.getPossibleOidValues("1.17.2.19.3.2", this.oidTable);
        if (allowedFramerates == null) {
            return -20100;
        }
        this.allowedIntValues = new long[allowedFramerates.length];
        for (int i = 0; i < this.allowedIntValues.length; ++i) {
            this.allowedIntValues[this.allowedIntValues.length - 1 - i] = (long)(Double.parseDouble(allowedFramerates[i]) * 1000.0);
        }
        double fpsValue = (double)Tools.convertToCameraValues(this.allowedIntValues, this.highestFramerate) / 1000.0;
        String fpsValueAsString = "" + fpsValue;
        if (fpsValueAsString.contains(".0")) {
            fpsValueAsString = fpsValueAsString.substring(0, fpsValueAsString.length() - 2);
        }
        this.parameterString.append("OidTR1.17.2.19.3.").append(2).append("=").append(fpsValueAsString);
        this.parameterString.append("&OidTR1.17.2.19.1.").append(2).append("=jpeg");
        this.parameterString.append("&OidSB1.2.9.1.8.1=%22").append(this.useDateTime ? "enabled" : "disabled").append("%22");
        if (this.useTitle) {
            if (this.title != null && this.title.trim().length() > 0) {
                this.parameterString.append("&OidTB1.2.9.1.9.2=%22").append(this.title).append("%22");
            }
        } else {
            this.parameterString.append("&OidTB1.2.9.1.9.2=%22%22");
        }
        String startUrl = "/set.oid?" + this.parameterString;
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)startUrl, (int)Integer.MAX_VALUE);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/set.oid?OidTB1.17.2.15=1", (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException ex) {
            if (ex.getMessage().toLowerCase().indexOf("unauthorized") >= 0) {
                this.logger.error("Authorization NOT successful");
                return -21665;
            }
            this.logger.error("Error setting parameters for " + this);
            return -21601;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.iqInvisionCameraSrv == null) {
            this.iqInvisionCameraSrv = (IQinVisionCameraSrv)this.getVideoSrv();
        }
        this.iqInvisionCameraSrv.removeStream(2);
        return super.shutdown();
    }

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            String url = "/now.jpg";
            this.timeForIteration = (int)(1000000L / this.highestFramerate);
            while (!this.isShutdown()) {
                long pause;
                long time = System.currentTimeMillis();
                byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)Integer.MAX_VALUE, (boolean)true);
                int pointer = Basic.indexOfByteArray((byte[])result, (byte[])DOUBLE_CRLF_BYTE, (int)0, (boolean)false);
                if (pointer > 0) {
                    byte[] temp = Arrays.copyOfRange(result, pointer, result.length - 1);
                    this.deliverContent(temp);
                }
                if ((pause = (long)this.timeForIteration - (System.currentTimeMillis() - time)) <= 0L) continue;
                Thread.sleep(pause);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this, (Throwable)ex);
        }
        catch (Throwable e) {
            this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", e);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public boolean hasMotionDataStream(NetworkParameter networkParameter) {
        try {
            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)"/now.motiondata", (int)200);
        }
        catch (SeeTecException ex) {
            if (ex.getNetworkStatus() == HTTPStatusCode.HTTP_NOT_FOUND) {
                return false;
            }
            this.logger.error("Exception while testing motion detection capability for " + ex.getMessage());
        }
        return true;
    }

    public void changeFramerate(long highestFramerate) {
        this.timeForIteration = (int)(1000000L / highestFramerate);
    }
}

