/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqinvision;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionCameraSrv;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionDevice;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionHardwareMotionDetection;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Arrays;

public class IQinVisionVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionH264VideoSourceClient";
    private StringBuilder parameterString = new StringBuilder(256);
    private IQinVisionDevice iqInvisionDevice;
    private String[][] oidTable;
    private int streamID;
    private IQinVisionCameraSrv iqInvisionCameraSrv;
    private long[] allowedIntValues;

    @Override
    public int init() {
        this.iqInvisionDevice = (IQinVisionDevice)this.getVideoSrv().getDevice();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        this.networkParameter.setSoTimeout(5000);
        this.errorCode = ((IQinVisionDevice)this.getVideoSrv().getDevice()).setGlobalParameters(this.networkParameter, this.rotationAngle);
        if (this.errorCode != 0) {
            this.logger.error("Could not set RTSP port");
            return this.errorCode;
        }
        try {
            String oidString = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/oidtable.html", (int)Integer.MAX_VALUE));
            String newOidString = oidString.replaceAll("\\<.*?>", "<>").replaceAll("&nbsp;", "").replace("<><>", "<>").replace("<>\r\n", "\r\n").replace("\r\n<>", "\r\n");
            String[] oidLines = newOidString.split("\r\n");
            this.oidTable = new String[oidLines.length][];
            for (int i = 0; i < oidLines.length; ++i) {
                this.oidTable[i] = oidLines[i].split("<>");
            }
            if (this.iqInvisionCameraSrv == null) {
                this.iqInvisionCameraSrv = (IQinVisionCameraSrv)this.getVideoSrv();
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading camera parameters for " + this + ": " + ex.getMessage());
        }
        try {
            if (Integer.parseInt(this.iqInvisionCameraSrv.getActualOidValue("1.17.3.1", this.oidTable)) != this.listener.getVideoSourceParameter().getRtspPort()) {
                this.errorCode = this.iqInvisionDevice.setRTSPPort(this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort());
                if (this.errorCode != 0) {
                    this.logger.error("Could not set RTSP port");
                    return this.errorCode;
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/set.oid?OidTR2.11=1", (int)Integer.MIN_VALUE);
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while rebooting camera for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.error("Exception while setting RTSP Port for " + this + ": " + ex.getMessage());
        }
        String[] allowedFramerates = this.iqInvisionCameraSrv.getPossibleOidValues("1.17.2.19.3." + this.streamID, this.oidTable);
        this.allowedIntValues = new long[allowedFramerates.length];
        for (int i = 0; i < this.allowedIntValues.length; ++i) {
            this.allowedIntValues[this.allowedIntValues.length - 1 - i] = (long)(Double.parseDouble(allowedFramerates[i]) * 1000.0);
        }
        double fpsValue = (double)Tools.convertToCameraValues(this.allowedIntValues, this.fps) / 1000.0;
        String fpsValueAsString = "" + fpsValue;
        if (fpsValueAsString.indexOf(".0") != -1) {
            fpsValueAsString = fpsValueAsString.substring(0, fpsValueAsString.length() - 2);
        }
        this.parameterString.append("OidTR1.17.2.19.3.").append(this.streamID).append("=").append(fpsValueAsString);
        if (this.videoCodec == Codec.H264) {
            this.parameterString.append("&OidTR1.17.2.19.1.").append(this.streamID).append("=h264");
            this.bandwidth /= 1024;
            if (this.isConstantBitrateUsed) {
                this.parameterString.append("&OidTR1.17.2.19.4.").append(this.streamID).append("=cbr");
            } else {
                this.parameterString.append("&OidTR1.17.2.19.4.").append(this.streamID).append("=vbr");
            }
            this.parameterString.append("&OidTR1.17.2.19.5.").append(this.streamID).append("=").append(this.bandwidth);
        } else {
            this.parameterString.append("&OidTR1.17.2.19.1.").append(this.streamID).append("=jpeg");
        }
        this.parameterString.append("&OidSB1.2.9.1.8.1=%22").append(this.useDateTime ? "enabled" : "disabled").append("%22");
        if (this.useTitle) {
            if (this.title != null && this.title.trim().length() > 0) {
                this.parameterString.append("&OidTB1.2.9.1.9.2=%22").append(this.title).append("%22");
            }
        } else {
            this.parameterString.append("&OidTB1.2.9.1.9.2=%22%22");
        }
        if (this.isAudioEnabled) {
            this.parameterString.append("&OidTR1.9.5=enabled");
        }
        String startUrl = "/set.oid?" + this.parameterString;
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)startUrl, (int)Integer.MAX_VALUE);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/set.oid?OidTB1.17.2.15=1", (int)Integer.MAX_VALUE);
        }
        catch (SeeTecException ex) {
            if (ex.getMessage().toLowerCase().indexOf("unauthorized") >= 0) {
                this.logger.error("Authorization NOT successful");
                return -21665;
            }
            this.logger.error("Error setting parameters for " + this);
            return -21601;
        }
        try {
            this.rtspUrl = "rtsp://" + this.getHost() + "/stream" + this.streamID;
            if (this.getVideoSrv().getDevice().getDeviceType() == 201325L || this.getVideoSrv().getDevice().getDeviceType() == 201324L || this.getVideoSrv().getDevice().getDeviceType() == 201323L) {
                this.rtspUrl = this.videoCodec == Codec.MJPEG ? "rtsp://" + this.getHost() + "/now.jpg" : (this.streamID == 1 ? "rtsp://" + this.getHost() + "/now.mp4?res=high" : "rtsp://" + this.getHost() + "/now.mp4?res=low");
            }
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing RTSP Settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspSettings.setCheckResolution(true, this.resolution);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Streaming for " + this.getVideoSrv());
                return this.errorCode;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP handling for " + this.getVideoSrv() + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        catch (Exception ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.iqInvisionCameraSrv == null) {
            this.iqInvisionCameraSrv = (IQinVisionCameraSrv)this.getVideoSrv();
        }
        if (this.iqInvisionCameraSrv != null) {
            this.iqInvisionCameraSrv.removeStream(this.streamID);
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.getListener().sendStatusService(error);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        if ((data[12] & 6) == 6 && Basic.indexOfByteArray((byte[])data, (byte[])"motion".getBytes(), (int)0) != -1 && this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null && ((IQinVisionCameraSrv)this.getVideoSrv()).getMotionDetectionStream() == this.streamID) {
            int startIndex = Basic.indexOfByteArray((byte[])data, (byte[])"motion".getBytes(), (int)0, (boolean)false);
            int endIndex = Basic.indexOfByteArray((byte[])data, (byte[])Basic.hexStringToByteArray((String)"02"), (int)startIndex, (boolean)true);
            byte[] motionDataByteArray = Arrays.copyOfRange(data, startIndex, endIndex);
            String[] motionDataArray = new String(motionDataByteArray).split(" ");
            for (int i = 0; i < motionDataArray.length; ++i) {
                try {
                    int windowNumber = Integer.parseInt(motionDataArray[i]);
                    if (windowNumber <= 0 || windowNumber >= 5) continue;
                    ((IQinVisionHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).evaluateWindow(windowNumber - 1);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.processRtpData(data);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void setStreamID(int streamID) {
        this.streamID = streamID;
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }
}

