/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqinvision;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.DigitalOutputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionDevice;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;

public class IQinVisionIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionIOHandler";

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            boolean bPreviousLoopWithError = false;
            while (!(this.isShutdown(CLASS_NAME) || super.isShutdown() || this.device.isShutdown())) {
                try {
                    long duration;
                    long ts = System.currentTimeMillis();
                    this.readDigitalInputs();
                    if (bPreviousLoopWithError) {
                        bPreviousLoopWithError = false;
                        this.logger.info("Publishing input stati after error for " + this + " ...");
                        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(iServices[i].getInputStatus());
                        }
                    }
                    if ((duration = System.currentTimeMillis() - ts) < 0L || duration >= 190L) continue;
                    try {
                        Thread.sleep(200L - duration);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Throwable ex) {
                    bPreviousLoopWithError = true;
                    if (ex instanceof IOException || ex instanceof UnknownHostException || ex instanceof NoRouteToHostException || ex instanceof ConnectException) {
                        this.logger.warn("Network trouble for " + this);
                    } else {
                        this.logger.warn((Object)ex, ex);
                        if (ex.getMessage().indexOf("Address already in use") >= 0) {
                            this.logger.warn("TCP stack seems to be overloaded, so there are problems for " + this);
                        } else {
                            this.logger.warn("Unknown trouble for " + this);
                        }
                    }
                    try {
                        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
                        for (int i = 0; i < iServices.length; ++i) {
                            if (!iServices[i].getEntity().isEnabled().booleanValue()) continue;
                            iServices[i].publishServiceStatus(-21603);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn((Object)t, t);
                    }
                    long tsTimeout = System.currentTimeMillis() + 10000L;
                    while (tsTimeout > System.currentTimeMillis() && !this.isShutdown(CLASS_NAME) && !this.device.isShutdown()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        this.logger.info("Thread of this " + this + " finished :-)");
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int readDigitalInputs() throws Exception {
        int errorCode = 0;
        String sSeeTecID = Long.toHexString(System.currentTimeMillis() & 0xFFFFFFFFL);
        DigitalInputSrv[] iServices = super.getDigitalInputSrv();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Reading digital inputs of " + this + " ...");
        }
        for (int i = 0; i < iServices.length; ++i) {
            IQinVisionDevice iqinVisionDevice = (IQinVisionDevice)this.device;
            int entityID = iqinVisionDevice.getDeviceEntity().getEntityType().intValue();
            String url = "";
            url = (long)entityID == 201330L || (long)entityID == 201331L || (long)entityID == 201332L || (long)entityID == 201333L || (long)entityID == 201334L || (long)entityID == 201326L || (long)entityID == 201327L || (long)entityID == 201328L || (long)entityID == 201329L || (long)entityID == 201335L || (long)entityID == 201336L || (long)entityID == 201337L || (long)entityID == 201338L || (long)entityID == 201339L || (long)entityID == 201340L ? "/get.oid?1.3.15" : "/get.oid?1.3.15&sid=" + sSeeTecID;
            String sDigitalInput = new String(NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url, (int)65536));
            if (this.logger.isDebugEnabled()) {
                this.logger.info("DigitalInput [" + sDigitalInput + "] for " + this);
            }
            if (sDigitalInput.indexOf("CLOSED") != -1) {
                iServices[i].checkInput(1);
                continue;
            }
            iServices[i].checkInput(0);
        }
        return errorCode;
    }

    @Override
    public int writeDigitalOutput(int nOutputNumber, int value, long holdTime) {
        int errorCode = 0;
        DigitalOutputSrv service = super.getDigitalOutputSrv(nOutputNumber);
        if (service == null) {
            errorCode = -21601;
            return errorCode;
        }
        if (value < 0) {
            this.logger.error("Value [" + value + "] is not valid for " + this + " :-(");
            errorCode = -21601;
            return errorCode;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Writing value [" + value + "] to output [" + nOutputNumber + "] with HoldTime [" + holdTime + "] for " + this + " ...");
        }
        try {
            IOHandler.HoldTimer holdTimer;
            String[] stringArray;
            if (this.authorization) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = this.usr;
                stringArray = stringArray2;
                stringArray2[1] = this.pwd;
            } else {
                stringArray = null;
            }
            String[] sUserPWD = stringArray;
            String valueString = value > 0 ? "CLOSED" : "OPEN";
            String sURL = "/set.oid?OidSR1.3.5.1=" + valueString;
            String resolvedHost = new LteHostResolver(this.getCore().getLTESupportConfiguration()).resolve(this.host);
            NetworkHelper.readGetRequest((String)resolvedHost, (int)this.port, (String[])sUserPWD, (String)sURL);
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(nOutputNumber, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Problems setting output [" + nOutputNumber + "] of " + this + " :-(", ex);
        }
        return errorCode;
    }

    @Override
    protected int discard() {
        return 0;
    }
}

