/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.iqinvision;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.DoNothingCameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionDevice;
import de.seetec.v5.re.cm.device.video.iqinvision.IQinVisionVideoSourceClient;
import de.seetec.v5.re.cm.device.video.iqinvision.jpeg.IQinVisionJPEGSingleImageVideoSourceClient;
import de.seetec.v5.re.cm.device.video.iqinvision.jpeg.IQinVisionJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.iqinvision.mpeg.IQinVisionH264VideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IQinVisionCameraSrv
extends LiveCameraSrv {
    private boolean isMultiStreamingUsed;
    private int streamNumber;
    private final Map<Integer, Integer> streams = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> codecs = new HashMap<Integer, Integer>();
    private int motionDetectionStream = -1;
    private String[][] oidTable;

    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new DoNothingCameraControl();
    }

    @Override
    public synchronized VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        int errorCode = 0;
        VideoSourceClient videoSourceClient = null;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("StreamingMode for " + this + " is [" + this.getVideoSourceCnf().getMediaCodec() + "]");
            }
            Codec streamingMode = listener.getVideoSourceParameter().getMediaCodec();
            boolean bl = this.isMultiStreamingUsed = this.getAdditionalVideoProfileHandler().length >= 1;
            if (this.getDevice().getDeviceType() == 201330L || this.getDevice().getDeviceType() == 201331L || this.getDevice().getDeviceType() == 201332L || this.getDevice().getDeviceType() == 201333L || this.getDevice().getDeviceType() == 201334L || this.getDevice().getDeviceType() == 201326L || this.getDevice().getDeviceType() == 201327L || this.getDevice().getDeviceType() == 201328L || this.getDevice().getDeviceType() == 201329L || this.getDevice().getDeviceType() == 201335L || this.getDevice().getDeviceType() == 201336L || this.getDevice().getDeviceType() == 201337L || this.getDevice().getDeviceType() == 201338L || this.getDevice().getDeviceType() == 201339L || this.getDevice().getDeviceType() == 201342L || this.getDevice().getDeviceType() == 201341L || this.getDevice().getDeviceType() == 201340L) {
                if (this.oidTable == null || this.getActualOidValue("1.17.2.19.2.1", this.oidTable) == null) {
                    this.oidTable = this.readOidTable();
                }
                videoSourceClient = new IQinVisionVideoSourceClient();
                int[] resolution = listener.getVideoSourceParameter().getImageSize();
                NetworkParameter networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
                IQinVisionDevice iqInvisionDevice = (IQinVisionDevice)this.device;
                if (this.isMultiStreamingUsed) {
                    VideoProfileHandler[] videoProfileHandler = this.getAdditionalVideoProfileHandler();
                    int[][] resolutionsInSeetec = new int[videoProfileHandler.length + 1][3];
                    resolutionsInSeetec[0][0] = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[0];
                    resolutionsInSeetec[0][1] = this.getBasicVideoProfileHandler().getVideoSourceParameter().getImageSize()[1];
                    resolutionsInSeetec[0][2] = this.getBasicVideoProfileHandler().getDynamicVideoProfileID();
                    for (int i = 0; i < videoProfileHandler.length; ++i) {
                        resolutionsInSeetec[i + 1][0] = videoProfileHandler[i].getVideoSourceParameter().getImageSize()[0];
                        resolutionsInSeetec[i + 1][1] = videoProfileHandler[i].getVideoSourceParameter().getImageSize()[1];
                        resolutionsInSeetec[i + 1][2] = videoProfileHandler[i].getDynamicVideoProfileID();
                    }
                    resolutionsInSeetec = iqInvisionDevice.sortArray(resolutionsInSeetec);
                    String resolutionOnCamera = this.getActualOidValue("1.17.2.19.2.1", this.oidTable);
                    if (IQinVisionDevice.getResolutionValues(resolutionOnCamera)[0] != resolutionsInSeetec[0][0] && IQinVisionDevice.getResolutionValues(resolutionOnCamera)[1] != resolutionsInSeetec[0][1]) {
                        String url = "/set.oid?OidTR1.17.2.19.2.1=" + iqInvisionDevice.getResolutionString(resolutionsInSeetec[0][0], resolutionsInSeetec[0][1]);
                        NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE);
                        this.oidTable = this.readOidTable();
                    }
                    this.streams.put(resolutionsInSeetec[0][2], 1);
                    for (int i = 1; i < resolutionsInSeetec.length; ++i) {
                        resolutionOnCamera = this.getActualOidValue("1.17.2.19.2." + (i + 1), this.oidTable);
                        if (IQinVisionDevice.getResolutionValues(resolutionOnCamera)[0] != resolutionsInSeetec[0][0] && IQinVisionDevice.getResolutionValues(resolutionOnCamera)[1] != resolutionsInSeetec[0][1]) {
                            String[] possibleResolutionsOnCamera = this.getPossibleOidValues("1.17.2.19.2." + (i + 1), this.oidTable);
                            boolean resolutionFound = false;
                            int[] nearestResolution = new int[]{0, 0};
                            for (int j = 0; j < possibleResolutionsOnCamera.length; ++j) {
                                int[] possibleResolutions = IQinVisionDevice.getResolutionValues(possibleResolutionsOnCamera[j]);
                                if (possibleResolutions[0] != resolutionsInSeetec[i][0] || possibleResolutions[1] != resolutionsInSeetec[i][1]) continue;
                                resolutionFound = true;
                                nearestResolution = possibleResolutions;
                            }
                            if (!resolutionFound) {
                                nearestResolution = this.lookForNearestResolution(resolutionsInSeetec[i], possibleResolutionsOnCamera);
                            }
                            String url = "/set.oid?OidTR1.17.2.19.2." + (i + 1) + "=" + iqInvisionDevice.getResolutionString(nearestResolution[0], nearestResolution[1]);
                            NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE);
                            this.oidTable = this.readOidTable();
                        }
                        this.streams.put(resolutionsInSeetec[i][2], i + 1);
                    }
                    if (this.streams.get(listener.getDynamicVideoProfileID()) == null) {
                        this.logger.error("Error while reading stream configuration in Seetec for " + this);
                    } else {
                        this.streamNumber = this.streams.get(listener.getDynamicVideoProfileID());
                    }
                } else {
                    this.streamNumber = 1;
                    String resolutionTag = iqInvisionDevice.getResolutionString(resolution[0], resolution[1]);
                    String url = "/set.oid?OidTR1.17.2.19.2.1=" + resolutionTag;
                    NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE);
                }
                this.codecs.put(this.streamNumber, streamingMode.getType());
                ((IQinVisionVideoSourceClient)videoSourceClient).setStreamID(this.streamNumber);
                if (this.motionDetectionStream == -1 && streamingMode == Codec.H264) {
                    this.motionDetectionStream = this.streamNumber;
                }
            } else if (this.getDevice().getDeviceType() == 201323L || this.getDevice().getDeviceType() == 201324L || this.getDevice().getDeviceType() == 201325L) {
                if (this.streams.isEmpty()) {
                    String captureMode = this.getDevice().getDeviceCnf().getCaptureMode().getDisplayResolution().toLowerCase().trim();
                    int mode = 1;
                    int myProfile = listener.getDynamicVideoProfileID();
                    int anotherProfile = -1;
                    if (this.isMultiStreamingUsed) {
                        int n = anotherProfile = myProfile == this.getBasicVideoProfileHandler().getDynamicVideoProfileID() ? this.getAdditionalVideoProfileHandler()[0].getDynamicVideoProfileID() : this.getBasicVideoProfileHandler().getDynamicVideoProfileID();
                    }
                    if (captureMode.equals("single streaming")) {
                        IQinVisionDevice iqInvisionDevice = (IQinVisionDevice)this.device;
                        this.streams.put(myProfile, 1);
                        int[] resolution = listener.getVideoSourceParameter().getImageSize();
                        String resolutionTag = iqInvisionDevice.getResolutionString(resolution[0], resolution[1]);
                        String url = "/set.oid?OidTR1.17.2.19.2.1=" + resolutionTag;
                        if (streamingMode == Codec.MJPEG) {
                            this.streamNumber = 2;
                            url = url + "&OidTR1.17.2.19.2.2=" + resolutionTag + "&OidTR1.17.2.19.1.1=h264";
                            if (resolution[0] == 1280) {
                                mode = 2;
                            } else if (resolution[0] == 720) {
                                if (this.getDevice().getDeviceType() == 201324L) {
                                    mode = 6;
                                } else if (this.getDevice().getDeviceType() == 201325L) {
                                    mode = 9;
                                }
                            } else if (resolution[0] == 352) {
                                mode = 11;
                            }
                        } else if (resolution[0] == 1280) {
                            this.streamNumber = 1;
                            mode = 2;
                        } else if (resolution[0] == 720) {
                            this.streamNumber = 2;
                            if (this.getDevice().getDeviceType() == 201324L) {
                                mode = 3;
                            } else if (this.getDevice().getDeviceType() == 201325L) {
                                mode = 9;
                            }
                        } else if (resolution[0] == 352) {
                            this.streamNumber = 2;
                            mode = 10;
                        }
                        this.streams.put(myProfile, this.streamNumber);
                        NetworkParameter networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
                        NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE);
                    } else if (captureMode.equals("h.264 1080p")) {
                        mode = 1;
                        this.streams.put(myProfile, 1);
                    } else if (captureMode.equals("mjpeg 1080p")) {
                        mode = 5;
                        this.streams.put(myProfile, 1);
                    } else if (captureMode.equals("h.264 720p + mjpeg 720p")) {
                        mode = 2;
                        if (listener.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                            this.streams.put(myProfile, 1);
                            this.streams.put(anotherProfile, 2);
                        } else {
                            this.streams.put(myProfile, 2);
                            this.streams.put(anotherProfile, 1);
                        }
                    } else if (captureMode.equals("h.264 720p + h.264 720p")) {
                        mode = 22;
                        this.streams.put(myProfile, 1);
                        this.streams.put(anotherProfile, 2);
                    } else if (captureMode.equals("h.264 720p + h.264 480p")) {
                        mode = 3;
                        if (listener.getVideoSourceParameter().getImageSize()[0] == 1280) {
                            this.streams.put(myProfile, 1);
                            this.streams.put(anotherProfile, 2);
                        } else {
                            this.streams.put(myProfile, 2);
                            this.streams.put(anotherProfile, 1);
                        }
                    } else if (captureMode.equals("h.264 720p + mjpeg 480p")) {
                        mode = 6;
                        if (listener.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                            this.streams.put(myProfile, 1);
                            this.streams.put(anotherProfile, 2);
                        } else {
                            this.streams.put(myProfile, 2);
                            this.streams.put(anotherProfile, 1);
                        }
                    } else if (captureMode.equals("h.264 480p + h.264 sif")) {
                        mode = 10;
                        if (listener.getVideoSourceParameter().getImageSize()[0] == 720) {
                            this.streams.put(myProfile, 1);
                            this.streams.put(anotherProfile, 2);
                        } else {
                            this.streams.put(myProfile, 2);
                            this.streams.put(anotherProfile, 1);
                        }
                    } else if (captureMode.equals("h.264 480p + mjpeg sif")) {
                        mode = 11;
                        if (listener.getVideoSourceParameter().getImageSize()[0] == 720) {
                            this.streams.put(myProfile, 1);
                            this.streams.put(anotherProfile, 2);
                        } else {
                            this.streams.put(myProfile, 2);
                            this.streams.put(anotherProfile, 1);
                        }
                    } else if (captureMode.equals("h.264 480p + mjpeg 480p")) {
                        mode = 9;
                        if (listener.getVideoSourceParameter().getMediaCodec() == Codec.H264) {
                            this.streams.put(myProfile, 1);
                            this.streams.put(anotherProfile, 2);
                        } else {
                            this.streams.put(myProfile, 2);
                            this.streams.put(anotherProfile, 1);
                        }
                    }
                    String url = "/set.oid?OidTR1.17.2.6=mode" + mode;
                    NetworkParameter networkParameter = this.getDevice().getDeviceCnf().getNetworkParameter();
                    NetworkHelper.readGetRequest((NetworkParameter)networkParameter, (String)url, (int)Integer.MAX_VALUE);
                }
                videoSourceClient = this.isMultiStreamingUsed && listener.getVideoSourceParameter().getMediaCodec() == Codec.MJPEG ? new IQinVisionJPEGSingleImageVideoSourceClient() : new IQinVisionVideoSourceClient();
                this.streamNumber = this.streams.get(listener.getDynamicVideoProfileID());
                if (videoSourceClient instanceof IQinVisionVideoSourceClient) {
                    ((IQinVisionVideoSourceClient)videoSourceClient).setStreamID(this.streamNumber);
                }
            } else {
                videoSourceClient = streamingMode == Codec.H264 ? new IQinVisionH264VideoSourceClient() : new IQinVisionJPEGVideoSourceClient();
            }
            errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            if (seetecEx.getErrorCode() == -21657) {
                throw new SeeTecException(-21657, "Unauthorized access while sending HTTP command");
            }
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] nResolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    public void removeStream(int streamNumber) {
        this.streams.remove(streamNumber);
        this.codecs.remove(streamNumber);
        if (this.motionDetectionStream == streamNumber) {
            int motionDetectionStreamNumber;
            this.motionDetectionStream = -1;
            Set<Integer> keySet = this.streams.keySet();
            if (!keySet.isEmpty() && this.codecs.get(motionDetectionStreamNumber = keySet.iterator().next().intValue()) != null && this.codecs.get(motionDetectionStreamNumber).intValue() == Codec.H264.getType()) {
                this.motionDetectionStream = motionDetectionStreamNumber;
            }
        }
    }

    public int getMotionDetectionStream() {
        return this.motionDetectionStream;
    }

    public String getActualOidValue(String oid, String[][] oidTable) {
        String ret = null;
        for (int i = 0; i < oidTable.length; ++i) {
            if (!oidTable[i][0].equals(oid)) continue;
            ret = oidTable[i][1];
        }
        return ret;
    }

    public String[] getPossibleOidValues(String oid, String[][] oidTable) {
        String[] ret = null;
        for (int i = 0; i < oidTable.length; ++i) {
            if (!oidTable[i][0].equals(oid) || oidTable[i].length <= 3) continue;
            oidTable[i][3] = oidTable[i][3].trim();
            if (oidTable[i][3].endsWith(",")) {
                oidTable[i][3] = oidTable[i][3].substring(0, oidTable[i][3].length() - 1);
            }
            ret = oidTable[i][3].split(",");
            for (int j = 0; j < ret.length; ++j) {
                ret[j] = ret[j].trim();
            }
            return ret;
        }
        return ret;
    }

    private String[][] readOidTable() {
        String[][] ret = null;
        try {
            String oidString = new String(NetworkHelper.readGetRequest((NetworkParameter)this.getDevice().getDeviceCnf().getNetworkParameter(), (String)"/oidtable.html", (int)Integer.MAX_VALUE));
            String newOidString = oidString.replaceAll("\\<.*?>", "<>").replaceAll("&nbsp;", "").replace("<><>", "<>").replace("<>\r\n", "\r\n").replace("\r\n<>", "\r\n");
            String[] oidLines = newOidString.split("\r\n");
            ret = new String[oidLines.length][];
            for (int i = 0; i < oidLines.length; ++i) {
                ret[i] = oidLines[i].split("<>");
            }
        }
        catch (ConfigurationException ex) {
            this.logger.error("Configuration Exception while reading oid values from camera for " + this + ": " + ex.getMessage());
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while reading oid values from camera for " + this + ": " + ex.getMessage());
        }
        return ret;
    }

    public int[] lookForNearestResolution(int[] resolution, String[] possibleResolutionsOnCamera) {
        int k;
        int pictureSizeOnSeetec = resolution[0] * resolution[1];
        int[] pictureSizeOnCamera = new int[possibleResolutionsOnCamera.length];
        for (int j = 0; j < pictureSizeOnCamera.length; ++j) {
            pictureSizeOnCamera[j] = IQinVisionDevice.getResolutionValues(possibleResolutionsOnCamera[j])[0] * IQinVisionDevice.getResolutionValues(possibleResolutionsOnCamera[j])[1];
        }
        if (pictureSizeOnSeetec >= pictureSizeOnCamera[0]) {
            return IQinVisionDevice.getResolutionValues(possibleResolutionsOnCamera[0]);
        }
        if (pictureSizeOnSeetec <= pictureSizeOnCamera[pictureSizeOnCamera.length - 1]) {
            return IQinVisionDevice.getResolutionValues(possibleResolutionsOnCamera[pictureSizeOnCamera.length - 1]);
        }
        for (k = 0; k < pictureSizeOnCamera.length - 1; ++k) {
            if (pictureSizeOnSeetec != pictureSizeOnCamera[k]) continue;
            return IQinVisionDevice.getResolutionValues(possibleResolutionsOnCamera[k]);
        }
        for (k = 0; k < pictureSizeOnCamera.length - 1; ++k) {
            if (pictureSizeOnSeetec >= pictureSizeOnCamera[k] || pictureSizeOnSeetec <= pictureSizeOnCamera[k + 1]) continue;
            return IQinVisionDevice.getResolutionValues(possibleResolutionsOnCamera[k + 1]);
        }
        return IQinVisionDevice.getResolutionValues(possibleResolutionsOnCamera[possibleResolutionsOnCamera.length - 1]);
    }
}

