/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.ids;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class IdsVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.ids.IdsVideoSourceClient";
    private String stream = "";

    @Override
    public int init() {
        try {
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            if (this.videoCodec == Codec.MJPEG) {
                this.stream = "mjpeg";
            } else if (this.videoCodec == Codec.H264) {
                this.stream = "h264";
            }
            try {
                byte[] frameRateList = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/dcilist.cgi?streamcfg=stream:" + this.stream + ";framerate"), (int)Integer.MAX_VALUE, (boolean)false);
                String frameRateListAsString = new String(frameRateList);
                frameRateListAsString = frameRateListAsString.split("framerate=")[1].replace(";\n", "");
                String[] frameRates = frameRateListAsString.split(";");
                int[] availableFrameRate = new int[frameRates.length];
                for (int i = 0; i < availableFrameRate.length; ++i) {
                    availableFrameRate[i] = Integer.parseInt(frameRates[frameRates.length - i - 1]);
                }
                this.fps /= 1000L;
                this.fps = Tools.convertToCameraValues(availableFrameRate, (int)this.fps);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/dciset.cgi?streamcfg=stream:" + this.stream + ";framerate:" + this.fps), (int)Integer.MAX_VALUE, (boolean)false);
            }
            catch (Exception exception) {
                this.logger.warn("framerate could not be set for " + this);
            }
            if (this.videoCodec == Codec.H264) {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/dciset.cgi?ratecontrol=" + (this.isConstantBitrateUsed ? "CBR" : "VBR")), (int)Integer.MAX_VALUE, (boolean)false);
                int bitrate = this.bandwidth / 1024;
                if (bitrate > 12000) {
                    bitrate = 12000;
                } else if (bitrate < 64) {
                    bitrate = 64;
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/dciset.cgi?streamcfg=stream:" + this.stream + ";bitrate:" + bitrate), (int)Integer.MAX_VALUE, (boolean)false);
            } else if (this.videoCodec == Codec.MJPEG) {
                this.quality /= 1000;
                if (this.quality < 1) {
                    this.quality = 1;
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/dciset.cgi?streamcfg=stream:" + this.stream + ";quality:" + this.quality), (int)Integer.MAX_VALUE, (boolean)false);
            }
            if (this.isAudioEnabled) {
                this.logger.info("Audio enabled for " + this.getVideoSrv());
                if (this.audioCodec == Codec.G711U) {
                    this.audioCodec = Codec.G711A;
                }
            }
            this.rtspUrl = "rtsp://" + this.getHost() + "/" + this.stream;
            this.logger.info(this.rtspUrl);
            this.rtspSettings = new RTSPStreamSettings();
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 1);
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing RTSP Settings for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            int[] res = new int[]{this.width, this.height};
            this.rtspSettings.setCheckResolution(true, res);
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error(" Start of RTSPHandler failed with errorCode: " + this.errorCode + " for " + this.getVideoSrv());
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while initialization for " + this);
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this);
            this.logger.error((Object)t, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    public final int changeFramerate(long newFramerate) {
        this.logger.info((Object)newFramerate);
        try {
            byte[] frameRateList = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/dcilist.cgi?streamcfg=stream:" + this.stream + ";framerate"), (int)Integer.MAX_VALUE, (boolean)false);
            String frameRateListAsString = new String(frameRateList);
            frameRateListAsString = frameRateListAsString.split("framerate=")[1].replace(";\n", "");
            String[] frameRates = frameRateListAsString.split(";");
            int[] availableFrameRate = new int[frameRates.length];
            for (int i = 0; i < availableFrameRate.length; ++i) {
                availableFrameRate[i] = Integer.parseInt(frameRates[frameRates.length - i - 1]);
            }
            this.fps = newFramerate;
            this.fps /= 1000L;
            this.fps = Tools.convertToCameraValues(availableFrameRate, (int)this.fps);
            byte[] result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/dciset.cgi?streamcfg=stream:" + this.stream + ";framerate:" + this.fps), (int)Integer.MAX_VALUE, (boolean)false);
            this.logger.info(new String(result));
        }
        catch (SeeTecException exception) {
            this.logger.warn("framerate could not be set for " + this);
            return exception.getErrorCode();
        }
        return 0;
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }
}

