/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.hikvision;

import de.seetec.v5.re.cm.configuration.device.video.hikvision.StreamingChannel;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionCameraSrv;
import de.seetec.v5.re.cm.device.video.hikvision.HikvisionDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLDecoder;
import javax.xml.bind.JAXBException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;

public class HikvisionVideoSourceClientCGI
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.hikvision.HikvisionVideoSourceClientCGI";
    private int rtspPort = 554;
    private String parameterString = null;
    private String defaultFps = "2500";
    private String defaultQuality = "40";
    private HikvisionCameraSrv hikvisionCameraSrv;
    private int bitrate;
    private int streamNumber;
    private int videoSourceNumber = 1;
    private boolean restartLater;

    @Override
    public int init() {
        try {
            this.hikvisionCameraSrv = (HikvisionCameraSrv)this.getVideoSrv();
            HikvisionDevice device = (HikvisionDevice)this.hikvisionCameraSrv.getDevice();
            try {
                this.transmissionID = this.listener.getVideoSourceParameter().getTransmissionID();
            }
            catch (ConfigurationException ex) {
                this.logger.error("Exception while getting streaming configuration for " + this + ": " + ex.getMessage());
            }
            int tempTimeout = this.networkParameter.getSoTimeout();
            this.completeFrame = new ByteArrayOutputStream();
            this.networkParameter.setSoTimeout(5000);
            this.errorCode = super.init();
            if (this.errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
                return this.errorCode;
            }
            this.title = URLDecoder.decode(this.title.trim(), "UTF-8");
            int iFrameLimit = 400;
            if (!HikvisionDevice.isSmartDriver(this.getHikvisionEntityType(this.hikvisionCameraSrv))) {
                this.hikvisionCameraSrv.setModelInformation(this.width, this.height);
            }
            this.streamNumber = this.getVideoStreamNumber();
            this.videoSourceNumber = this.listener.getVideoSourceParameter().getServerEntryNo();
            String videoSourceAndStream = String.valueOf(this.streamNumber);
            if (device.getNumberOfVideoSourcesFromDevice() > 1 || !device.getHikvisionDeviceType().contains("ip")) {
                videoSourceAndStream = String.valueOf(this.videoSourceNumber) + "0" + String.valueOf(this.streamNumber);
            }
            String videoSourceString = this.videoSourceNumber < 10 ? "0" + this.videoSourceNumber : String.valueOf(this.videoSourceNumber);
            this.rtspUrl = this.streamNumber == 1 ? "rtsp://" + this.getHost() + "/mpeg4/ch" + videoSourceString + "/main/av_stream" : "rtsp://" + this.getHost() + "/mpeg4/ch" + videoSourceString + "/sub/av_stream";
            if (this.videoCodec != Codec.RTSP) {
                String[] fpsString;
                StreamingChannel subStream;
                StreamingChannel currentStream = device.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/" + videoSourceAndStream + "/capabilities");
                StreamingChannel mainStream = device.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/1/capabilities");
                if (currentStream == null) {
                    currentStream = device.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/" + videoSourceAndStream + "/capabilities");
                }
                if (mainStream == null) {
                    mainStream = device.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/101/capabilities");
                }
                if ((subStream = device.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/2/capabilities")) == null) {
                    subStream = device.getHikvisionObject(StreamingChannel.class, "/ISAPI/Streaming/channels/102/capabilities");
                }
                iFrameLimit = currentStream.getVideo().getKeyFrameInterval().getMax().intValue();
                this.iFrameDist = Tools.convertIFrameDistMStoFrameCount(this.fps, this.iFrameDistMS, 1, iFrameLimit);
                this.quality = 100000 - this.quality;
                this.quality /= 1000;
                this.bitrate = this.bandwidth / 1024;
                int maxFrameRateSubStream = 0;
                int maxFrameRateMainStream = 0;
                if (mainStream != null) {
                    fpsString = mainStream.getVideo().getMaxFrameRate().getOpt().split(",");
                    maxFrameRateMainStream = this.getMaxFps(fpsString);
                }
                if (subStream != null) {
                    fpsString = subStream.getVideo().getMaxFrameRate().getOpt().split(",");
                    maxFrameRateSubStream = this.getMaxFps(fpsString);
                }
                int maxFrameRate = maxFrameRateMainStream;
                if (this.streamNumber == 2) {
                    maxFrameRate = maxFrameRateSubStream;
                }
                this.defaultFps = HikvisionCameraSrv.getFramerate(this.fps, maxFrameRate);
                if (this.streamNumber == 2 && this.fps == 50000L) {
                    this.defaultFps = "2500";
                } else if (this.streamNumber == 2 && this.fps == 60000L) {
                    this.defaultFps = "3000";
                }
                this.defaultQuality = this.quality < 17 ? "100" : (this.quality < 33 ? "80" : (this.quality < 50 ? "60" : (this.quality < 67 ? "40" : (this.quality < 83 ? "20" : "1"))));
                this.rtspPort = this.listener.getVideoSourceParameter().getRtspPort();
                try {
                    Element audioEnabledElement;
                    Element audioElement;
                    Element videoCodecTypeElement;
                    String xmlString = device.getHttpHandler().readGetRequest("/Streaming/channels/" + this.streamNumber);
                    xmlString = xmlString.substring(xmlString.indexOf(">") + 1, xmlString.lastIndexOf(">") + 1);
                    ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes());
                    Document cameraConf = new SAXBuilder().build((InputStream)bais);
                    Element root = cameraConf.getRootElement();
                    Namespace ns = root.getNamespace();
                    Element videoElement = root.getChild("Video", ns);
                    if (videoElement != null && (videoCodecTypeElement = videoElement.getChild("videoCodecType", ns)) != null) {
                        String codec = videoCodecTypeElement.getText();
                        if (this.videoCodec == Codec.MJPEG && codec.toLowerCase().equals("h.264") || this.videoCodec == Codec.H264 && codec.toLowerCase().equals("mjpeg")) {
                            this.logger.info("Codec has been changed. Restarting camera...");
                            this.restartLater = true;
                        }
                    }
                    if ((audioElement = root.getChild("Audio", ns)) != null && (audioEnabledElement = audioElement.getChild("enabled", ns)) != null) {
                        String audioEnabledString = audioEnabledElement.getText();
                        if (this.isAudioEnabled && audioEnabledString.equals("false")) {
                            this.restartLater = true;
                        }
                    }
                    if (Integer.parseInt(root.getChild("Transport", ns).getChild("rtspPortNo", ns).getText()) != this.rtspPort) {
                        this.logger.info("RTSP Port was changed. Camera will be restarted...");
                        this.restartLater = true;
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.error("Error while retrieving streaming data for " + this + ": " + ex.getMessage());
                }
                catch (JDOMException ex) {
                    this.logger.error("Exception while reading xml: " + ex.getMessage() + " for " + this);
                }
                this.parameterString = "<StreamingChannel version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\"><id>" + videoSourceAndStream + "</id><channelName></channelName><enabled>true</enabled><Transport><rtspPortNo>" + this.rtspPort + "</rtspPortNo><maxPacketSize>1000</maxPacketSize><sourcePortNo>0</sourcePortNo><ControlProtocolList><ControlProtocol><streamingTransport>RTSP</streamingTransport></ControlProtocol></ControlProtocolList>";
                this.parameterString = this.parameterString + "<Unicast><enabled>true</enabled></Unicast><Multicast><enabled>false</enabled><destIPAddress>0.0.0.0</destIPAddress><destPortNo>0</destPortNo></Multicast>";
                this.parameterString = this.parameterString + "</Transport><Video><enabled>true</enabled>";
                this.parameterString = this.parameterString + "<VideoInputChannelID>" + this.videoSourceNr + "</VideoInputChannelID><videoCodecType>" + (this.videoCodec == Codec.H264 ? "H.264" : "MJPEG") + "</videoCodecType><videoScanType>progressive</videoScanType><videoResolutionWidth>" + this.width + "</videoResolutionWidth><videoResolutionHeight>" + this.height + "</videoResolutionHeight>";
                if (this.videoCodec == Codec.H264) {
                    this.parameterString = !this.isConstantBitrateUsed ? this.parameterString + "<videoQualityControlType>VBR</videoQualityControlType>" : this.parameterString + "<videoQualityControlType>CBR</videoQualityControlType><constantBitRate>" + this.bitrate + "</constantBitRate>";
                } else if (this.videoCodec == Codec.MJPEG) {
                    this.parameterString = this.parameterString + "<videoQualityControlType>VBR</videoQualityControlType>";
                }
                this.parameterString = this.parameterString + "<fixedQuality>" + this.defaultQuality + "</fixedQuality><maxFrameRate>" + this.defaultFps + "</maxFrameRate><keyFrameInterval>" + this.iFrameDist + "</keyFrameInterval><BPFrameInterval>2</BPFrameInterval><snapShotImageType>JPEG</snapShotImageType></Video>";
                if (this.videoCodec == Codec.H264) {
                    String codeAudio = "G.711ulaw";
                    if (this.isAudioEnabled && null != this.audioCodec) {
                        switch (this.audioCodec) {
                            case G711U: {
                                codeAudio = "G.711ulaw";
                                break;
                            }
                            case G711A: {
                                codeAudio = "G.711alaw";
                                break;
                            }
                            case PCM: {
                                codeAudio = "PCM";
                                break;
                            }
                            case G726: {
                                codeAudio = "G.726";
                                break;
                            }
                        }
                    }
                    this.parameterString = this.parameterString + "<Audio><enabled>" + (this.isAudioEnabled ? "true" : "false") + "</enabled><audioInputChannelID>1</audioInputChannelID><audioCompressionType>" + codeAudio + "</audioCompressionType></Audio>";
                }
                this.parameterString = this.parameterString + "</StreamingChannel>";
                try {
                    device.getHttpHandler().readGetRequest("/", true);
                    String deviceUrl = "/Streaming/channels/" + videoSourceAndStream;
                    device.getHttpHandler().readPutRequest(deviceUrl, this.parameterString, true);
                    if (this.restartLater && !HikvisionDevice.isSmartDriver(this.getHikvisionEntityType((HikvisionCameraSrv)this.getVideoSrv()))) {
                        this.rebootDevice();
                        this.shutdown();
                    }
                }
                catch (SeeTecException ex) {
                    this.logger.warn("Exception while sending camera configuration for " + this + ": " + ex.getMessage());
                    this.logger.warn("Trying to get image stream anyway...");
                }
                catch (Exception ex) {
                    this.logger.error("Exception while sending camera configuration for " + this + ": " + ex.getMessage());
                }
                this.errorCode = this.hikvisionCameraSrv.setGlobalParameters(this.useTitle, this.title, this.useDateTime, this.rotationAngle);
                if (this.errorCode != 0) {
                    this.logger.warn("Exception while setting title and date/time display for " + this + ". Errorcode: " + this.errorCode);
                    this.logger.warn("Trying to get image stream anyway...");
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.rtspSettings = new RTSPStreamSettings();
            this.networkParameter.setSoTimeout(tempTimeout);
            this.errorCode = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (this.errorCode != 0) {
                this.logger.error("Error while setting RTSP parameters for " + this);
                return this.errorCode;
            }
            this.rtspSettings.setUdpBuffer(65535);
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
            this.errorCode = this.rtspHandler.start();
            if (this.errorCode != 0) {
                this.logger.error("Error while starting RTSP Handler for " + this);
                return this.errorCode;
            }
            this.logger.info("init done for" + this.getVideoSrv());
            return 0;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public synchronized int shutdown() {
        if (this.getVideoSrv() != null) {
            ((HikvisionCameraSrv)this.getVideoSrv()).resetModelInformation();
        }
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int getMaxFps(String[] fpsStrings) {
        int fps = 1;
        if (fpsStrings != null) {
            for (String fpsString : fpsStrings) {
                try {
                    fps = Integer.parseInt(fpsString.trim()) > fps ? Integer.parseInt(fpsString.trim()) : fps;
                }
                catch (NumberFormatException nfe) {
                    this.logger.warn("Could not read fps as String for " + this + ": " + fpsString);
                }
            }
        }
        return fps;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        HikvisionDevice device = (HikvisionDevice)this.getVideoSrv().getDevice();
        device.resetHttpHandler();
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down" + this.getVideoSrv());
        this.shutdown();
    }

    @Override
    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    public int setCameraParameters(long fps) throws SAXException, JAXBException, SeeTecException {
        if (this.hikvisionCameraSrv == null) {
            this.hikvisionCameraSrv = (HikvisionCameraSrv)this.getVideoSrv();
        }
        HikvisionDevice device = (HikvisionDevice)this.hikvisionCameraSrv.getDevice();
        String videoSourceAndStream = String.valueOf(this.videoSourceNumber) + "0" + String.valueOf(this.streamNumber);
        StreamingChannel mainStream = device.getHikvisionObject(StreamingChannel.class, "/Streaming/channels/" + videoSourceAndStream + "/capabilities");
        int maxFrameRate = 0;
        if (mainStream != null) {
            String[] fpsString = mainStream.getVideo().getMaxFrameRate().getOpt().split(",");
            maxFrameRate = this.getMaxFps(fpsString);
        }
        String framerate = HikvisionCameraSrv.getFramerate(fps, maxFrameRate);
        String url = "/Streaming/channels/" + videoSourceAndStream;
        StringBuilder xmlContent = new StringBuilder();
        xmlContent.append("<?xml version='1.0' encoding='utf-8'?><StreamingChannel version=\"1.0\" xmlns=\"http://www.hikvision.com/ver10/XMLSchema\">");
        xmlContent.append("<id>");
        xmlContent.append(videoSourceAndStream);
        xmlContent.append("</id>");
        xmlContent.append("<channelName></channelName>");
        xmlContent.append("<enabled>true</enabled>");
        xmlContent.append("<Transport>");
        xmlContent.append("<rtspPortNo>");
        xmlContent.append(this.rtspPort);
        xmlContent.append("</rtspPortNo>");
        xmlContent.append("<maxPacketSize>1000</maxPacketSize>");
        xmlContent.append("<sourcePortNo>0</sourcePortNo>");
        xmlContent.append("<ControlProtocolList>");
        xmlContent.append("<ControlProtocol>");
        xmlContent.append("<streamingTransport>RTSP</streamingTransport>");
        xmlContent.append("</ControlProtocol>");
        xmlContent.append("</ControlProtocolList>");
        xmlContent.append("<Unicast>");
        xmlContent.append("<enabled>true</enabled>");
        xmlContent.append("</Unicast>");
        xmlContent.append("<Multicast>");
        xmlContent.append("<enabled>false</enabled>");
        xmlContent.append("<destIPAddress>0.0.0.0</destIPAddress>");
        xmlContent.append("<destPortNo>0</destPortNo>");
        xmlContent.append("</Multicast>");
        xmlContent.append("</Transport>");
        xmlContent.append("<Video>");
        xmlContent.append("<enabled>true</enabled>");
        xmlContent.append("<VideoInputChannelID>");
        xmlContent.append(this.videoSourceNr);
        xmlContent.append("</VideoInputChannelID>");
        xmlContent.append("<videoCodecType>");
        xmlContent.append(this.videoCodec == Codec.H264 ? "H.264" : "MJPEG");
        xmlContent.append("</videoCodecType>");
        xmlContent.append("<videoScanType>progressive</videoScanType>");
        xmlContent.append("<videoResolutionWidth>");
        xmlContent.append(this.width);
        xmlContent.append("</videoResolutionWidth>");
        xmlContent.append("<videoResolutionHeight>");
        xmlContent.append(this.height);
        xmlContent.append("</videoResolutionHeight>");
        if (this.videoCodec == Codec.H264) {
            if (!this.isConstantBitrateUsed) {
                xmlContent.append("<videoQualityControlType>VBR</videoQualityControlType>");
            } else {
                xmlContent.append("<videoQualityControlType>CBR</videoQualityControlType>");
                xmlContent.append("<constantBitRate>");
                xmlContent.append(this.bitrate);
                xmlContent.append("</constantBitRate>");
            }
        }
        xmlContent.append("<fixedQuality>");
        xmlContent.append(this.defaultQuality);
        xmlContent.append("</fixedQuality>");
        xmlContent.append("<maxFrameRate>");
        xmlContent.append(framerate);
        xmlContent.append("</maxFrameRate>");
        xmlContent.append("<keyFrameInterval>");
        xmlContent.append(this.iFrameDist);
        xmlContent.append("</keyFrameInterval>");
        xmlContent.append("<BPFrameInterval>2</BPFrameInterval>");
        xmlContent.append("<snapShotImageType>JPEG</snapShotImageType>");
        xmlContent.append("</Video>");
        String codeAudio = "G.711ulaw";
        if (null != this.audioCodec) {
            switch (this.audioCodec) {
                case G711U: {
                    codeAudio = "G.711ulaw";
                    break;
                }
                case G711A: {
                    codeAudio = "G.711alaw";
                    break;
                }
                case PCM: {
                    codeAudio = "PCM";
                    break;
                }
                case G726: {
                    codeAudio = "G.726";
                    break;
                }
            }
        }
        xmlContent.append("<Audio>");
        xmlContent.append("<enabled>false</enabled>");
        xmlContent.append("<audioInputChannelID>1</audioInputChannelID>");
        xmlContent.append("<audioCompressionType>").append(codeAudio).append("</audioCompressionType>");
        xmlContent.append("</Audio>");
        xmlContent.append("</StreamingChannel>");
        try {
            device.getHttpHandler().readPutRequest(url, xmlContent.toString(), true);
        }
        catch (Exception ex) {
            this.logger.error("Exception while setting framerate for " + this + ": " + ex.getMessage());
            this.logger.error("url: " + url);
            this.logger.error("content: " + xmlContent.toString());
            return -20100;
        }
        return 0;
    }

    public long getMilliCompression() {
        return this.quality;
    }

    private long getHikvisionEntityType(HikvisionCameraSrv hikvisionCameraSrv) {
        return hikvisionCameraSrv.getDevice().getDeviceEntity().getEntityType();
    }

    private int getVideoStreamNumber() {
        int streamNumber;
        if (this.videoCodec == Codec.RTSP) {
            streamNumber = 1;
        } else if (HikvisionDevice.isSmartDriver(this.getHikvisionEntityType((HikvisionCameraSrv)this.getVideoSrv()))) {
            streamNumber = this.determineChannelId();
        } else {
            ((HikvisionCameraSrv)this.getVideoSrv()).setModelInformation(this.width, this.height);
            streamNumber = ((HikvisionCameraSrv)this.getVideoSrv()).getStreamNumber(this.listener);
        }
        return streamNumber;
    }

    private int determineChannelId() {
        int channelId = 1;
        try {
            String streamName = this.listener.getVideoSourceParameter().getStreamName();
            channelId = streamName.endsWith("1") ? 1 : 2;
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn("Could not read stream name from configuration for " + this);
        }
        return channelId;
    }

    private void rebootDevice() {
        try {
            HikvisionDevice device = (HikvisionDevice)this.hikvisionCameraSrv.getDevice();
            device.getHttpHandler().readPutRequest("/System/reboot", "");
            boolean reachable = true;
            while (reachable) {
                try {
                    Socket socket = new Socket();
                    socket.connect(new InetSocketAddress(this.networkParameter.getHost(), this.networkParameter.useHTTPS() ? this.networkParameter.getSSLport() : this.networkParameter.getHTTPport()), 5000);
                    socket.close();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    reachable = false;
                }
            }
        }
        catch (SeeTecException seeTecException) {
            this.logger.info("Could not reboot for " + this.getVideoSrv().getDevice());
        }
    }
}

